/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.platformlabeler;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.remoting.Callable;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.security.Roles;
import org.jenkinsci.remoting.RoleChecker;
import org.jenkinsci.remoting.RoleSensitive;
import org.jvnet.hudson.plugins.platformlabeler.LsbRelease;
import org.jvnet.hudson.plugins.platformlabeler.PlatformDetails;
import org.jvnet.hudson.plugins.platformlabeler.PlatformDetailsRelease;
import org.jvnet.hudson.plugins.platformlabeler.WindowsRelease;

class PlatformDetailsTask
implements Callable<PlatformDetails, IOException> {
    private static final Logger LOGGER = Logger.getLogger(PlatformDetailsTask.class.getName());
    private static final String RELEASE = "release";
    private static final String VERSION = "VERSION =";
    private static final String PATCHLEVEL = "PATCHLEVEL =";
    static final String UNKNOWN_VALUE_STRING = "unknown+check_lsb_release_installed";
    static final String UNKNOWN_WINDOWS_VALUE_STRING = "unknown+check_reg_query_installed";
    private static final long serialVersionUID = 2000L;
    private static final Map<String, String> PREFERRED_LINUX_OS_NAMES = new HashMap<String, String>();
    private File osRelease = new File("/etc/os-release");
    private File debianVersion = new File("/etc/debian_version");
    private File redhatRelease = new File("/etc/redhat-release");
    private File suseRelease = new File("/etc/SuSE-release");

    PlatformDetailsTask() {
    }

    public void checkRoles(RoleChecker checker) throws SecurityException {
        checker.check((RoleSensitive)this, Roles.SLAVE);
    }

    public PlatformDetails call() throws IOException {
        String arch = System.getProperty("os.arch", UNKNOWN_VALUE_STRING);
        String name = System.getProperty("os.name", UNKNOWN_VALUE_STRING);
        String version = System.getProperty("os.version", UNKNOWN_VALUE_STRING);
        return this.computeLabels(arch, name, version);
    }

    private boolean equalsIgnoreCase(@NonNull String s1, @NonNull String s2) {
        return s1.equalsIgnoreCase(s2);
    }

    @NonNull
    protected String checkWindows32Bit(@NonNull String arch, @NonNull String env1, @NonNull String env2) {
        if (!this.equalsIgnoreCase("x86", arch)) {
            return arch;
        }
        if (this.equalsIgnoreCase("amd64", env1) || this.equalsIgnoreCase("amd64", env2)) {
            return "amd64";
        }
        return arch;
    }

    @NonNull
    private String getCanonicalLinuxArch(@NonNull String arch) {
        String string;
        block9: {
            if (!this.equalsIgnoreCase("x86", arch)) {
                return arch;
            }
            Process p = Runtime.getRuntime().exec("/bin/uname -m");
            p.waitFor();
            InputStream stream = p.getInputStream();
            try {
                string = this.getCanonicalLinuxArchStream(stream, arch);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | InterruptedException e) {
                    LOGGER.log(Level.FINEST, "uname -m failed", e);
                    return arch;
                }
            }
            stream.close();
        }
        return string;
    }

    String getCanonicalLinuxArchStream(@NonNull InputStream stream, @NonNull String arch) throws IOException {
        try (BufferedReader b = new BufferedReader(new InputStreamReader(stream, "UTF-8"));){
            String line = b.readLine();
            if (line != null) {
                if ("x86_64".equals(line)) {
                    String string = "amd64";
                    return string;
                }
                String string = line;
                return string;
            }
        }
        return arch;
    }

    @NonNull
    protected PlatformDetails computeLabels(@NonNull String arch, @NonNull String name, @NonNull String version) throws IOException {
        if (name.toLowerCase(Locale.ENGLISH).startsWith("linux")) {
            return this.computeLabels(arch, name, version, new LsbRelease());
        }
        if (name.toLowerCase(Locale.ENGLISH).startsWith("windows")) {
            return this.computeLabels(arch, name, version, new WindowsRelease());
        }
        return this.computeLabels(arch, name, version, null);
    }

    private String toLowerCase(@NonNull String s1) {
        return s1.toLowerCase(Locale.ENGLISH);
    }

    @NonNull
    @SuppressFBWarnings(value={"ENV_USE_PROPERTY_INSTEAD_OF_ENV"}, justification="Use env for compatibility")
    protected PlatformDetails computeLabels(@NonNull String arch, @NonNull String name, @NonNull String version, @CheckForNull PlatformDetailsRelease release) throws IOException {
        String computedName = this.toLowerCase(name);
        String computedArch = arch;
        String computedVersion = version;
        String windowsFeatureUpdate = null;
        String osName = name;
        if (computedName.startsWith("windows")) {
            computedName = "windows";
            computedArch = this.checkWindows32Bit(computedArch, System.getenv("PROCESSOR_ARCHITECTURE"), System.getenv("PROCESSOR_ARCHITEW6432"));
            if (computedVersion.startsWith("4.0")) {
                computedVersion = "nt4";
            } else if (computedVersion.startsWith("5.0")) {
                computedVersion = "2000";
            } else if (computedVersion.startsWith("5.1")) {
                computedVersion = "xp";
            } else if (computedVersion.startsWith("5.2")) {
                computedVersion = "2003";
            }
            boolean recentWindows = computedVersion.startsWith("10");
            if (release != null && recentWindows && (windowsFeatureUpdate = release.release()).isEmpty()) {
                windowsFeatureUpdate = null;
            }
            if (osName.startsWith("Windows Server")) {
                osName = osName.contains("2025") ? "WindowsServer2025" : (osName.contains("2022") ? "WindowsServer2022" : (osName.contains("2019") ? "WindowsServer2019" : (osName.contains("2016") ? "WindowsServer2016" : "WindowsServer")));
            }
            if (osName.startsWith("Windows 1")) {
                osName = osName.replace(" ", "");
            }
        } else if (computedName.startsWith("linux")) {
            if (release == null) {
                release = new LsbRelease();
            }
            computedName = release.distributorId();
            computedArch = this.getCanonicalLinuxArch(computedArch);
            computedVersion = release.release();
            if (computedName.equals(UNKNOWN_VALUE_STRING)) {
                computedName = this.getReleaseIdentifier("ID");
            }
            if (computedVersion.equals(UNKNOWN_VALUE_STRING)) {
                computedVersion = this.getReleaseIdentifier("VERSION_ID");
            }
            if (computedVersion.equals(UNKNOWN_VALUE_STRING)) {
                computedVersion = this.getReleaseIdentifier("BUILD_ID");
            }
            if (computedName.equals(UNKNOWN_VALUE_STRING)) {
                computedName = this.getRedhatReleaseIdentifier("ID");
            }
            if (computedVersion.equals(UNKNOWN_VALUE_STRING)) {
                computedVersion = this.getRedhatReleaseIdentifier("VERSION_ID");
            }
            if (this.equalsIgnoreCase(computedName, "debian") && computedVersion.equals(UNKNOWN_VALUE_STRING)) {
                computedVersion = this.getDebianVersionIdentifier();
            }
            if (this.equalsIgnoreCase(computedName, "debian") && this.equalsIgnoreCase(computedVersion, "n/a")) {
                computedVersion = "unstable";
            }
            if (computedVersion.contains("/")) {
                int slashLocation = computedVersion.indexOf("/");
                computedVersion = computedVersion.substring(0, slashLocation);
            }
            if (computedName.equals(UNKNOWN_VALUE_STRING)) {
                computedName = this.getSuseReleaseIdentifier("ID");
            }
            if (this.equalsIgnoreCase(computedName, "linuxmint")) {
                computedName = this.getLinuxMintVersionIdentifier(computedVersion);
            }
            if (computedName.equals("SUSE LINUX")) {
                computedName = "SUSE";
                try {
                    String newVersion;
                    String integerPortion = computedVersion.replaceAll("([0-9]+)([.][0-9]+)*", "$1");
                    int intVersion = Integer.parseInt(integerPortion);
                    if (intVersion <= 11 && !(newVersion = this.getSuseReleaseIdentifier("VERSION_ID")).equals(UNKNOWN_VALUE_STRING)) {
                        computedVersion = newVersion;
                    }
                }
                catch (NumberFormatException nfe) {
                    LOGGER.log(Level.FINEST, "number format exception", nfe);
                }
            }
            if (computedVersion.equals(UNKNOWN_VALUE_STRING)) {
                computedVersion = this.getSuseReleaseIdentifier("VERSION_ID");
            }
        } else if (computedName.startsWith("freebsd")) {
            computedVersion = this.getFreeBsdVersion(computedVersion);
        } else if (computedName.startsWith("mac")) {
            computedName = "mac";
        }
        PlatformDetails properties = new PlatformDetails(computedName, computedArch, computedVersion, windowsFeatureUpdate, osName);
        return properties;
    }

    void setOsReleaseFile(File osRelease) {
        this.osRelease = osRelease;
    }

    void setRedhatRelease(File redhatRelease) {
        this.redhatRelease = redhatRelease;
    }

    void setSuseRelease(File suseRelease) {
        this.suseRelease = suseRelease;
    }

    void setDebianVersion(File debianVersion) {
        this.debianVersion = debianVersion;
    }

    @NonNull
    String getReleaseIdentifier(@NonNull String field) {
        String value = UNKNOWN_VALUE_STRING;
        if (this.osRelease == null) {
            return value;
        }
        try (BufferedReader br = new BufferedReader(Files.newBufferedReader(this.osRelease.toPath(), StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                if (!line.startsWith(field + "=")) continue;
                String[] parts = line.split("=");
                value = parts[1].replace("\"", "").trim();
            }
        }
        catch (IOException notFound) {
            LOGGER.log(Level.FINEST, "os-release not found", notFound);
        }
        return PREFERRED_LINUX_OS_NAMES.getOrDefault(value, value);
    }

    @NonNull
    String getRedhatReleaseIdentifier(@NonNull String field) {
        String value = UNKNOWN_VALUE_STRING;
        if (this.redhatRelease == null) {
            return value;
        }
        try (BufferedReader br = new BufferedReader(Files.newBufferedReader(this.redhatRelease.toPath(), StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                if (!line.contains(RELEASE)) continue;
                if (field.equals("ID")) {
                    value = line.substring(0, line.indexOf(RELEASE)).trim();
                }
                if (!field.equals("VERSION_ID")) continue;
                value = line.substring(line.indexOf(RELEASE) + RELEASE.length(), line.indexOf("(")).trim();
            }
        }
        catch (IOException notFound) {
            LOGGER.log(Level.FINEST, "redhat-release not found", notFound);
        }
        return PREFERRED_LINUX_OS_NAMES.getOrDefault(value, value);
    }

    @NonNull
    String getSuseReleaseIdentifier(@NonNull String field) {
        Object value = UNKNOWN_VALUE_STRING;
        String version = null;
        String patchLevel = null;
        String name = UNKNOWN_VALUE_STRING;
        Pattern pattern = Pattern.compile("^(SUSE.*?)\\d+.*$");
        if (this.suseRelease == null) {
            return value;
        }
        try (BufferedReader br = new BufferedReader(Files.newBufferedReader(this.suseRelease.toPath(), StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                Matcher matcher;
                if (line.startsWith(VERSION)) {
                    version = line.substring(VERSION.length()).trim();
                }
                if (line.startsWith(PATCHLEVEL)) {
                    patchLevel = line.substring(PATCHLEVEL.length()).trim();
                }
                if (!(matcher = pattern.matcher(line.trim())).matches()) continue;
                name = matcher.group(1).trim();
            }
        }
        catch (IOException notFound) {
            return value;
        }
        if (field.equals("ID")) {
            value = name;
        }
        if (field.equals("VERSION_ID")) {
            if (version == null) {
                return value;
            }
            value = version;
            if (patchLevel != null) {
                value = (String)value + "." + patchLevel;
            }
        }
        return PREFERRED_LINUX_OS_NAMES.getOrDefault(value, (String)value);
    }

    @NonNull
    String getDebianVersionIdentifier() {
        if (this.debianVersion != null) {
            String string;
            BufferedReader br = new BufferedReader(Files.newBufferedReader(this.debianVersion.toPath(), StandardCharsets.UTF_8));
            try {
                String line = br.readLine();
                string = line != null ? line.trim() : UNKNOWN_VALUE_STRING;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException notFound) {
                    return UNKNOWN_VALUE_STRING;
                }
            }
            br.close();
            return string;
        }
        return UNKNOWN_VALUE_STRING;
    }

    @NonNull
    String getFreeBsdVersion(String version) {
        try {
            Process p = Runtime.getRuntime().exec("/bin/freebsd-version -u");
            p.waitFor();
            try (InputStream stream = p.getInputStream();
                 BufferedReader b = new BufferedReader(new InputStreamReader(stream, "UTF-8"));){
                String line = b.readLine();
                if (line != null) {
                    version = line;
                }
            }
        }
        catch (IOException | InterruptedException e) {
            LOGGER.log(Level.FINEST, "freebsd version exception", e);
        }
        return version;
    }

    private String getLinuxMintVersionIdentifier(String version) {
        if (version.startsWith("19")) {
            return "LinuxMint";
        }
        return "Linuxmint";
    }

    static {
        PREFERRED_LINUX_OS_NAMES.put("alinux", "AlibabaCloud");
        PREFERRED_LINUX_OS_NAMES.put("almalinux", "Alma");
        PREFERRED_LINUX_OS_NAMES.put("AlmaLinux", "Alma");
        PREFERRED_LINUX_OS_NAMES.put("alpine", "Alpine");
        PREFERRED_LINUX_OS_NAMES.put("amzn", "Amazon");
        PREFERRED_LINUX_OS_NAMES.put("centos", "CentOS");
        PREFERRED_LINUX_OS_NAMES.put("debian", "Debian");
        PREFERRED_LINUX_OS_NAMES.put("eurolinux", "EuroLinux");
        PREFERRED_LINUX_OS_NAMES.put("fedora", "Fedora");
        PREFERRED_LINUX_OS_NAMES.put("linuxmint-old", "LinuxMint");
        PREFERRED_LINUX_OS_NAMES.put("linuxmintd", "Linuxmint");
        PREFERRED_LINUX_OS_NAMES.put("ol", "OracleServer");
        PREFERRED_LINUX_OS_NAMES.put("opensuse", "openSUSE");
        PREFERRED_LINUX_OS_NAMES.put("opensuse-leap", "openSUSE");
        PREFERRED_LINUX_OS_NAMES.put("opensuse-tumbleweed", "openSUSE");
        PREFERRED_LINUX_OS_NAMES.put("raspbian", "Raspbian");
        PREFERRED_LINUX_OS_NAMES.put("rocky", "Rocky");
        PREFERRED_LINUX_OS_NAMES.put("Rocky Linux", "Rocky");
        PREFERRED_LINUX_OS_NAMES.put("Red Hat Enterprise Linux", "RedHatEnterprise");
        PREFERRED_LINUX_OS_NAMES.put("Red Hat Enterprise Linux Server", "RedHatEnterprise");
        PREFERRED_LINUX_OS_NAMES.put("rhel", "RedHatEnterprise");
        PREFERRED_LINUX_OS_NAMES.put("sles", "SUSE");
        PREFERRED_LINUX_OS_NAMES.put("SUSE Linux Enterprise Server", "SUSE");
        PREFERRED_LINUX_OS_NAMES.put("ubuntu", "Ubuntu");
    }
}

