/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.platformlabeler;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jvnet.hudson.plugins.platformlabeler.PlatformDetailsRelease;

public class LsbRelease
implements PlatformDetailsRelease {
    @NonNull
    private final String distributorId;
    @NonNull
    private final String release;
    private static final Logger LOGGER = Logger.getLogger(LsbRelease.class.getName());
    private static final String APT_CACHE_POLICY_SID = " sid/";
    private static final String APT_CACHE_POLICY_TESTING = " testing/";
    private static final String APT_CACHE_POLICY_UNSTABLE = " unstable/";
    private List<String> aptCacheIdentifiers = Arrays.asList(" sid/", " testing/", " unstable/");

    public LsbRelease() {
        HashMap<String, String> newProps = new HashMap<String, String>();
        try {
            Process process = new ProcessBuilder("lsb_release", "-a").start();
            try (InputStream stream = process.getInputStream();){
                this.readLsbReleaseOutput(stream, newProps);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINEST, "lsb_release execution failed", e);
        }
        this.distributorId = newProps.getOrDefault("Distributor ID", "unknown+check_lsb_release_installed");
        String guessedRelease = newProps.getOrDefault("Release", "unknown+check_lsb_release_installed");
        if (this.distributorId.equals("Debian")) {
            String aptCacheRelease = this.readAptCachePolicy(guessedRelease);
            if (guessedRelease.equals("n/a") || !aptCacheRelease.equals("unknown+check_lsb_release_installed")) {
                guessedRelease = aptCacheRelease;
            }
        }
        this.release = guessedRelease;
    }

    LsbRelease(@NonNull String distributorId, @NonNull String release) {
        this.distributorId = distributorId;
        this.release = release;
    }

    LsbRelease(@NonNull File lsbReleaseFile) throws IOException {
        HashMap<String, String> newProps = new HashMap<String, String>();
        try (FileInputStream stream = new FileInputStream(lsbReleaseFile);){
            this.readLsbReleaseOutput(stream, newProps);
        }
        this.distributorId = newProps.getOrDefault("Distributor ID", "unknown+check_lsb_release_installed");
        String guessedRelease = newProps.getOrDefault("Release", "unknown+check_lsb_release_installed");
        if (this.distributorId.equals("Debian")) {
            String aptCacheRelease = this.readAptCachePolicy(lsbReleaseFile);
            if (guessedRelease.equals("n/a") || !aptCacheRelease.equals("unknown+check_lsb_release_installed")) {
                guessedRelease = aptCacheRelease;
            }
        }
        this.release = guessedRelease;
    }

    private void readLsbReleaseOutput(InputStream inputStream, Map<String, String> newProps) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            reader.lines().filter(s -> s.contains(":")).map(line -> line.split(":", 2)).forEach(parts -> newProps.put(parts[0], parts[1].trim()));
        }
    }

    private String readAptCachePolicy(@NonNull File testData) {
        String unstableDir = File.separator + "unstable" + File.separator;
        String testingDir = File.separator + "testing" + File.separator;
        if (testData.getPath().contains(unstableDir)) {
            return "unstable";
        }
        if (testData.getPath().contains(testingDir)) {
            return "testing";
        }
        return "unknown+check_lsb_release_installed";
    }

    private String readAptCachePolicy(@NonNull String defaultValue) {
        String value = defaultValue;
        try {
            Process process = new ProcessBuilder("apt-cache", "policy", "base-files").start();
            try (InputStream stream = process.getInputStream();){
                value = this.readReleaseFromAptCachePolicyOutput(stream);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINEST, "apt-cache execution failed", e);
        }
        return value;
    }

    private String readReleaseFromAptCachePolicyOutput(InputStream inputStream) throws IOException {
        List results;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            results = reader.lines().filter(line -> this.aptCacheIdentifiers.stream().anyMatch(line::contains)).collect(Collectors.toList());
        }
        if (results.isEmpty()) {
            LOGGER.log(Level.FINEST, "empty apt-cache policy, not testing, sid, or unstable");
            return "unknown+check_lsb_release_installed";
        }
        if (((String)results.get(0)).contains(APT_CACHE_POLICY_TESTING)) {
            LOGGER.log(Level.FINEST, "apt-cache policy is testing");
            return "testing";
        }
        if (((String)results.get(0)).contains(APT_CACHE_POLICY_UNSTABLE)) {
            LOGGER.log(Level.FINEST, "apt-cache policy is unstable");
            return "unstable";
        }
        if (((String)results.get(0)).contains(APT_CACHE_POLICY_SID)) {
            LOGGER.log(Level.FINEST, "apt-cache policy is sid");
            return "unstable";
        }
        LOGGER.log(Level.FINEST, "unexpected non-empty apt-cache policy, not testing, sid, or unstable");
        return "unknown+check_lsb_release_installed";
    }

    @Override
    @NonNull
    public String distributorId() {
        return this.distributorId;
    }

    @Override
    @NonNull
    public String release() {
        return this.release;
    }
}

