/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.platformlabeler;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.jvnet.hudson.plugins.platformlabeler.PlatformDetailsRelease;

public class WindowsRelease
implements PlatformDetailsRelease {
    @NonNull
    private final String release;

    public WindowsRelease() {
        HashMap<String, String> newProps = new HashMap<String, String>();
        try {
            Process process = new ProcessBuilder("REG", "QUERY", "HKLM\\Software\\Microsoft\\Windows NT\\CurrentVersion", "/t", "REG_SZ", "/v", "ReleaseId").start();
            try (InputStream stream = process.getInputStream();){
                this.readWindowsReleaseOutput(stream, newProps);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.release = newProps.getOrDefault("ReleaseId", "unknown+check_reg_query_installed");
    }

    WindowsRelease(File windowsReleaseFile) throws IOException {
        HashMap<String, String> newProps = new HashMap<String, String>();
        try (FileInputStream stream = new FileInputStream(windowsReleaseFile);){
            this.readWindowsReleaseOutput(stream, newProps);
        }
        this.release = newProps.getOrDefault("ReleaseId", "unknown+check_reg_query_installed");
    }

    private void readWindowsReleaseOutput(InputStream inputStream, Map<String, String> newProps) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            reader.lines().filter(s -> s.contains("REG_SZ")).map(line -> line.split("REG_SZ", 2)).forEach(parts -> newProps.put(parts[0].trim(), parts[1].trim()));
        }
    }

    @Override
    @NonNull
    public String release() {
        return this.release;
    }

    @Override
    @NonNull
    public String distributorId() {
        return "Microsoft";
    }
}

