/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.platformlabeler;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.model.labels.LabelAtom;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import hudson.slaves.ComputerListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import org.jvnet.hudson.plugins.platformlabeler.LabelConfig;
import org.jvnet.hudson.plugins.platformlabeler.PlatformDetails;
import org.jvnet.hudson.plugins.platformlabeler.PlatformDetailsTask;
import org.jvnet.hudson.plugins.platformlabeler.PlatformLabelerGlobalConfiguration;
import org.jvnet.hudson.plugins.platformlabeler.PlatformLabelerNodeProperty;

@Extension
public class NodeLabelCache
extends ComputerListener {
    private static transient Map<Computer, PlatformDetails> nodePlatformProperties = Collections.synchronizedMap(new WeakHashMap());
    static transient Map<Node, Collection<LabelAtom>> nodeLabels = new WeakHashMap<Node, Collection<LabelAtom>>();
    private static final transient Logger LOGGER = Logger.getLogger("org.jvnet.hudson.plugins.platformlabeler");

    public final void preOnline(Computer computer, Channel channel, FilePath root, TaskListener listener) throws IOException, InterruptedException {
        try {
            this.cacheAndRefreshModel(computer, (VirtualChannel)channel);
            this.saveNodeLabel(computer.getNode());
        }
        catch (Exception e) {
            String name = "unnamed agent";
            if (computer != null && !computer.getName().isEmpty()) {
                name = computer.getName();
            }
            listener.getLogger().println("Ignored platform detail collection failure for '" + name + "' during preOnline phase. " + String.valueOf(e));
        }
    }

    public final void onOnline(Computer computer, TaskListener ignored) throws IOException, InterruptedException {
        if (nodePlatformProperties.get(computer) == null) {
            this.cacheAndRefreshModel(computer, computer.getChannel());
        }
    }

    public final void cacheAndRefreshModel(Computer computer, VirtualChannel channel) throws IOException, InterruptedException {
        this.cacheLabels(computer, channel);
        this.refreshModel(computer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onConfigurationChange() {
        LOGGER.log(Level.FINEST, "onConfigurationChange() called to refresh platform labels");
        Map<Computer, PlatformDetails> map = nodePlatformProperties;
        synchronized (map) {
            nodePlatformProperties.forEach((node, labels) -> this.refreshModel((Computer)node));
        }
    }

    final void cacheLabels(Computer computer, VirtualChannel channel) throws IOException, InterruptedException {
        nodePlatformProperties.put(computer, this.requestComputerPlatformDetails(computer, channel));
    }

    private void logUpdateNodeException(Node node, IOException e) {
        LOGGER.log(Level.FINE, "Exception updating node '%s' during label refresh".formatted(node.getDisplayName()), e);
    }

    private void logUpdateNodeResult(boolean result, Node node, Set<LabelAtom> assignedLabels) {
        LOGGER.log(Level.FINEST, "Update of node '%s' %s with assigned labels %s".formatted(node.getDisplayName(), result ? "succeeded" : "failed", Arrays.toString(assignedLabels.toArray())));
    }

    final void refreshModel(Computer computer) {
        Node node;
        if (computer != null && (node = computer.getNode()) != null) {
            Collection<LabelAtom> labels = this.getLabelsForNode(node);
            nodeLabels.put(node, labels);
            node.getAssignedLabels();
        }
    }

    final void saveNodeLabel(Node node) {
        if (node == null) {
            LOGGER.log(Level.FINEST, "Node is null. Unable to save labels and update node.");
            return;
        }
        Set assignedLabels = node.getAssignedLabels();
        try {
            boolean result = Jenkins.get().updateNode(node);
            this.logUpdateNodeResult(result, node, assignedLabels);
        }
        catch (IOException e) {
            this.logUpdateNodeException(node, e);
        }
    }

    @NonNull
    PlatformDetails requestComputerPlatformDetails(Computer computer, VirtualChannel channel) throws IOException, InterruptedException {
        if (computer == null || channel == null) {
            throw new IOException("No virtual channel available");
        }
        try {
            return (PlatformDetails)channel.call((Callable)new PlatformDetailsTask());
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to read labels", e);
            throw e;
        }
    }

    Collection<LabelAtom> getLabelsForNode(Node node) {
        HashSet<LabelAtom> result = new HashSet<LabelAtom>();
        Computer computer = node.toComputer();
        if (computer == null) {
            return result;
        }
        PlatformDetails pp = nodePlatformProperties.get(computer);
        LabelConfig labelConfig = this.getLabelConfig(node);
        Jenkins jenkins = Jenkins.get();
        if (pp == null) {
            return result;
        }
        if (labelConfig.isArchitecture()) {
            result.add(jenkins.getLabelAtom(pp.getArchitecture()));
        }
        if (labelConfig.isName()) {
            result.add(jenkins.getLabelAtom(pp.getName()));
        }
        if (labelConfig.isVersion()) {
            result.add(jenkins.getLabelAtom(pp.getVersion()));
        }
        if (labelConfig.isNameVersion()) {
            result.add(jenkins.getLabelAtom(pp.getNameVersion()));
        }
        if (labelConfig.isArchitectureName()) {
            result.add(jenkins.getLabelAtom(pp.getArchitectureName()));
        }
        if (labelConfig.isArchitectureNameVersion()) {
            result.add(jenkins.getLabelAtom(pp.getArchitectureNameVersion()));
        }
        if (labelConfig.isWindowsFeatureUpdate() && pp.getWindowsFeatureUpdate() != null) {
            result.add(jenkins.getLabelAtom(pp.getWindowsFeatureUpdate()));
        }
        if (labelConfig.isOsName() && pp.getOsName() != null) {
            result.add(jenkins.getLabelAtom(pp.getOsName()));
        }
        return result;
    }

    private LabelConfig getLabelConfig(Node node) {
        LabelConfig labelConfig = ((PlatformLabelerGlobalConfiguration)((Object)GlobalConfiguration.all().getInstance(PlatformLabelerGlobalConfiguration.class))).getLabelConfig();
        PlatformLabelerNodeProperty nodeProperty = (PlatformLabelerNodeProperty)node.getNodeProperty(PlatformLabelerNodeProperty.class);
        if (nodeProperty != null) {
            labelConfig = nodeProperty.getLabelConfig();
        }
        return new LabelConfig(labelConfig);
    }
}

