/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.platformlabeler;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Serializable;

public class PlatformDetails
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String architecture;
    private final String version;
    private final String windowsFeatureUpdate;
    private final String osName;
    private final String architectureNameVersion;
    private final String architectureName;
    private final String nameVersion;

    @Deprecated
    public PlatformDetails(@NonNull String name, @NonNull String architecture, @NonNull String version) {
        this(name, architecture, version, null, null);
    }

    public PlatformDetails(@NonNull String name, @NonNull String architecture, @NonNull String version, @CheckForNull String windowsFeatureUpdate) {
        this(name, architecture, version, windowsFeatureUpdate, null);
    }

    public PlatformDetails(@NonNull String name, @NonNull String architecture, @NonNull String version, @CheckForNull String windowsFeatureUpdate, @CheckForNull String osName) {
        this.name = name;
        this.architecture = architecture;
        this.version = version;
        this.architectureNameVersion = architecture + "-" + name + "-" + version;
        this.architectureName = architecture + "-" + name;
        this.nameVersion = name + "-" + version;
        String featureUpdate = windowsFeatureUpdate;
        if (featureUpdate != null && featureUpdate.isEmpty()) {
            featureUpdate = null;
        }
        this.windowsFeatureUpdate = featureUpdate;
        if (osName != null && osName.isEmpty()) {
            osName = null;
        }
        this.osName = osName;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getArchitecture() {
        return this.architecture;
    }

    @NonNull
    public String getVersion() {
        return this.version;
    }

    @NonNull
    public String getArchitectureNameVersion() {
        return this.architectureNameVersion;
    }

    @NonNull
    public String getArchitectureName() {
        return this.architectureName;
    }

    @NonNull
    public String getNameVersion() {
        return this.nameVersion;
    }

    @CheckForNull
    public String getWindowsFeatureUpdate() {
        return this.windowsFeatureUpdate;
    }

    @CheckForNull
    public String getOsName() {
        return this.osName;
    }
}

