/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.groovypostbuild;

import com.jenkinsci.plugins.badge.action.AbstractBadgeAction;
import com.jenkinsci.plugins.badge.action.BadgeAction;
import com.jenkinsci.plugins.badge.action.BadgeSummaryAction;
import groovy.lang.Binding;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Functions;
import hudson.Launcher;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import io.jenkins.plugins.ionicons.Ionicons;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SecureGroovyScript;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.jenkinsci.plugins.scriptsecurity.scripts.ClasspathEntry;
import org.jvnet.hudson.plugins.groovypostbuild.GroovyPostbuildDescriptor;
import org.jvnet.hudson.plugins.groovypostbuild.GroovyScriptPath;
import org.kohsuke.stapler.DataBoundConstructor;

public class GroovyPostbuildRecorder
extends Recorder
implements MatrixAggregatable {
    private static final Logger LOGGER = Logger.getLogger(GroovyPostbuildRecorder.class.getName());
    @Deprecated
    private String groovyScript;
    private SecureGroovyScript script;
    private final int behavior;
    @Deprecated
    private List<GroovyScriptPath> classpath;
    private final boolean runForMatrixParent;

    @DataBoundConstructor
    public GroovyPostbuildRecorder(SecureGroovyScript script, int behavior, boolean runForMatrixParent) {
        this.script = script.configuringWithNonKeyItem();
        this.behavior = behavior;
        this.runForMatrixParent = runForMatrixParent;
    }

    private Object readResolve() {
        if (this.groovyScript != null) {
            ArrayList<ClasspathEntry> cp = new ArrayList<ClasspathEntry>();
            if (this.classpath != null) {
                for (GroovyScriptPath gsp : this.classpath) {
                    try {
                        cp.add(new ClasspathEntry(gsp.path.getAbsolutePath()));
                    }
                    catch (MalformedURLException x) {
                        LOGGER.log(Level.WARNING, "cannot load " + String.valueOf(gsp.path), x);
                    }
                }
                this.classpath = null;
            }
            try {
                this.script = new SecureGroovyScript(this.groovyScript, false, cp).configuring(ApprovalContext.create());
            }
            catch (Descriptor.FormException ex) {
                LOGGER.log(Level.WARNING, "Failed to resolve groovy script during readResolve ", ex);
            }
            this.groovyScript = null;
        }
        return this;
    }

    public final Action getProjectAction(AbstractProject<?, ?> project) {
        return null;
    }

    public GroovyPostbuildDescriptor getDescriptor() {
        return (GroovyPostbuildDescriptor)super.getDescriptor();
    }

    public final boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        boolean scriptResult = true;
        LOGGER.fine("perform() called for script");
        LOGGER.fine("behavior: " + this.behavior);
        Result scriptFailureResult = Result.SUCCESS;
        switch (this.behavior) {
            case 0: {
                scriptFailureResult = Result.SUCCESS;
                break;
            }
            case 1: {
                scriptFailureResult = Result.UNSTABLE;
                break;
            }
            case 2: {
                scriptFailureResult = Result.FAILURE;
                break;
            }
            default: {
                scriptFailureResult = Result.SUCCESS;
            }
        }
        BadgeManager badgeManager = new BadgeManager((Run<?, ?>)build, (TaskListener)listener, scriptFailureResult);
        ClassLoader cl = Jenkins.getInstance().getPluginManager().uberClassLoader;
        Binding binding = new Binding();
        binding.setVariable("manager", (Object)badgeManager);
        try {
            this.script.evaluate(cl, binding);
        }
        catch (Exception e) {
            e.printStackTrace(listener.error("Failed to evaluate groovy script."));
            badgeManager.buildScriptFailed(e);
            scriptResult = false;
        }
        for (Run<?, ?> b : badgeManager.builds) {
            b.save();
        }
        return scriptResult || !scriptFailureResult.isWorseOrEqualTo(Result.FAILURE);
    }

    public final BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public SecureGroovyScript getScript() {
        return this.script;
    }

    public int getBehavior() {
        return this.behavior;
    }

    public boolean isRunForMatrixParent() {
        return this.runForMatrixParent;
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        if (!this.isRunForMatrixParent()) {
            return null;
        }
        return new MatrixAggregator(build, launcher, listener){

            public boolean endBuild() throws InterruptedException, IOException {
                return GroovyPostbuildRecorder.this.perform((AbstractBuild<?, ?>)this.build, this.launcher, this.listener);
            }
        };
    }

    public static class BadgeManager {
        private Run<?, ?> build;
        private final TaskListener listener;
        private final Result scriptFailureResult;
        private final Set<Run<?, ?>> builds = new HashSet();
        private EnvVars envVars;

        public BadgeManager(Run<?, ?> build, TaskListener listener, Result scriptFailureResult) {
            this.setBuild(build);
            try {
                this.envVars = build.getEnvironment(listener);
            }
            catch (InterruptedException e) {
                e.printStackTrace(listener.getLogger());
            }
            catch (IOException e) {
                e.printStackTrace(listener.getLogger());
            }
            this.listener = listener;
            this.scriptFailureResult = scriptFailureResult;
        }

        public EnvVars getEnvVars() {
            return this.envVars;
        }

        @Whitelisted
        public void println(String string) {
            this.listener.getLogger().println(string);
        }

        @Whitelisted
        public String getEnvVariable(String key) throws IOException, InterruptedException {
            return (String)this.envVars.get((Object)key);
        }

        @Deprecated
        public Hudson getHudson() {
            return (Hudson)this.getJenkins();
        }

        public Jenkins getJenkins() {
            return Jenkins.getInstance();
        }

        public Run<?, ?> getBuild() {
            return this.build;
        }

        public void setBuild(Run<?, ?> build) {
            if (build != null) {
                this.build = build;
                this.builds.add(build);
            }
        }

        public boolean setBuildNumber(int buildNumber) {
            Run newBuild = this.build.getParent().getBuildByNumber(buildNumber);
            this.setBuild(newBuild);
            return newBuild != null;
        }

        public TaskListener getListener() {
            return this.listener;
        }

        @Whitelisted
        public void addShortText(String text) {
            this.build.addAction((Action)new BadgeAction(null, null, text, null, null, null));
        }

        @Whitelisted
        public void addShortText(String text, String color, String background, String border, String borderColor) {
            String style = "border: " + (border != null ? border : "") + " solid " + (borderColor != null ? borderColor : "") + ";";
            if (background != null) {
                style = style + "background: " + background + ";";
            }
            if (color != null) {
                style = color.startsWith("jenkins-!-color") ? style + "color: var(--" + color.replaceFirst("jenkins-!-color", "") + ");" : (color.startsWith("jenkins-!-") ? style + "color: var(--" + color.replaceFirst("jenkins-!-", "") + ");" : style + "color: " + color + ";");
            }
            this.build.addAction((Action)new BadgeAction(null, null, text, null, style, null));
        }

        @Whitelisted
        public void addBadge(String icon, String text) {
            this.build.addAction((Action)new BadgeAction(null, icon, text, null, null, null));
        }

        @Whitelisted
        public void addBadge(String icon, String text, String link) {
            this.build.addAction((Action)new BadgeAction(null, icon, text, null, null, link));
        }

        @Whitelisted
        public void addInfoBadge(String text) {
            this.build.addAction((Action)new BadgeAction(null, Ionicons.getIconClassName((String)"information-circle"), text, null, "color: var(--blue)", null));
        }

        @Whitelisted
        public void addWarningBadge(String text) {
            this.build.addAction((Action)new BadgeAction(null, Ionicons.getIconClassName((String)"warning"), text, null, "color: var(--warning-color)", null));
        }

        @Whitelisted
        public void addErrorBadge(String text) {
            this.build.addAction((Action)new BadgeAction(null, Ionicons.getIconClassName((String)"remove-circle"), text, null, "color: var(--error-color)", null));
        }

        @Whitelisted
        public void addHtmlBadge(String html) {
            this.build.addAction((Action)new BadgeAction(null, null, html, null, null, null));
        }

        @Whitelisted
        public String getResult() {
            Result r = this.build.getResult();
            return r != null ? r.toString() : null;
        }

        @Whitelisted
        public void removeBadges() {
            List badgeActions = this.build.getActions(AbstractBadgeAction.class);
            for (AbstractBadgeAction a : badgeActions) {
                this.build.removeAction((Action)a);
            }
        }

        @Whitelisted
        public void removeBadge(int index) {
            List badgeActions = this.build.getActions(AbstractBadgeAction.class);
            if (index < 0 || index >= badgeActions.size()) {
                this.listener.error("Invalid badge index: " + index + ". Allowed values: 0 .. " + (badgeActions.size() - 1));
            } else {
                AbstractBadgeAction action = (AbstractBadgeAction)badgeActions.get(index);
                this.build.removeAction((Action)action);
            }
        }

        public BadgeSummaryAction createSummary(String icon) {
            BadgeSummaryAction action = new BadgeSummaryAction(null, icon, null, null, null, null);
            this.build.addAction((Action)action);
            return action;
        }

        public void removeSummaries() {
            List summaryActions = this.build.getActions(BadgeSummaryAction.class);
            for (BadgeSummaryAction a : summaryActions) {
                this.build.removeAction((Action)a);
            }
        }

        public void removeSummary(int index) {
            List summaryActions = this.build.getActions(BadgeSummaryAction.class);
            if (index < 0 || index >= summaryActions.size()) {
                this.listener.error("Invalid summary index: " + index + ". Allowed values: 0 .. " + (summaryActions.size() - 1));
            } else {
                BadgeSummaryAction action = (BadgeSummaryAction)summaryActions.get(index);
                this.build.removeAction((Action)action);
            }
        }

        @Whitelisted
        public void buildUnstable() {
            this.build.setResult(Result.UNSTABLE);
        }

        @Whitelisted
        public void buildFailure() {
            this.build.setResult(Result.FAILURE);
        }

        @Whitelisted
        public void buildSuccess() {
            this.build.setResult(Result.SUCCESS);
        }

        @Whitelisted
        public void buildAborted() {
            this.build.setResult(Result.ABORTED);
        }

        @Whitelisted
        public void buildNotBuilt() {
            this.build.setResult(Result.NOT_BUILT);
        }

        public void buildScriptFailed(Exception e) {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            boolean isError = this.scriptFailureResult.isWorseThan(Result.UNSTABLE);
            String icon = isError ? "error" : "warning";
            BadgeSummaryAction summary = this.createSummary(icon + ".gif");
            summary.setText("<b><font color=\"red\">Groovy script failed:</font></b><br><pre>" + String.valueOf(writer) + "</pre>");
            this.addShortText("Groovy", "black", isError ? "#FFE0E0" : "#FFFFC0", "1px", isError ? "#E08080" : "#C0C080");
            Result result = this.build.getResult();
            if (result == null || result.isBetterThan(this.scriptFailureResult)) {
                this.build.setResult(this.scriptFailureResult);
            }
        }

        @Whitelisted
        public boolean logContains(String regexp) {
            return this.getLogMatcher(regexp) != null;
        }

        @Deprecated
        public boolean contains(File f, String regexp) {
            return this.contains(f, Charset.defaultCharset(), regexp);
        }

        @Deprecated
        public boolean contains(File f, Charset charset, String regexp) {
            Matcher matcher = this.getMatcher(f, charset, regexp);
            return matcher != null && matcher.matches();
        }

        @Whitelisted
        public Matcher getLogMatcher(String regexp) {
            Matcher matcher;
            block8: {
                Reader r = this.build.getLogReader();
                try {
                    matcher = this.getMatcher(r, regexp);
                    if (r == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (r != null) {
                            try {
                                r.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        Functions.printStackTrace((Throwable)e, (PrintWriter)this.listener.error("Groovy Postbuild: logContains(\"" + regexp + "\") failed."));
                        this.buildScriptFailed(e);
                        return null;
                    }
                }
                r.close();
            }
            return matcher;
        }

        @Deprecated
        public Matcher getMatcher(File f, String regexp) {
            return this.getMatcher(f, Charset.defaultCharset(), regexp);
        }

        public Matcher getMatcher(Reader r, String regexp) {
            Matcher matcher = null;
            try (BufferedReader reader = new BufferedReader(r);){
                String line;
                Pattern pattern = this.compilePattern(regexp);
                while ((line = reader.readLine()) != null) {
                    Matcher m = pattern.matcher(line);
                    if (!m.matches()) continue;
                    matcher = m;
                    break;
                }
            }
            catch (IOException e) {
                Functions.printStackTrace((Throwable)e, (PrintWriter)this.listener.error("Groovy Postbuild: getMatcher(\u2026, \"" + regexp + "\") failed."));
                this.buildScriptFailed(e);
            }
            return matcher;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        @Deprecated
        public Matcher getMatcher(File f, Charset charset, String regexp) {
            LOGGER.fine("Searching for '" + regexp + "' in '" + String.valueOf(f) + "'.");
            try (FileInputStream is = new FileInputStream(f);){
                Matcher matcher;
                try (InputStreamReader r = new InputStreamReader((InputStream)is, charset);){
                    matcher = this.getMatcher(r, regexp);
                }
                return matcher;
            }
            catch (IOException e) {
                Functions.printStackTrace((Throwable)e, (PrintWriter)this.listener.error("Groovy Postbuild: getMatcher(\"" + String.valueOf(f) + "\", \"" + regexp + "\") failed."));
                this.buildScriptFailed(e);
                return null;
            }
        }

        private Pattern compilePattern(String regexp) throws AbortException {
            Pattern pattern;
            try {
                pattern = Pattern.compile(regexp);
            }
            catch (PatternSyntaxException e) {
                this.listener.getLogger().println("Groovy Postbuild: Unable to compile regular expression '" + regexp + "'");
                throw new AbortException();
            }
            return pattern;
        }

        @Whitelisted
        public boolean buildIsA(Class<? extends AbstractBuild<?, ?>> buildClass) {
            return buildClass.isInstance(this.getBuild());
        }
    }
}

