/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.chucknorris;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.chucknorris.FactGenerator;
import hudson.plugins.chucknorris.RoundhouseAction;
import hudson.plugins.chucknorris.Style;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.util.logging.Logger;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.DataBoundConstructor;

public class CordellWalkerRecorder
extends Recorder
implements SimpleBuildStep {
    private static final Logger LOGGER = Logger.getLogger(CordellWalkerRecorder.class.getName());
    private FactGenerator factGenerator;

    @DataBoundConstructor
    public CordellWalkerRecorder() {
        this(new FactGenerator());
    }

    public CordellWalkerRecorder(FactGenerator factGenerator) {
        this.factGenerator = factGenerator;
        LOGGER.fine("Chuck Norris is activated");
    }

    public final Action getProjectAction(AbstractProject<?, ?> project) {
        Result result;
        RoundhouseAction action = null;
        AbstractBuild build = project.getLastBuild();
        if (build != null && (result = build.getResult()) != null) {
            Style style = Style.get(result);
            String fact = this.factGenerator.random();
            action = new RoundhouseAction(style, fact);
        }
        return action;
    }

    public final boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        this.perform((Run<?, ?>)build);
        return true;
    }

    public final void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        this.perform(run);
    }

    public final BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public void perform(Run<?, ?> run) {
        Style style = Style.get(run.getResult());
        String fact = this.factGenerator.random();
        run.addAction((Action)new RoundhouseAction(style, fact));
    }
}

