/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition;

import com.google.common.base.Predicate;
import hudson.model.PasswordParameterDefinition;
import hudson.util.Secret;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.structs.describable.DescribableModel;
import org.jenkinsci.plugins.workflow.actions.LabelAction;
import org.jenkinsci.plugins.workflow.actions.ThreadNameAction;
import org.jenkinsci.plugins.workflow.cps.CpsThread;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.ForkScanner;
import org.jenkinsci.plugins.workflow.support.steps.StageStep;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class CommonUtils {
    public static Predicate<FlowNode> isStageWithOptionalName(final String stageName) {
        return new Predicate<FlowNode>(){

            public boolean apply(FlowNode input) {
                if (input != null) {
                    if (input instanceof StepStartNode && ((StepStartNode)input).getDescriptor() instanceof StageStep.DescriptorImpl && (stageName == null || input.getDisplayName().equals(stageName))) {
                        return true;
                    }
                    ThreadNameAction action = (ThreadNameAction)input.getAction(ThreadNameAction.class);
                    if (input.getAction(LabelAction.class) != null && action != null && (stageName == null || action.getThreadName().equals(stageName))) {
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public static Predicate<FlowNode> isStageWithOptionalName() {
        return CommonUtils.isStageWithOptionalName(null);
    }

    public static List<FlowNode> findPossiblyUnfinishedEndNodeForCurrentStage(String stageName, FlowExecution execution) {
        if (execution == null) {
            CpsThread thread = CpsThread.current();
            execution = thread.getExecution();
        }
        ForkScanner scanner = new ForkScanner();
        FlowNode stage = scanner.findFirstMatch((Collection)execution.getCurrentHeads(), null, CommonUtils.isStageWithOptionalName(stageName));
        FlowNode finalNode = execution.getCurrentHeads().stream().filter(h -> CommonUtils.isSomewhereWithinStage(stage).apply(h)).findFirst().orElse(null);
        return Arrays.asList(stage, finalNode);
    }

    public static List<FlowNode> findPossiblyUnfinishedEndNodeForCurrentStage(String stageName) {
        return CommonUtils.findPossiblyUnfinishedEndNodeForCurrentStage(stageName, null);
    }

    public static Predicate<FlowNode> isSomewhereWithinStage(final FlowNode stageStartNode) {
        return new Predicate<FlowNode>(){

            public boolean apply(FlowNode input) {
                if (input != null && stageStartNode instanceof BlockStartNode) {
                    return input.getEnclosingBlocks().contains(stageStartNode);
                }
                return false;
            }
        };
    }

    @Whitelisted
    @Restricted(value={NoExternalUse.class})
    public static <T> T instantiateDescribable(Class<T> c, Map<String, ?> args) {
        DescribableModel model = new DescribableModel(c);
        if (model.getType().equals(PasswordParameterDefinition.class) && model.getParameter("defaultValueAsSecret") != null) {
            args = CommonUtils.copyMapReplacingEntry(args, "defaultValue", "defaultValueAsSecret", String.class, Secret::fromString);
        }
        return (T)model.instantiate(args);
    }

    public static <T> Map<String, Object> copyMapReplacingEntry(Map<String, ?> map, String oldKey, String newKey, Class<T> requiredValueType, Function<T, Object> replacer) {
        TreeMap<String, Object> newMap = new TreeMap<String, Object>();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            if (entry.getKey().equals(oldKey) && requiredValueType.isInstance(entry.getValue())) {
                newMap.put(newKey, replacer.apply(requiredValueType.cast(entry.getValue())));
                continue;
            }
            newMap.put(entry.getKey(), entry.getValue());
        }
        return newMap;
    }
}

