/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.ast;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTElementContainer;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTMarkerInterface;
import org.jenkinsci.plugins.pipeline.modeldefinition.validator.ModelValidator;

public abstract class ModelASTElement
implements ModelASTMarkerInterface {
    private Object sourceLocation;

    ModelASTElement(Object sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    public Object getSourceLocation() {
        return this.sourceLocation;
    }

    public void setSourceLocation(Object sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    @Override
    @NonNull
    public abstract Object toJSON();

    @CheckForNull
    protected static Object toJSON(@CheckForNull ModelASTMarkerInterface item) {
        return item != null ? item.toJSON() : null;
    }

    @CheckForNull
    protected static Object toJSONCheckEmpty(@CheckForNull ModelASTElementContainer item) {
        return item != null && !item.isEmpty() ? item.toJSON() : null;
    }

    @NonNull
    protected static <T extends ModelASTMarkerInterface> JSONArray toJSONArray(@CheckForNull Collection<T> list) {
        JSONArray a = new JSONArray();
        if (list != null) {
            for (ModelASTMarkerInterface item : list) {
                a.add(ModelASTElement.toJSON(item));
            }
        }
        return a;
    }

    @NonNull
    protected static <K extends ModelASTMarkerInterface, V extends ModelASTMarkerInterface> JSONArray toJSONArray(@CheckForNull Map<K, V> map) {
        JSONArray a = new JSONArray();
        if (map != null) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                JSONObject o = new JSONObject();
                o.accumulate("key", ((ModelASTMarkerInterface)entry.getKey()).toJSON());
                o.accumulate("value", ((ModelASTMarkerInterface)entry.getValue()).toJSON());
                a.add((Object)o);
            }
        }
        return a;
    }

    @NonNull
    protected static <T extends ModelASTMarkerInterface> JSONObject toJSONObject(@NonNull String key, @CheckForNull Collection<T> list) {
        return new JSONObject().accumulate(key, (Object)ModelASTElement.toJSONArray(list));
    }

    @CheckForNull
    protected static <T extends Collection> T nullIfEmpty(@CheckForNull T list) {
        return list == null || list.isEmpty() ? null : (T)list;
    }

    @Override
    @NonNull
    public abstract String toGroovy();

    @NonNull
    protected static String toGroovy(@CheckForNull ModelASTMarkerInterface item) {
        return item != null ? item.toGroovy() : "";
    }

    @NonNull
    protected static String toGroovyCheckEmpty(@CheckForNull ModelASTElementContainer item) {
        return item != null && !item.isEmpty() ? item.toGroovy() : "";
    }

    @NonNull
    protected static <T extends ModelASTMarkerInterface> String toGroovy(List<T> list) {
        StringBuilder result = new StringBuilder();
        for (ModelASTMarkerInterface item : list) {
            result.append(item.toGroovy()).append("\n");
        }
        return result.toString();
    }

    @NonNull
    protected static <T extends ModelASTMarkerInterface> String toGroovyArgList(Collection<T> list) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (ModelASTMarkerInterface item : list) {
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            result.append(item.toGroovy());
        }
        return result.toString();
    }

    @NonNull
    protected static <K extends ModelASTMarkerInterface, V extends ModelASTMarkerInterface> String toGroovyArgList(Map<K, V> map, String separator) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            result.append(((ModelASTMarkerInterface)entry.getKey()).toGroovy()).append(separator).append(((ModelASTMarkerInterface)entry.getValue()).toGroovy());
        }
        return result.toString();
    }

    @NonNull
    protected static String toGroovyBlock(String name, ModelASTMarkerInterface item) {
        StringBuilder result = new StringBuilder();
        if (name != null) {
            result.append(name).append(" ");
        }
        result.append("{\n");
        result.append(ModelASTElement.toGroovy(item));
        result.append("}\n");
        return result.toString();
    }

    @NonNull
    protected static <T extends ModelASTMarkerInterface> String toGroovyBlock(String name, List<T> list) {
        StringBuilder result = new StringBuilder();
        if (name != null) {
            result.append(name).append(" ");
        }
        result.append("{\n");
        result.append(ModelASTElement.toGroovy(list));
        result.append("}\n");
        return result.toString();
    }

    @NonNull
    protected static <K extends ModelASTMarkerInterface, V extends ModelASTMarkerInterface> String toGroovyBlock(String name, Map<K, V> map, String separator) {
        StringBuilder result = new StringBuilder();
        if (name != null) {
            result.append(name).append(" ");
        }
        result.append("{\n");
        for (Map.Entry<K, V> entry : map.entrySet()) {
            result.append(((ModelASTMarkerInterface)entry.getKey()).toGroovy()).append(separator).append(((ModelASTMarkerInterface)entry.getValue()).toGroovy()).append('\n');
        }
        result.append("}\n");
        return result.toString();
    }

    @Override
    public void validate(@NonNull ModelValidator validator) {
    }

    protected static void validate(@NonNull ModelValidator validator, ModelASTMarkerInterface ... items) {
        if (items != null && items.length > 0) {
            ModelASTElement.validate(validator, Arrays.asList(items), new ModelASTMarkerInterface[0]);
        }
    }

    protected static <T extends ModelASTMarkerInterface> void validate(@NonNull ModelValidator validator, @CheckForNull List<T> list, ModelASTMarkerInterface ... items) {
        ModelASTElement.validate(validator, items);
        if (list != null) {
            for (ModelASTMarkerInterface item : list) {
                if (item == null) continue;
                item.validate(validator);
            }
        }
    }

    protected static <K extends ModelASTMarkerInterface, V extends ModelASTMarkerInterface> void validate(@NonNull ModelValidator validator, @CheckForNull Map<K, V> map, ModelASTMarkerInterface ... items) {
        ModelASTElement.validate(validator, items);
        if (map != null) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                ((ModelASTMarkerInterface)entry.getKey()).validate(validator);
                ((ModelASTMarkerInterface)entry.getValue()).validate(validator);
            }
        }
    }

    @Override
    public void removeSourceLocation() {
        this.sourceLocation = null;
    }

    protected static void removeSourceLocationsFrom(ModelASTMarkerInterface ... items) {
        if (items != null) {
            ModelASTElement.removeSourceLocationsFrom(Arrays.asList(items));
        }
    }

    protected static <T extends ModelASTMarkerInterface> void removeSourceLocationsFrom(@CheckForNull Collection<T> list) {
        if (list != null) {
            for (ModelASTMarkerInterface item : list) {
                if (item == null) continue;
                item.removeSourceLocation();
            }
        }
    }

    protected static <T extends ModelASTMarkerInterface> void removeSourceLocationsFrom(@CheckForNull Collection<T> list, ModelASTMarkerInterface ... items) {
        ModelASTElement.removeSourceLocationsFrom(items);
        ModelASTElement.removeSourceLocationsFrom(list);
    }

    protected static <K extends ModelASTMarkerInterface, V extends ModelASTMarkerInterface> void removeSourceLocationsFrom(@CheckForNull Map<K, V> map, ModelASTMarkerInterface ... items) {
        if (map != null) {
            ModelASTElement.removeSourceLocationsFrom(items);
            for (Map.Entry<K, V> entry : map.entrySet()) {
                ((ModelASTMarkerInterface)entry.getKey()).removeSourceLocation();
                ((ModelASTMarkerInterface)entry.getValue()).removeSourceLocation();
            }
        }
    }

    public String toString() {
        return "ModelASTElement{}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return ModelASTElement.class.hashCode();
    }
}

