/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.ast;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTElement;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTKey;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTValue;
import org.jenkinsci.plugins.pipeline.modeldefinition.validator.ModelValidator;

public class ModelASTAxis
extends ModelASTElement {
    private ModelASTKey name;
    private List<ModelASTValue> values = new ArrayList<ModelASTValue>();

    public ModelASTAxis(Object sourceLocation) {
        super(sourceLocation);
    }

    @NonNull
    public JSONObject toJSON() {
        return new JSONObject().accumulate("name", ModelASTAxis.toJSON(this.name)).accumulate("values", (Object)ModelASTAxis.toJSONArray(this.values));
    }

    @Override
    public void validate(@NonNull ModelValidator validator) {
        validator.validateElement(this);
    }

    @Override
    @NonNull
    public String toGroovy() {
        StringBuilder argStr = new StringBuilder().append("name '").append(ModelASTAxis.toGroovy(this.name) + "'\n").append("values ").append(ModelASTAxis.toGroovyArgList(this.values)).append("\n");
        return "axis {\n" + argStr.toString() + "}\n";
    }

    @Override
    public void removeSourceLocation() {
        super.removeSourceLocation();
        ModelASTAxis.removeSourceLocationsFrom(this.values, this.name);
    }

    @Override
    public String toString() {
        return "ModelASTAxis{name=" + String.valueOf(this.name) + "values=" + String.valueOf(this.values) + "}";
    }

    public ModelASTKey getName() {
        return this.name;
    }

    public void setName(ModelASTKey name) {
        this.name = name;
    }

    public List<ModelASTValue> getValues() {
        return this.values;
    }

    public void setValues(List<ModelASTValue> values) {
        this.values = values;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModelASTAxis)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModelASTAxis that = (ModelASTAxis)o;
        return Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getValues(), that.getValues());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getName(), this.getValues());
    }
}

