// CHECKSTYLE:OFF

package org.jenkinsci.plugins.pipeline.modeldefinition.ast;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code ModelASTMethodCall.BlockedSteps.Node}: {@code The node step

     * cannot be called as an argument to a method in Declarative Pipelines}.
     * 
     * @return
     *     {@code The node step cannot be called as an argument to a method in

     *     Declarative Pipelines}
     */
    public static String ModelASTMethodCall_BlockedSteps_Node() {
        return holder.format("ModelASTMethodCall.BlockedSteps.Node");
    }

    /**
     * Key {@code ModelASTMethodCall.BlockedSteps.Node}: {@code The node step

     * cannot be called as an argument to a method in Declarative Pipelines}.
     * 
     * @return
     *     {@code The node step cannot be called as an argument to a method in

     *     Declarative Pipelines}
     */
    public static Localizable _ModelASTMethodCall_BlockedSteps_Node() {
        return new Localizable(holder, "ModelASTMethodCall.BlockedSteps.Node");
    }

    /**
     * Key {@code ModelASTStep.BlockedSteps.Properties}: {@code The

     * properties step cannot be used in Declarative Pipelines}.
     * 
     * @return
     *     {@code The properties step cannot be used in Declarative Pipelines}
     */
    public static String ModelASTStep_BlockedSteps_Properties() {
        return holder.format("ModelASTStep.BlockedSteps.Properties");
    }

    /**
     * Key {@code ModelASTStep.BlockedSteps.Properties}: {@code The

     * properties step cannot be used in Declarative Pipelines}.
     * 
     * @return
     *     {@code The properties step cannot be used in Declarative Pipelines}
     */
    public static Localizable _ModelASTStep_BlockedSteps_Properties() {
        return new Localizable(holder, "ModelASTStep.BlockedSteps.Properties");
    }

    /**
     * Key {@code ModelASTStep.BlockedSteps.Stage}: {@code The stage step

     * cannot be used in Declarative Pipelines}.
     * 
     * @return
     *     {@code The stage step cannot be used in Declarative Pipelines}
     */
    public static String ModelASTStep_BlockedSteps_Stage() {
        return holder.format("ModelASTStep.BlockedSteps.Stage");
    }

    /**
     * Key {@code ModelASTStep.BlockedSteps.Stage}: {@code The stage step

     * cannot be used in Declarative Pipelines}.
     * 
     * @return
     *     {@code The stage step cannot be used in Declarative Pipelines}
     */
    public static Localizable _ModelASTStep_BlockedSteps_Stage() {
        return new Localizable(holder, "ModelASTStep.BlockedSteps.Stage");
    }

    /**
     * Key {@code ModelASTStep.BlockedSteps.Parallel}: {@code The parallel

     * step can only be used as the only top-level step in a stage's step

     * block}.
     * 
     * @return
     *     {@code The parallel step can only be used as the only top-level step

     *     in a stage's step block}
     */
    public static String ModelASTStep_BlockedSteps_Parallel() {
        return holder.format("ModelASTStep.BlockedSteps.Parallel");
    }

    /**
     * Key {@code ModelASTStep.BlockedSteps.Parallel}: {@code The parallel

     * step can only be used as the only top-level step in a stage's step

     * block}.
     * 
     * @return
     *     {@code The parallel step can only be used as the only top-level step

     *     in a stage's step block}
     */
    public static Localizable _ModelASTStep_BlockedSteps_Parallel() {
        return new Localizable(holder, "ModelASTStep.BlockedSteps.Parallel");
    }

}
