/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.kubernetes.auth.impl;

import io.fabric8.kubernetes.api.model.AuthInfoBuilder;
import io.fabric8.kubernetes.client.ConfigBuilder;
import java.io.IOException;
import org.jenkinsci.plugins.kubernetes.auth.KubernetesAuthConfig;
import org.jenkinsci.plugins.kubernetes.auth.KubernetesAuthException;
import org.jenkinsci.plugins.kubernetes.auth.impl.AbstractKubernetesAuth;
import org.jenkinsci.plugins.kubernetes.credentials.TokenProducer;

public class KubernetesAuthToken
extends AbstractKubernetesAuth {
    private final TokenProducer tokenProducer;

    public KubernetesAuthToken(TokenProducer tokenProducer) {
        this.tokenProducer = tokenProducer;
    }

    protected String getToken(KubernetesAuthConfig config) throws KubernetesAuthException {
        try {
            return this.tokenProducer.getToken(config.getServerUrl(), config.getCaCertificate(), config.isSkipTlsVerify());
        }
        catch (IOException e) {
            throw new KubernetesAuthException(e);
        }
    }

    @Override
    public AuthInfoBuilder decorate(AuthInfoBuilder authInfoBuilder, KubernetesAuthConfig config) throws KubernetesAuthException {
        return (AuthInfoBuilder)authInfoBuilder.withToken(this.getToken(config));
    }

    @Override
    public ConfigBuilder decorate(ConfigBuilder builder, KubernetesAuthConfig config) throws KubernetesAuthException {
        return (ConfigBuilder)builder.withOauthToken(this.getToken(config));
    }
}

