/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.kubernetes.auth.impl;

import hudson.util.Secret;
import io.fabric8.kubernetes.api.model.AuthInfoBuilder;
import io.fabric8.kubernetes.client.ConfigBuilder;
import org.jenkinsci.plugins.kubernetes.auth.KubernetesAuthConfig;
import org.jenkinsci.plugins.kubernetes.auth.KubernetesAuthException;
import org.jenkinsci.plugins.kubernetes.auth.impl.AbstractKubernetesAuth;

public class KubernetesAuthUsernamePassword
extends AbstractKubernetesAuth {
    private final String username;
    private final Secret password;

    public KubernetesAuthUsernamePassword(String username, Secret password) {
        this.username = username;
        this.password = password;
    }

    public KubernetesAuthUsernamePassword(String username, String password) {
        this(username, Secret.fromString((String)password));
    }

    @Override
    public AuthInfoBuilder decorate(AuthInfoBuilder authInfoBuilder, KubernetesAuthConfig config) {
        return (AuthInfoBuilder)((AuthInfoBuilder)authInfoBuilder.withUsername(this.username)).withPassword(this.password.getPlainText());
    }

    @Override
    public ConfigBuilder decorate(ConfigBuilder builder, KubernetesAuthConfig config) throws KubernetesAuthException {
        return (ConfigBuilder)((ConfigBuilder)builder.withUsername(this.username)).withPassword(this.password.getPlainText());
    }

    public String getUsername() {
        return this.username;
    }

    @Deprecated
    public String getPassword() {
        return this.password.getPlainText();
    }

    public Secret getPasswordSecret() {
        return this.password;
    }
}

