// CHECKSTYLE:OFF

package org.jenkinsci.plugins.kubernetes.credentials;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code passwordTooShortFIPS}: {@code Password is too short (< 14
     * characters)}.
     * 
     * @return
     *     {@code Password is too short (< 14 characters)}
     */
    public static String passwordTooShortFIPS() {
        return holder.format("passwordTooShortFIPS");
    }

    /**
     * Key {@code passwordTooShortFIPS}: {@code Password is too short (< 14
     * characters)}.
     * 
     * @return
     *     {@code Password is too short (< 14 characters)}
     */
    public static Localizable _passwordTooShortFIPS() {
        return new Localizable(holder, "passwordTooShortFIPS");
    }

}
