/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.emailext_template;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.emailext_template.ExtendedEmailPublisherTemplate;
import org.jenkinsci.plugins.emailext_template.Messages;
import org.jenkinsci.plugins.emailext_template.TemplateId;
import org.kohsuke.stapler.DataBoundConstructor;

public class ExtendedEmailTemplatePublisher
extends Notifier {
    private List<TemplateId> templateIds;

    @DataBoundConstructor
    public ExtendedEmailTemplatePublisher(List<TemplateId> templateIds) {
        this.templateIds = templateIds;
    }

    public Collection<TemplateId> getTemplateIds() {
        return Collections.unmodifiableCollection(this.templateIds);
    }

    public void setTemplateIds(List<TemplateId> list) {
        this.templateIds = list;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        boolean result = true;
        for (TemplateId template : this.templateIds) {
            ExtendedEmailPublisherTemplate t = this.getDescriptor().getTemplateById(template.getTemplateId());
            if (t != null) {
                result &= t.getPublisher().prebuild(build, listener);
                continue;
            }
            listener.getLogger().println(Messages.TemplateIdRemoved(template.getTemplateId()));
        }
        return result;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        boolean result = true;
        for (TemplateId template : this.templateIds) {
            ExtendedEmailPublisherTemplate t = this.getDescriptor().getTemplateById(template.getTemplateId());
            if (t != null) {
                result &= t.getPublisher().perform(build, launcher, listener);
                continue;
            }
            listener.getLogger().println(Messages.TemplateIdRemoved(template.getTemplateId()));
        }
        return result;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.get().getDescriptor(((Object)((Object)this)).getClass());
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private List<ExtendedEmailPublisherTemplate> templates = new ArrayList<ExtendedEmailPublisherTemplate>();

        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> type) {
            return true;
        }

        public String getDisplayName() {
            return "Editable Email Notification Templates";
        }

        public List<ExtendedEmailPublisherTemplate> getTemplates() {
            return this.templates;
        }

        public void addTemplate(ExtendedEmailPublisherTemplate template) {
            if (this.getTemplateById(template.getId()) == null) {
                this.templates.add(template);
                this.save();
            }
        }

        public void removeTemplateById(String id) {
            ExtendedEmailPublisherTemplate t = this.getTemplateById(id);
            if (t != null) {
                this.templates.remove(t);
                this.save();
            }
        }

        public ExtendedEmailPublisherTemplate getTemplateById(String id) {
            ExtendedEmailPublisherTemplate template = null;
            for (ExtendedEmailPublisherTemplate t : this.templates) {
                if (!t.getId().equals(id)) continue;
                template = t;
                break;
            }
            return template;
        }

        public ExtendedEmailPublisherTemplate getTemplateByName(String name) {
            ExtendedEmailPublisherTemplate template = null;
            for (ExtendedEmailPublisherTemplate t : this.templates) {
                if (!t.getName().equalsIgnoreCase(name)) continue;
                template = t;
                break;
            }
            return template;
        }
    }
}

