// CHECKSTYLE:OFF

package org.jenkinsci.plugins.emailext_template;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code ExtEmailTemplateManagement.DisplayName}: {@code Editable

     * Email Notification Templates}.
     * 
     * @return
     *     {@code Editable Email Notification Templates}
     */
    public static String ExtEmailTemplateManagement_DisplayName() {
        return holder.format("ExtEmailTemplateManagement.DisplayName");
    }

    /**
     * Key {@code ExtEmailTemplateManagement.DisplayName}: {@code Editable

     * Email Notification Templates}.
     * 
     * @return
     *     {@code Editable Email Notification Templates}
     */
    public static Localizable _ExtEmailTemplateManagement_DisplayName() {
        return new Localizable(holder, "ExtEmailTemplateManagement.DisplayName");
    }

    /**
     * Key {@code TemplateNameRemoved}: {@code Template with Name ''{0}'' is

     * not available, perhaps it was removed?}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Template with Name ''{0}'' is not available, perhaps it was

     *     removed?}
     */
    public static String TemplateNameRemoved(Object arg0) {
        return holder.format("TemplateNameRemoved", arg0);
    }

    /**
     * Key {@code TemplateNameRemoved}: {@code Template with Name ''{0}'' is

     * not available, perhaps it was removed?}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Template with Name ''{0}'' is not available, perhaps it was

     *     removed?}
     */
    public static Localizable _TemplateNameRemoved(Object arg0) {
        return new Localizable(holder, "TemplateNameRemoved", arg0);
    }

    /**
     * Key {@code ExtEmailTemplateManagement.Description}: {@code Configure

     * global templates for Editable Email Notification Plugin}.
     * 
     * @return
     *     {@code Configure global templates for Editable Email Notification

     *     Plugin}
     */
    public static String ExtEmailTemplateManagement_Description() {
        return holder.format("ExtEmailTemplateManagement.Description");
    }

    /**
     * Key {@code ExtEmailTemplateManagement.Description}: {@code Configure

     * global templates for Editable Email Notification Plugin}.
     * 
     * @return
     *     {@code Configure global templates for Editable Email Notification

     *     Plugin}
     */
    public static Localizable _ExtEmailTemplateManagement_Description() {
        return new Localizable(holder, "ExtEmailTemplateManagement.Description");
    }

    /**
     * Key {@code TemplateIdRemoved}: {@code Template with ID ''{0}'' is not

     * available, perhaps it was removed?}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Template with ID ''{0}'' is not available, perhaps it was

     *     removed?}
     */
    public static String TemplateIdRemoved(Object arg0) {
        return holder.format("TemplateIdRemoved", arg0);
    }

    /**
     * Key {@code TemplateIdRemoved}: {@code Template with ID ''{0}'' is not

     * available, perhaps it was removed?}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Template with ID ''{0}'' is not available, perhaps it was

     *     removed?}
     */
    public static Localizable _TemplateIdRemoved(Object arg0) {
        return new Localizable(holder, "TemplateIdRemoved", arg0);
    }

}
