/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.changeassemblyversion;

import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;

public class ChangeTools {
    private final FilePath file;
    private final String regexPattern;
    private final String replacementPattern;

    ChangeTools(FilePath f, String regexPattern, String replacementPattern) {
        this.file = f;
        this.regexPattern = regexPattern != null && !regexPattern.equals("") ? regexPattern : "Version[(]\"[\\d\\.]+\"[)]";
        this.replacementPattern = replacementPattern != null && !replacementPattern.equals("") ? replacementPattern : "Version(\"%s\")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Replace(String replacement, TaskListener listener) throws IOException, InterruptedException {
        if (replacement != null && !replacement.isEmpty()) {
            String content;
            ByteOrderMark bom;
            Charset fileEncoding = Charset.defaultCharset();
            try (BOMInputStream inputStream = new BOMInputStream(this.file.read());){
                bom = inputStream.getBOM();
                if (bom != null) {
                    fileEncoding = Charset.forName(bom.getCharsetName());
                }
                content = IOUtils.toString((InputStream)inputStream, (Charset)fileEncoding);
            }
            listener.getLogger().println("Updating file : %s, Replacement : %s".formatted(this.file.getRemote(), replacement));
            content = content.replaceAll(this.regexPattern, this.replacementPattern.formatted(replacement));
            try (OutputStream os = this.file.write();){
                if (bom != null) {
                    os.write(bom.getBytes());
                }
                os.write(content.getBytes(fileEncoding));
            }
        }
        listener.getLogger().println("Skipping replacement because value is empty.".formatted(new Object[0]));
    }
}

