/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi.extensions;

import java.util.List;
import java.util.Map;
import javax.inject.Provider;
import org.apache.maven.lifecycle.mapping.Lifecycle;
import org.apache.maven.lifecycle.mapping.LifecycleMapping;
import org.apache.maven.lifecycle.mapping.LifecyclePhase;

public abstract class AbstractLifecycleMappingProvider
implements Provider<LifecycleMapping> {
    private static final String DEFAULT_LIFECYCLE_KEY = "default";
    private final Lifecycle defaultLifecycle = new Lifecycle();
    private final LifecycleMapping lifecycleMapping;

    protected AbstractLifecycleMappingProvider(Map<String, LifecyclePhase> bindings) {
        this.defaultLifecycle.setId(DEFAULT_LIFECYCLE_KEY);
        this.defaultLifecycle.setLifecyclePhases(bindings);
        this.lifecycleMapping = new DefaultLifecycleMapping(this.defaultLifecycle);
    }

    public LifecycleMapping get() {
        return this.lifecycleMapping;
    }

    private static class DefaultLifecycleMapping
    implements LifecycleMapping {
        private final Lifecycle lifecycle;

        DefaultLifecycleMapping(Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
        }

        public Map<String, Lifecycle> getLifecycles() {
            return Map.of(AbstractLifecycleMappingProvider.DEFAULT_LIFECYCLE_KEY, this.lifecycle);
        }

        @Deprecated
        public List<String> getOptionalMojos(String lifecycle) {
            return null;
        }

        @Deprecated
        public Map<String, String> getPhases(String lifecycle) {
            if (AbstractLifecycleMappingProvider.DEFAULT_LIFECYCLE_KEY.equals(lifecycle)) {
                return this.lifecycle.getPhases();
            }
            return null;
        }
    }
}

