/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.jenkinsci.maven.plugins.hpi.AbstractJenkinsMojo;

public abstract class AbstractDependencyGraphTraversingMojo
extends AbstractJenkinsMojo {
    protected void traverseProject() throws DependencyResolutionException {
        RepositorySystemSession repoSession = this.session.getRepositorySession();
        MavenProject shadow = this.project.clone();
        ArtifactTypeRegistry artifactTypeRegistry = repoSession.getArtifactTypeRegistry();
        List<Dependency> projectDependencies = shadow.getDependencies().stream().map(dep -> RepositoryUtils.toDependency((org.apache.maven.model.Dependency)dep, (ArtifactTypeRegistry)artifactTypeRegistry)).toList();
        List<Object> managedDependencies = new ArrayList();
        if (shadow.getDependencyManagement() != null) {
            managedDependencies = shadow.getDependencyManagement().getDependencies().stream().map(dep -> RepositoryUtils.toDependency((org.apache.maven.model.Dependency)dep, (ArtifactTypeRegistry)artifactTypeRegistry)).toList();
        }
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRootArtifact(RepositoryUtils.toArtifact((Artifact)shadow.getArtifact()));
        collectRequest.setRepositories(shadow.getRemoteProjectRepositories());
        collectRequest.setDependencies(projectDependencies);
        collectRequest.setManagedDependencies(managedDependencies);
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, null);
        DependencyNode root = this.repositorySystem.resolveDependencies(repoSession, dependencyRequest).getRoot();
        this.visit(root, true);
    }

    protected void visit(DependencyNode g, boolean isRoot) {
        if (this.accept(g, isRoot)) {
            for (DependencyNode dn : g.getChildren()) {
                this.visit(dn, false);
            }
        }
    }

    protected abstract boolean accept(DependencyNode var1, boolean var2);
}

