/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.util.VersionNumber;
import io.jenkins.lib.support_log_formatter.SupportLogFormatter;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.jar.JarFile;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jenkinsci.maven.plugins.hpi.AbstractHpiMojo;
import org.jenkinsci.maven.plugins.hpi.Artifacts;
import org.jenkinsci.maven.plugins.hpi.MavenArtifact;
import org.jenkinsci.maven.plugins.hpi.PluginWorkspaceMap;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.TEST)
@Execute(phase=LifecyclePhase.COMPILE)
public class RunMojo
extends AbstractHpiMojo {
    @Parameter(property="webAppFile")
    private File webAppFile;
    @Parameter(property="jenkinsHome", defaultValue="${JENKINS_HOME}")
    private File jenkinsHome;
    @Parameter(defaultValue="test")
    protected String dependencyResolution;
    @Inject
    private BuildPluginManager pluginManager;
    @Parameter(property="port", defaultValue="8080")
    protected int defaultPort;
    @Parameter(property="host", defaultValue="localhost")
    protected String defaultHost;
    @Parameter(property="wildcardDNS")
    protected String wildcardDNS;
    @Parameter(property="wildcardLocalhostDNS")
    protected String wildcardLocalhostDNS;
    @Parameter
    protected String jenkinsCoreId;
    @Parameter
    protected String jenkinsWarId;
    @Parameter
    protected String maskClasses;
    @Parameter
    private Map<String, String> loggers;
    private Collection<Logger> loggerReferences;
    @Inject
    protected PluginWorkspaceMap pluginWorkspaceMap;
    @Parameter
    private WebApp webApp;
    @Parameter
    private Map<String, String> systemProperties;

    /*
     * WARNING - void declaration
     */
    @SuppressFBWarnings(value={"COMMAND_INJECTION"}, justification="ProcessBuilder arguments are constructed from internal plugin configuration and not user input.")
    public void execute() throws MojoExecutionException, MojoFailureException {
        void var6_13;
        boolean wildcardEnabled;
        this.getProject().setArtifacts(this.resolveDependencies(this.dependencyResolution));
        File basedir = this.getProject().getBasedir();
        if (this.jenkinsHome == null) {
            String h = System.getenv("JENKINS_HOME");
            if (h == null) {
                h = System.getenv("HUDSON_HOME");
            }
            this.jenkinsHome = h != null && !h.isEmpty() && !h.equals("null") ? new File(h) : new File(basedir, "work");
        }
        Artifacts jenkinsArtifacts = Artifacts.of(this.getProject()).groupIdIs("org.jenkins-ci.main", "org.jvnet.hudson.main").artifactIdIsNot("remoting");
        if (this.webAppFile == null) {
            Artifact jenkinsWarArtifact = MavenArtifact.resolveArtifact(this.getJenkinsWarArtifact(), this.project, this.session, this.repositorySystem);
            this.webAppFile = jenkinsWarArtifact.getFile();
            if (this.webAppFile == null || !this.webAppFile.isFile()) {
                throw new MojoExecutionException("Could not find " + String.valueOf(this.webAppFile) + " from " + String.valueOf(jenkinsWarArtifact));
            }
        }
        for (Artifact a : jenkinsArtifacts) {
            Artifact ba = (Artifact)jenkinsArtifacts.get(0);
            if (a.getVersion().equals(ba.getVersion())) continue;
            throw new MojoExecutionException("Version of " + a.getId() + " is inconsistent with " + ba.getId());
        }
        this.setSystemPropertyIfEmpty("JENKINS_HOME", this.jenkinsHome.getAbsolutePath());
        File pluginsDir = new File(this.jenkinsHome, "plugins");
        try {
            Files.createDirectories(pluginsDir.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create directories for '" + String.valueOf(pluginsDir) + "'", (Exception)e);
        }
        this.setSystemPropertyIfEmpty("stapler.jelly.noCache", "true");
        List res = this.getProject().getBuild().getResources();
        if (!res.isEmpty()) {
            Resource r = (Resource)res.get(0);
            this.setSystemPropertyIfEmpty("stapler.resourcePath", r.getDirectory());
        }
        this.generateHpl();
        try {
            for (MavenArtifact mavenArtifact : this.getProjectArtifacts()) {
                if (!mavenArtifact.isPlugin(this.getLog())) continue;
                Artifact hpi = this.artifactFactory.createArtifact(mavenArtifact.getGroupId(), mavenArtifact.getArtifactId(), mavenArtifact.getVersion(), null, "hpi");
                if (this.hasSameGavAsProject(hpi = MavenArtifact.resolveArtifact(hpi, this.project, this.session, this.repositorySystem))) continue;
                if (hpi.getFile().isDirectory()) {
                    throw new UnsupportedOperationException(String.valueOf(hpi.getFile()) + " is a directory and not packaged yet. this isn't supported");
                }
                File upstreamHpl = this.pluginWorkspaceMap.read(hpi.getId());
                String actualArtifactId = mavenArtifact.getActualArtifactId();
                if (actualArtifactId == null) {
                    throw new MojoExecutionException("Failed to load actual artifactId from " + String.valueOf(mavenArtifact) + " ~ " + String.valueOf(mavenArtifact.getFile()));
                }
                if (upstreamHpl != null) {
                    this.copyHpl(upstreamHpl, pluginsDir, actualArtifactId);
                    continue;
                }
                this.copyPlugin(hpi.getFile(), pluginsDir, actualArtifactId);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy dependency plugin", (Exception)e);
        }
        if (System.getProperty("java.util.logging.config.file") == null) {
            System.setProperty("org.apache.juli.formatter", SupportLogFormatter.class.getName());
        }
        if (this.loggers != null) {
            for (Handler h : LogManager.getLogManager().getLogger("").getHandlers()) {
                if (!(h instanceof ConsoleHandler)) continue;
                h.setLevel(Level.ALL);
            }
            this.loggerReferences = new LinkedList<Logger>();
            for (Map.Entry entry : this.loggers.entrySet()) {
                Logger l = Logger.getLogger((String)entry.getKey());
                this.loggerReferences.add(l);
                l.setLevel(Level.parse((String)entry.getValue()));
            }
        }
        String effectiveContextPath = null;
        if (this.webApp != null && this.webApp.getContextPath() != null && !this.webApp.getContextPath().trim().isEmpty()) {
            effectiveContextPath = this.webApp.getContextPath().trim();
        }
        String string = this.defaultHost == null || this.defaultHost.trim().isEmpty() ? "localhost" : this.defaultHost.trim();
        boolean bl = wildcardEnabled = this.wildcardLocalhostDNS != null && !this.wildcardLocalhostDNS.trim().isEmpty() || this.wildcardDNS != null && !this.wildcardDNS.trim().isEmpty();
        if (wildcardEnabled && (this.defaultHost == null || this.defaultHost.trim().isEmpty() || "localhost".equals(string))) {
            String string2 = "0.0.0.0";
        }
        String externalHost = var6_13;
        if (wildcardEnabled) {
            String id = this.getProject().getArtifactId();
            externalHost = this.wildcardLocalhostDNS != null && !this.wildcardLocalhostDNS.trim().isEmpty() ? id + "." + this.wildcardLocalhostDNS.trim() : id + ".127.0.0.1." + this.wildcardDNS.trim();
        }
        String jenkinsUrl = RunMojo.buildJenkinsUrl(externalHost, this.defaultPort, effectiveContextPath);
        this.getLog().info((CharSequence)("===========> Browse to: " + jenkinsUrl));
        this.setSystemPropertyIfEmpty("JENKINS_URL", jenkinsUrl);
        String argLine = this.getProject().getProperties().getProperty("argLine", "");
        String addOpens = this.getProject().getProperties().getProperty("jenkins.addOpens", "");
        String insaneHook = this.getProject().getProperties().getProperty("jenkins.insaneHook", "");
        String javaAgent = this.getProject().getProperties().getProperty("jenkins.javaAgent", "");
        argLine = this.expandAtPropertyToken(argLine);
        addOpens = this.expandAtPropertyToken(addOpens);
        insaneHook = this.expandAtPropertyToken(insaneHook);
        javaAgent = this.expandAtPropertyToken(javaAgent);
        List<String> cmd = new ArrayList<String>();
        String javaExe = System.getProperty("java.home") + "/bin/java";
        cmd.add(javaExe);
        if (RunMojo.isDebuggerPresent()) {
            cmd.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=*:0");
        }
        if (this.systemProperties != null && !this.systemProperties.isEmpty()) {
            for (Map.Entry<String, String> e : this.systemProperties.entrySet()) {
                if (e.getKey() == null || e.getKey().trim().isEmpty()) continue;
                String key = e.getKey().trim();
                String val = e.getValue() == null ? "" : e.getValue();
                cmd.add("-D" + key + "=" + val);
            }
        }
        RunMojo.addArgs(cmd, argLine);
        RunMojo.addArgs(cmd, addOpens);
        RunMojo.addArgs(cmd, insaneHook);
        RunMojo.addArgs(cmd, javaAgent);
        cmd = RunMojo.dedupeJvmArgs(cmd);
        cmd.add("-jar");
        cmd.add(this.webAppFile.getAbsolutePath());
        if (!var6_13.isEmpty()) {
            cmd.add("--httpListenAddress=" + (String)var6_13);
        }
        if (this.defaultPort > 0) {
            cmd.add("--httpPort=" + this.defaultPort);
        }
        if (effectiveContextPath != null) {
            String prefix = effectiveContextPath.trim();
            cmd.add("--prefix=" + prefix);
        }
        this.getLog().info((CharSequence)("Launching Jenkins: " + String.join((CharSequence)" ", cmd)));
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.directory(this.jenkinsHome);
        pb.inheritIO();
        pb.environment().put("JENKINS_HOME", this.jenkinsHome.getAbsolutePath());
        try {
            Process proc = pb.start();
            int exitCode = proc.waitFor();
            if (exitCode != 0) {
                throw new MojoExecutionException("Jenkins exited with code " + exitCode);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException("Failed to launch Jenkins", e);
        }
    }

    public static boolean isDebuggerPresent() {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        List<String> args = runtime.getInputArguments();
        return args.toString().contains("jdwp");
    }

    private boolean hasSameGavAsProject(Artifact a) {
        return this.getProject().getGroupId().equals(a.getGroupId()) && this.getProject().getArtifactId().equals(a.getArtifactId()) && this.getProject().getVersion().equals(a.getVersion());
    }

    private void setSystemPropertyIfEmpty(String name, String value) {
        if (System.getProperty(name) == null) {
            System.setProperty(name, value);
        }
    }

    private void copyPlugin(File src, File pluginsDir, String shortName) throws IOException {
        File dst = new File(pluginsDir, shortName + ".jpi");
        File hpi = new File(pluginsDir, shortName + ".hpi");
        if (Files.isRegularFile(hpi.toPath(), new LinkOption[0])) {
            this.getLog().warn((CharSequence)("Moving historical " + String.valueOf(hpi) + " to *.jpi"));
            Files.move(hpi.toPath(), dst.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        VersionNumber dstV = this.versionOfPlugin(dst);
        if (this.versionOfPlugin(src).compareTo(dstV) < 0) {
            this.getLog().info((CharSequence)("will not overwrite " + String.valueOf(dst) + " with " + String.valueOf(src) + " because " + String.valueOf(dstV) + " is newer"));
            return;
        }
        this.getLog().info((CharSequence)("Copying dependency Jenkins plugin " + String.valueOf(src)));
        FileUtils.copyFile((File)src, (File)dst);
        Files.writeString(pluginsDir.toPath().resolve(shortName + ".jpi.pinned"), (CharSequence)"pinned", StandardCharsets.US_ASCII, new OpenOption[0]);
        Files.deleteIfExists(new File(pluginsDir, shortName + ".jpl").toPath());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private VersionNumber versionOfPlugin(File p) throws IOException {
        if (!p.isFile()) {
            return new VersionNumber("0.0");
        }
        try (JarFile j = new JarFile(p);){
            String v = j.getManifest().getMainAttributes().getValue("Plugin-Version");
            if (v == null) {
                throw new IOException("no Plugin-Version in " + String.valueOf(p));
            }
            try {
                VersionNumber versionNumber = new VersionNumber(v);
                return versionNumber;
            }
            catch (IllegalArgumentException x) {
                throw new IOException("malformed Plugin-Version in " + String.valueOf(p) + ": " + String.valueOf(x), x);
            }
        }
        catch (IOException x) {
            throw new IOException("not a valid JarFile: " + String.valueOf(p), x);
        }
    }

    private void copyHpl(File src, File pluginsDir, String shortName) throws IOException {
        File dst = new File(pluginsDir, shortName + ".jpl");
        this.getLog().info((CharSequence)("Copying snapshot dependency Jenkins plugin " + String.valueOf(src)));
        FileUtils.copyFile((File)src, (File)dst);
        Files.writeString(pluginsDir.toPath().resolve(shortName + ".jpi.pinned"), (CharSequence)"pinned", StandardCharsets.US_ASCII, new OpenOption[0]);
    }

    private void generateHpl() throws MojoExecutionException {
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.jenkins-ci.tools"), (String)MojoExecutor.artifactId((String)"maven-hpi-plugin")), (String)MojoExecutor.goal((String)"hpl"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"jenkinsHome"), (String)this.jenkinsHome.toString()), MojoExecutor.element((String)MojoExecutor.name((String)"pluginName"), (String)this.project.getName()), MojoExecutor.element((String)MojoExecutor.name((String)"warSourceDirectory"), (String)this.warSourceDirectory.toString()), MojoExecutor.element((String)MojoExecutor.name((String)"jenkinsCoreId"), (String)this.jenkinsCoreId), MojoExecutor.element((String)MojoExecutor.name((String)"pluginFirstClassLoader"), (String)Boolean.toString(this.pluginFirstClassLoader)), MojoExecutor.element((String)MojoExecutor.name((String)"maskClasses"), (String)this.maskClasses)}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
    }

    protected Artifact getJenkinsWarArtifact() throws MojoExecutionException {
        for (Artifact a : this.resolveDependencies("test")) {
            boolean match;
            if (this.jenkinsWarId != null) {
                match = (a.getGroupId() + ":" + a.getArtifactId()).equals(this.jenkinsWarId);
            } else {
                boolean bl = match = !(!a.getArtifactId().equals("jenkins-war") && !a.getArtifactId().equals("hudson-war") || !a.getType().equals("executable-war") && !a.getType().equals("war"));
            }
            if (!match) continue;
            return a;
        }
        String inferredVersion = this.findJenkinsVersion();
        String[] gav = Optional.ofNullable(this.jenkinsWarId).map(id -> id.split(":", 2)).orElse(null);
        String groupId = gav != null && gav.length == 2 ? gav[0] : "org.jenkins-ci.main";
        String artifactId = gav != null && gav.length == 2 ? gav[1] : "jenkins-war";
        this.getLog().info((CharSequence)("No Jenkins WAR dependency found; resolving " + groupId + ":" + artifactId + ":war:" + inferredVersion));
        Artifact war = this.artifactFactory.createArtifact(groupId, artifactId, inferredVersion, null, "war");
        return MavenArtifact.resolveArtifact(war, this.project, this.session, this.repositorySystem);
    }

    protected MavenProject getProject() {
        return this.project;
    }

    private String expandAtPropertyToken(String value) {
        if (value == null) {
            return "";
        }
        if (!value.contains("@{")) {
            return value;
        }
        Matcher m = Pattern.compile("@\\{([^}]+)}").matcher(value);
        StringBuilder out = new StringBuilder();
        while (m.find()) {
            String key = m.group(1);
            String resolved = this.project.getProperties().getProperty(key);
            if (resolved == null) {
                resolved = this.session.getSystemProperties().getProperty(key);
            }
            if (resolved == null) {
                resolved = System.getProperty(key);
            }
            if (resolved == null) {
                this.getLog().warn((CharSequence)("Unable to resolve placeholder @{" + key + "}; skipping"));
                resolved = "";
            }
            m.appendReplacement(out, Matcher.quoteReplacement(resolved.trim()));
        }
        m.appendTail(out);
        return out.toString().trim();
    }

    private static void addArgs(List<String> cmd, String args) {
        if (args == null) {
            return;
        }
        String trimmed = args.trim();
        if (trimmed.isEmpty()) {
            return;
        }
        String[] parts = trimmed.split("\\s+");
        for (int i = 0; i < parts.length; ++i) {
            String p = parts[i];
            if (p == null || p.isEmpty()) continue;
            if ("--add-opens".equals(p) || "--add-exports".equals(p) || "--patch-module".equals(p)) {
                String v;
                cmd.add(p);
                if (i + 1 >= parts.length || (v = parts[++i]) == null || v.isEmpty()) continue;
                cmd.add(v);
                continue;
            }
            cmd.add(p);
        }
    }

    private static List<String> dedupeJvmArgs(List<String> original) {
        LinkedHashSet<String> seenSingles = new LinkedHashSet<String>();
        LinkedHashSet<CallSite> seenPairs = new LinkedHashSet<CallSite>();
        ArrayList<String> out = new ArrayList<String>(original.size());
        for (int i = 0; i < original.size(); ++i) {
            String s;
            String a = original.get(i);
            if (a == null || (s = a.trim()).isEmpty()) continue;
            if (("--patch-module".equals(s) || "--add-opens".equals(s) || "--add-exports".equals(s)) && i + 1 < original.size()) {
                String v = original.get(i + 1);
                String vv = v == null ? "" : v.trim();
                String key = s + "\u0000" + vv;
                if (seenPairs.add((CallSite)((Object)key))) {
                    out.add(s);
                    if (!vv.isEmpty()) {
                        out.add(vv);
                    }
                }
                ++i;
                continue;
            }
            if (!seenSingles.add(s)) continue;
            out.add(s);
        }
        return out;
    }

    @Nullable
    private static String buildJenkinsUrl(String host, int port, @Nullable String contextPath) {
        if (host == null || host.isBlank()) {
            return null;
        }
        StringBuilder url = new StringBuilder();
        url.append("http://").append(host.trim());
        if (port != 80 && port > 0) {
            url.append(":").append(port);
        }
        if (contextPath != null && !contextPath.isBlank()) {
            String cp = contextPath.trim();
            if (!cp.startsWith("/")) {
                url.append('/');
            }
            url.append(cp);
        }
        if (url.charAt(url.length() - 1) != '/') {
            url.append('/');
        }
        return url.toString();
    }

    public static final class WebApp {
        @Parameter
        private String contextPath;

        public String getContextPath() {
            return this.contextPath;
        }
    }
}

