/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.util.VersionNumber;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.util.filter.ScopeDependencyFilter;
import org.jenkinsci.maven.plugins.hpi.AbstractJenkinsMojo;
import org.jenkinsci.maven.plugins.hpi.Artifacts;
import org.jenkinsci.maven.plugins.hpi.MavenArtifact;
import org.jenkinsci.maven.plugins.hpi.PluginWorkspaceMap;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.TEST)
@Execute(phase=LifecyclePhase.COMPILE)
public class RunMojo
extends AbstractJenkinsMojo {
    @Parameter(property="webAppFile")
    private File webAppFile;
    @Parameter(property="hudsonHome", defaultValue="${HUDSON_HOME}")
    private File hudsonHome;
    @Parameter(property="jenkinsHome", defaultValue="${JENKINS_HOME}")
    private File jenkinsHome;
    @Parameter(defaultValue="test")
    protected String dependencyResolution;
    @Parameter(defaultValue="${basedir}/src/main/webapp")
    protected File warSourceDirectory;
    @Component
    private ProjectDependenciesResolver dependenciesResolver;
    @Component
    private BuildPluginManager pluginManager;
    @Parameter(property="port", defaultValue="8080")
    protected int defaultPort;
    @Parameter(property="host", defaultValue="localhost")
    protected String defaultHost;
    @Parameter(property="wildcardDNS")
    protected String wildcardDNS;
    @Parameter(property="wildcardLocalhostDNS")
    protected String wildcardLocalhostDNS;
    @Parameter
    protected String jenkinsWarId;
    @Parameter
    protected String maskClasses;
    @Parameter
    protected boolean pluginFirstClassLoader = false;
    @Parameter(property="contextPath", defaultValue="/${project.artifactId}")
    protected String contextPath;
    @Component
    protected PluginWorkspaceMap pluginWorkspaceMap;
    private Process jenkinsProcess;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.project.setArtifacts(this.resolveDependencies(this.dependencyResolution));
        File basedir = this.project.getBasedir();
        if (this.jenkinsHome == null) {
            String h;
            if (this.hudsonHome != null) {
                this.getLog().warn((CharSequence)"Please use the `jenkinsHome` configuration parameter in place of the deprecated `hudsonHome` parameter");
                this.jenkinsHome = this.hudsonHome;
            }
            if ((h = System.getenv("JENKINS_HOME")) == null) {
                h = System.getenv("HUDSON_HOME");
            }
            this.jenkinsHome = h != null && !h.isEmpty() && !h.equals("null") ? new File(h) : new File(basedir, "work");
        }
        Artifacts jenkinsArtifacts = Artifacts.of(this.project).groupIdIs("org.jenkins-ci.main", "org.jvnet.hudson.main").artifactIdIsNot("remoting");
        if (this.webAppFile == null) {
            Artifact jenkinsWarArtifact = MavenArtifact.resolveArtifact(this.getJenkinsWarArtifact(), this.project, this.session, this.repositorySystem);
            this.webAppFile = jenkinsWarArtifact.getFile();
            if (this.webAppFile == null || !this.webAppFile.isFile()) {
                throw new MojoExecutionException("Could not find " + String.valueOf(this.webAppFile) + " from " + String.valueOf(jenkinsWarArtifact));
            }
        }
        for (Artifact a : jenkinsArtifacts) {
            Artifact ba = (Artifact)jenkinsArtifacts.get(0);
            if (a.getVersion().equals(ba.getVersion())) continue;
            throw new MojoExecutionException("Version of " + a.getId() + " is inconsistent with " + ba.getId());
        }
        File pluginsDir = new File(this.jenkinsHome, "plugins");
        try {
            Files.createDirectories(pluginsDir.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create directories for '" + String.valueOf(pluginsDir) + "'", (Exception)e);
        }
        this.generateHpl();
        try {
            for (MavenArtifact a : this.getProjectArtifacts()) {
                if (!a.isPlugin(this.getLog())) continue;
                Artifact hpi = this.artifactFactory.createArtifact(a.getGroupId(), a.getArtifactId(), a.getVersion(), null, "hpi");
                if (this.hasSameGavAsProject(hpi = MavenArtifact.resolveArtifact(hpi, this.project, this.session, this.repositorySystem))) continue;
                if (hpi.getFile().isDirectory()) {
                    throw new UnsupportedOperationException(String.valueOf(hpi.getFile()) + " is a directory and not packaged yet. this isn't supported");
                }
                File upstreamHpl = this.pluginWorkspaceMap.read(hpi.getId());
                String actualArtifactId = a.getActualArtifactId();
                if (actualArtifactId == null) {
                    throw new MojoExecutionException("Failed to load actual artifactId from " + String.valueOf(a) + " ~ " + String.valueOf(a.getFile()));
                }
                if (upstreamHpl != null) {
                    this.copyHpl(upstreamHpl, pluginsDir, actualArtifactId);
                    continue;
                }
                this.copyPlugin(hpi.getFile(), pluginsDir, actualArtifactId);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy dependency plugin", (Exception)e);
        }
        try {
            this.startJenkins();
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException("Failed to start Jenkins", e);
        }
    }

    @SuppressFBWarnings(value={"COMMAND_INJECTION"}, justification="Command is constructed from controlled sources, not user input")
    private void startJenkins() throws IOException, InterruptedException, MojoExecutionException {
        Object browserHost;
        ArrayList<String> command = new ArrayList<String>();
        String javaExecutable = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        command.add(javaExecutable);
        List<String> addOpensArgs = this.getAddOpensFromManifest();
        if (!addOpensArgs.isEmpty()) {
            this.getLog().info((CharSequence)"Adding --add-opens arguments from jenkins.war manifest");
            command.addAll(addOpensArgs);
        }
        command.add("-DJENKINS_HOME=" + this.jenkinsHome.getAbsolutePath());
        command.add("-Dstapler.trace=true");
        command.add("-Dstapler.jelly.noCache=true");
        command.add("-Dhudson.hpi.run=true");
        command.add("-Djenkins.moduleRoot=" + this.project.getBasedir().getAbsolutePath());
        List res = this.project.getBuild().getResources();
        if (!res.isEmpty()) {
            Resource r = (Resource)res.get(0);
            command.add("-Dstapler.resourcePath=" + r.getDirectory());
        }
        command.add("-jar");
        command.add(this.webAppFile.getAbsolutePath());
        command.add("--httpPort=" + this.defaultPort);
        command.add("--httpListenAddress=" + this.defaultHost);
        if (this.contextPath != null && !this.contextPath.isEmpty() && !this.contextPath.equals("/")) {
            command.add("--prefix=" + this.contextPath);
        }
        this.getLog().info((CharSequence)"Starting Jenkins with command:");
        this.getLog().info((CharSequence)String.join((CharSequence)" ", command));
        if (!"localhost".equals(this.defaultHost)) {
            browserHost = this.defaultHost;
        } else if (this.wildcardLocalhostDNS != null) {
            browserHost = this.project.getArtifactId() + "." + this.wildcardLocalhostDNS;
        } else if (this.wildcardDNS != null) {
            browserHost = this.project.getArtifactId() + ".127.0.0.1." + this.wildcardDNS;
        } else {
            this.getLog().info((CharSequence)"Try setting -DwildcardLocalhostDNS=localtest.me in a profile");
            browserHost = this.defaultHost;
        }
        this.getLog().info((CharSequence)("===========> Browse to: http://" + (String)browserHost + ":" + this.defaultPort + this.contextPath + "/"));
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.inheritIO();
        pb.directory(this.project.getBasedir());
        this.jenkinsProcess = pb.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (this.jenkinsProcess != null && this.jenkinsProcess.isAlive()) {
                this.getLog().info((CharSequence)"Stopping Jenkins...");
                this.jenkinsProcess.destroy();
                try {
                    this.jenkinsProcess.waitFor();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }));
        int exitCode = this.jenkinsProcess.waitFor();
        if (exitCode != 0) {
            throw new MojoExecutionException("Jenkins process exited with code " + exitCode);
        }
    }

    private List<String> getAddOpensFromManifest() throws MojoExecutionException {
        ArrayList<String> args;
        block9: {
            args = new ArrayList<String>();
            try {
                if (this.webAppFile == null || !this.webAppFile.exists()) break block9;
                try (JarFile jarFile = new JarFile(this.webAppFile);){
                    String addOpens;
                    Manifest manifest = jarFile.getManifest();
                    if (manifest != null && (addOpens = manifest.getMainAttributes().getValue("Add-Opens")) != null && !addOpens.trim().isEmpty()) {
                        for (String module : addOpens.split("\\s+")) {
                            if (module.isEmpty()) continue;
                            args.add("--add-opens");
                            args.add(module + "=ALL-UNNAMED");
                        }
                        this.getLog().debug((CharSequence)("Found Add-Opens in manifest: " + addOpens));
                    }
                }
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Failed to read Add-Opens from jenkins.war manifest: " + e.getMessage()));
            }
        }
        return args;
    }

    private boolean hasSameGavAsProject(Artifact a) {
        return this.project.getGroupId().equals(a.getGroupId()) && this.project.getArtifactId().equals(a.getArtifactId()) && this.project.getVersion().equals(a.getVersion());
    }

    private void copyPlugin(File src, File pluginsDir, String shortName) throws IOException {
        File dst = new File(pluginsDir, shortName + ".jpi");
        File hpi = new File(pluginsDir, shortName + ".hpi");
        if (Files.isRegularFile(hpi.toPath(), new LinkOption[0])) {
            this.getLog().warn((CharSequence)("Moving historical " + String.valueOf(hpi) + " to *.jpi"));
            Files.move(hpi.toPath(), dst.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        VersionNumber dstV = this.versionOfPlugin(dst);
        if (this.versionOfPlugin(src).compareTo(dstV) < 0) {
            this.getLog().info((CharSequence)("will not overwrite " + String.valueOf(dst) + " with " + String.valueOf(src) + " because " + String.valueOf(dstV) + " is newer"));
            return;
        }
        this.getLog().info((CharSequence)("Copying dependency Jenkins plugin " + String.valueOf(src)));
        FileUtils.copyFile((File)src, (File)dst);
        Files.writeString(pluginsDir.toPath().resolve(shortName + ".jpi.pinned"), (CharSequence)"pinned", StandardCharsets.US_ASCII, new OpenOption[0]);
        Files.deleteIfExists(new File(pluginsDir, shortName + ".jpl").toPath());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private VersionNumber versionOfPlugin(File p) throws IOException {
        if (!p.isFile()) {
            return new VersionNumber("0.0");
        }
        try (JarFile j = new JarFile(p);){
            String v = j.getManifest().getMainAttributes().getValue("Plugin-Version");
            if (v == null) {
                throw new IOException("no Plugin-Version in " + String.valueOf(p));
            }
            try {
                VersionNumber versionNumber = new VersionNumber(v);
                return versionNumber;
            }
            catch (IllegalArgumentException x) {
                throw new IOException("malformed Plugin-Version in " + String.valueOf(p) + ": " + String.valueOf(x), x);
            }
        }
        catch (IOException x) {
            throw new IOException("not a valid JarFile: " + String.valueOf(p), x);
        }
    }

    private void copyHpl(File src, File pluginsDir, String shortName) throws IOException {
        File dst = new File(pluginsDir, shortName + ".jpl");
        this.getLog().info((CharSequence)("Copying snapshot dependency Jenkins plugin " + String.valueOf(src)));
        FileUtils.copyFile((File)src, (File)dst);
        Files.writeString(pluginsDir.toPath().resolve(shortName + ".jpi.pinned"), (CharSequence)"pinned", StandardCharsets.US_ASCII, new OpenOption[0]);
    }

    private void generateHpl() throws MojoExecutionException {
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.jenkins-ci.tools"), (String)MojoExecutor.artifactId((String)"maven-hpi-plugin")), (String)MojoExecutor.goal((String)"hpl"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"jenkinsHome"), (String)this.jenkinsHome.toString()), MojoExecutor.element((String)MojoExecutor.name((String)"pluginName"), (String)this.project.getName()), MojoExecutor.element((String)MojoExecutor.name((String)"warSourceDirectory"), (String)this.warSourceDirectory.toString()), MojoExecutor.element((String)MojoExecutor.name((String)"jenkinsCoreId"), (String)this.jenkinsCoreId), MojoExecutor.element((String)MojoExecutor.name((String)"pluginFirstClassLoader"), (String)Boolean.toString(this.pluginFirstClassLoader)), MojoExecutor.element((String)MojoExecutor.name((String)"maskClasses"), (String)this.maskClasses)}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
    }

    protected Set<Artifact> resolveDependencies(String scope) throws MojoExecutionException {
        try {
            DefaultDependencyResolutionRequest request = new DefaultDependencyResolutionRequest(this.project, this.session.getRepositorySession());
            request.setResolutionFilter(RunMojo.getDependencyFilter(scope));
            DependencyResolutionResult result = this.dependenciesResolver.resolve((DependencyResolutionRequest)request);
            LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
            if (result.getDependencyGraph() != null && !result.getDependencyGraph().getChildren().isEmpty()) {
                RepositoryUtils.toArtifacts(artifacts, (Collection)result.getDependencyGraph().getChildren(), List.of(this.project.getArtifact().getId()), (DependencyFilter)request.getResolutionFilter());
            }
            return artifacts;
        }
        catch (DependencyResolutionException e) {
            throw new MojoExecutionException("Unable to copy dependency plugin", (Exception)((Object)e));
        }
    }

    private static DependencyFilter getDependencyFilter(String scope) {
        switch (scope) {
            case "compile": {
                return new ScopeDependencyFilter(new String[]{"runtime", "test"});
            }
            case "runtime": {
                return new ScopeDependencyFilter(new String[]{"system", "provided", "test"});
            }
            case "test": {
                return null;
            }
        }
        throw new IllegalArgumentException("unexpected scope: " + scope);
    }

    public Set<MavenArtifact> getProjectArtifacts() {
        HashSet<MavenArtifact> r = new HashSet<MavenArtifact>();
        for (Artifact a : this.project.getArtifacts()) {
            r.add(this.wrap(a));
        }
        return r;
    }

    protected Artifact getJenkinsWarArtifact() throws MojoExecutionException {
        for (Artifact a : this.resolveDependencies("test")) {
            boolean match;
            if (this.jenkinsWarId != null) {
                match = (a.getGroupId() + ":" + a.getArtifactId()).equals(this.jenkinsWarId);
            } else {
                boolean bl = match = !(!a.getArtifactId().equals("jenkins-war") && !a.getArtifactId().equals("hudson-war") || !a.getType().equals("executable-war") && !a.getType().equals("war"));
            }
            if (!match) continue;
            return a;
        }
        if (this.jenkinsWarId != null) {
            this.getLog().error((CharSequence)("Unable to locate jenkins.war in '" + this.jenkinsWarId + "'"));
        } else {
            this.getLog().error((CharSequence)"Unable to locate jenkins.war. Add the following dependency in your POM:\n\n<dependency>\n  <groupId>org.jenkins-ci.main</groupId>\n  <artifactId>jenkins-war</artifactId>\n  <type>war</type>\n  <version>1.396<!-- replace this with the version you want--></version>\n  <scope>test</scope>\n</dependency>");
        }
        throw new MojoExecutionException("Unable to find jenkins.war");
    }
}

