/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.DependencyNode;
import org.jenkinsci.maven.plugins.hpi.AbstractJenkinsMojo;

public abstract class AbstractDependencyGraphTraversingMojo
extends AbstractJenkinsMojo {
    protected void traverseProject() throws DependencyCollectionException {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        buildingRequest.setProject(this.project);
        buildingRequest.setRemoteRepositories(this.project.getRemoteArtifactRepositories());
        ArtifactTypeRegistry artifactTypeRegistry = this.session.getRepositorySession().getArtifactTypeRegistry();
        List dependencies = this.project.getDependencies().stream().filter(d -> !d.isOptional()).filter(d -> !List.of("test", "provided").contains(d.getScope())).map(d -> RepositoryUtils.toDependency((Dependency)d, (ArtifactTypeRegistry)artifactTypeRegistry)).collect(Collectors.toList());
        List managedDependencies = null;
        if (this.project.getDependencyManagement() != null) {
            managedDependencies = this.project.getDependencyManagement().getDependencies().stream().map(d -> RepositoryUtils.toDependency((Dependency)d, (ArtifactTypeRegistry)artifactTypeRegistry)).collect(Collectors.toList());
        }
        CollectRequest collectRequest = new CollectRequest(dependencies, managedDependencies, this.project.getRemoteProjectRepositories());
        collectRequest.setRootArtifact(RepositoryUtils.toArtifact((Artifact)this.project.getArtifact()));
        DependencyNode node = this.repositorySystem.collectDependencies(buildingRequest.getRepositorySession(), collectRequest).getRoot();
        this.visit(node);
    }

    protected void visit(DependencyNode g) {
        this.visit(g, true);
    }

    private void visit(DependencyNode g, boolean isRoot) {
        if (this.accept(g, isRoot)) {
            for (DependencyNode dn : g.getChildren()) {
                this.visit(dn, false);
            }
        }
    }

    protected abstract boolean accept(DependencyNode var1, boolean var2);
}

