/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.util.VersionNumber;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import javax.lang.model.SourceVersion;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jenkinsci.maven.plugins.hpi.AbstractJenkinsMojo;

@Mojo(name="insert-test", defaultPhase=LifecyclePhase.GENERATE_TEST_SOURCES, requiresDependencyResolution=ResolutionScope.TEST)
public class TestInsertionMojo
extends AbstractJenkinsMojo {
    @Parameter(property="maven-hpi-plugin.disabledTestInjection", defaultValue="false")
    private boolean disabledTestInjection;
    @Parameter(property="maven-hpi-plugin.injectedTestPackage", defaultValue="${project.groupId}.${project.artifactId}")
    private String injectedTestPackage;
    @Parameter(property="maven-hpi-plugin.injectedTestName", defaultValue="InjectedTest")
    private String injectedTestName;
    @Parameter(property="jelly.requirePI", defaultValue="true")
    private boolean requirePI;
    @Parameter(property="jelly.requireNoInlineJS", defaultValue="true")
    private boolean requireNoInlineJS;
    @Parameter(defaultValue="org.jenkins-ci.main:jenkins-test-harness")
    protected String jenkinsTestHarnessId;

    private static String quote(String s) {
        return "\"" + s.replace("\\", "\\\\") + "\"";
    }

    @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"})
    public void execute() throws MojoExecutionException, MojoFailureException {
        block21: {
            if (!this.project.getPackaging().equals("hpi")) {
                Artifact jenkinsTestHarness = null;
                if (this.jenkinsTestHarnessId != null) {
                    for (Artifact b : this.project.getTestArtifacts()) {
                        if (!this.jenkinsTestHarnessId.equals(b.getGroupId() + ":" + b.getArtifactId())) continue;
                        jenkinsTestHarness = b;
                        break;
                    }
                }
                if (jenkinsTestHarness != null) {
                    try {
                        ArtifactVersion version = jenkinsTestHarness.getSelectedVersion();
                        if (version == null || version.compareTo((Object)new DefaultArtifactVersion("2.14")) < 0) {
                            this.getLog().info((CharSequence)("Skipping " + this.project.getName() + " because it's not <packaging>hpi</packaging> and the " + this.jenkinsTestHarnessId + ", " + String.valueOf(version) + ", is less than 2.14"));
                            return;
                        }
                        break block21;
                    }
                    catch (OverConstrainedVersionException e) {
                        throw new MojoFailureException("Build should be failed before we get here if there is an over-constrained version", (Throwable)e);
                    }
                }
                this.getLog().info((CharSequence)("Skipping " + this.project.getName() + " because it's not <packaging>hpi</packaging> and we could not determine the version of " + this.jenkinsTestHarnessId + " used by this project"));
                return;
            }
        }
        if (this.disabledTestInjection) {
            this.getLog().info((CharSequence)"Skipping auto-test generation");
            return;
        }
        String target = this.findJenkinsVersion();
        if (new VersionNumber(target).compareTo(new VersionNumber("1.327")) < 0) {
            this.getLog().info((CharSequence)("Skipping auto-test generation because we are targeting Jenkins " + target + " (at least 1.327 is required)."));
            return;
        }
        File f = new File(this.project.getBasedir(), "target/generated-test-sources/injected");
        try {
            Files.createDirectories(f.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create injected test directory", (Exception)e);
        }
        String packageName = TestInsertionMojo.legalizePackageName(this.injectedTestPackage);
        File javaFile = new File(f, packageName.replace(".", File.separator) + File.separator + this.injectedTestName + ".java");
        File parentFile = javaFile.getParentFile();
        if (!parentFile.mkdirs()) {
            this.getLog().debug((CharSequence)(String.valueOf(parentFile) + " already existed."));
        }
        try (PrintWriter w = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(javaFile), StandardCharsets.UTF_8));){
            String content = "package %s;\nimport java.util.*;\n/**\n * Entry point to auto-generated tests (generated by maven-hpi-plugin).\n * If this fails to compile, you are probably using Hudson < 1.327. If so, disable\n * this code generation by configuring maven-hpi-plugin to <disabledTestInjection>true</disabledTestInjection>.\n */\npublic class %s extends junit.framework.TestCase {\n  public static junit.framework.Test suite() throws Exception {\n    System.out.println(\"Running tests for \" + %s);\n    Map<String, Object> parameters = new HashMap<String, Object>();\n    parameters.put(\"basedir\", %s);\n    parameters.put(\"artifactId\", %s);\n    parameters.put(\"packaging\", %s);\n    parameters.put(\"outputDirectory\", %s);\n    parameters.put(\"testOutputDirectory\", %s);\n    parameters.put(\"requirePI\", %s);\n    parameters.put(\"requireNoInlineJS\", %s);\n    return org.jvnet.hudson.test.PluginAutomaticTestBuilder.build(parameters);\n  }\n}\n".formatted(packageName, this.injectedTestName, TestInsertionMojo.quote(this.project.getGroupId() + ":" + this.project.getArtifactId() + ":" + this.project.getVersion()), TestInsertionMojo.quote(this.project.getBasedir().getAbsolutePath()), TestInsertionMojo.quote(this.project.getArtifactId()), TestInsertionMojo.quote(this.project.getPackaging()), TestInsertionMojo.quote(this.project.getBuild().getOutputDirectory()), TestInsertionMojo.quote(this.project.getBuild().getTestOutputDirectory()), TestInsertionMojo.quote(String.valueOf(this.requirePI)), TestInsertionMojo.quote(String.valueOf(this.requireNoInlineJS)));
            w.print(content);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create injected tests", (Exception)e);
        }
        this.project.addTestCompileSourceRoot(f.getAbsolutePath());
        try {
            Files.setLastModifiedTime(javaFile.toPath(), FileTime.fromMillis(0L));
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Failed to clear last modified time on " + String.valueOf(javaFile)), (Throwable)e);
        }
    }

    static String legalizePackageName(@NonNull String input) throws MojoFailureException {
        Object result = input.replace('-', '_');
        if (!((String)result).isEmpty() && Character.isDigit(((String)result).charAt(0))) {
            result = "_" + (String)result;
        }
        if (!SourceVersion.isName((CharSequence)result)) {
            throw new MojoFailureException("Could not convert " + input + " to a legal java package name. Please override \"injectedTestPackage\" with a valid java package name.");
        }
        return result;
    }
}

