/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.jenkinsci.maven.plugins.hpi.AbstractJenkinsMojo;

public abstract class ResolverDependencyGraphTraversingMojo
extends AbstractJenkinsMojo {
    @Component
    protected RepositorySystem resolverRepositorySystem;

    protected void traverseProject() throws MojoExecutionException {
        try {
            RepositorySystemSession repositorySystemSession = this.session.getRepositorySession();
            List dependencies = this.project.getDependencies().stream().map(dep -> RepositoryUtils.toDependency((Dependency)dep, (ArtifactTypeRegistry)this.session.getRepositorySession().getArtifactTypeRegistry())).collect(Collectors.toList());
            CollectRequest collectRequest = new CollectRequest();
            collectRequest.setRoot(new org.eclipse.aether.graph.Dependency(RepositoryUtils.toArtifact((Artifact)this.project.getArtifact()), null));
            collectRequest.setDependencies(dependencies);
            if (this.project.getDependencyManagement() != null) {
                collectRequest.setManagedDependencies(this.project.getDependencyManagement().getDependencies().stream().map(dep -> RepositoryUtils.toDependency((Dependency)dep, (ArtifactTypeRegistry)this.session.getRepositorySession().getArtifactTypeRegistry())).collect(Collectors.toList()));
            }
            collectRequest.setRepositories(RepositoryUtils.toRepos((List)this.project.getRemoteArtifactRepositories()));
            DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, null);
            DependencyResult result = this.resolverRepositorySystem.resolveDependencies(repositorySystemSession, dependencyRequest);
            this.visit(result.getRoot());
        }
        catch (DependencyResolutionException e) {
            throw new MojoExecutionException("Failed to resolve dependencies", (Exception)((Object)e));
        }
    }

    protected void visit(DependencyNode node) {
        this.visit(node, null);
    }

    protected void visit(DependencyNode node, DependencyNode parent) {
        if (this.accept(node, parent)) {
            for (DependencyNode child : node.getChildren()) {
                this.visit(child, node);
            }
        }
    }

    protected abstract boolean accept(DependencyNode var1, DependencyNode var2);
}

