/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;
import org.jenkinsci.maven.plugins.hpi.MavenArtifact;
import org.jenkinsci.maven.plugins.hpi.ResolverDependencyGraphTraversingMojo;

@Mojo(name="assemble-dependencies", requiresProject=true, threadSafe=true)
public class AssembleDependenciesMojo
extends ResolverDependencyGraphTraversingMojo {
    @Parameter(defaultValue="${project.build.directory}/plugins/")
    private File outputDirectory;
    @Parameter
    private boolean includesOptional;
    @Parameter
    private boolean useJpiExtension;
    @Parameter
    private String scopes = "compile,runtime";
    private List<String> parsedScopes;
    private final Map<String, MavenArtifact> hpis = new HashMap<String, MavenArtifact>();

    @Override
    protected boolean accept(DependencyNode node, DependencyNode parent) {
        MavenArtifact a = this.wrap(RepositoryUtils.toArtifact((Artifact)node.getArtifact()));
        if (!this.parsedScopes.contains(a.getScope())) {
            return false;
        }
        if (!this.includesOptional && a.isOptional()) {
            return false;
        }
        if (!a.isPlugin(this.getLog())) {
            return parent == null;
        }
        MavenArtifact v = this.hpis.get(a.getArtifactId());
        if (v == null || a.isNewerThan(v)) {
            this.hpis.put(a.getArtifactId(), a);
        }
        return true;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.hpis.clear();
            this.parsedScopes = new ArrayList<String>();
            this.parsedScopes.add(null);
            for (String s : this.scopes.split(",")) {
                this.parsedScopes.add(s.trim());
            }
            this.traverseProject();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to list up dependencies", e);
        }
        for (MavenArtifact a : this.hpis.values()) {
            try {
                MavenArtifact hpi = a.getHpi();
                this.getLog().debug((CharSequence)("Copying " + String.valueOf(hpi.getFile())));
                FileUtils.copyFile((File)hpi.getFile(), (File)new File(this.outputDirectory, hpi.getArtifactId() + "." + this.getExtension()));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to copy dependency: " + String.valueOf(a), (Exception)e);
            }
        }
    }

    private String getExtension() {
        return this.useJpiExtension ? "jpi" : "hpi";
    }
}

