/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xunit.threshold;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.DescriptorExtensionList;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.xunit.threshold.Messages;
import org.jenkinsci.plugins.xunit.threshold.XUnitThreshold;
import org.kohsuke.stapler.QueryParameter;

public abstract class XUnitThresholdDescriptor<T extends XUnitThreshold>
extends Descriptor<XUnitThreshold> {
    public XUnitThresholdDescriptor(Class<? extends XUnitThreshold> clazz) {
        super(clazz);
    }

    public static DescriptorExtensionList<XUnitThreshold, XUnitThresholdDescriptor<?>> all() {
        return Jenkins.get().getDescriptorList(XUnitThreshold.class);
    }

    public abstract String getUnstableThresholdImgTitle();

    public abstract String getUnstableNewThresholdImgTitle();

    public abstract String getFailureThresholdImgTitle();

    public abstract String getFailureNewThresholdImgTitle();

    public abstract String getThresholdHelpMessage();

    public FormValidation doCheckUnstableThreshold(@QueryParameter(fixEmpty=true) @CheckForNull String unstableThreshold) {
        return this.validate(unstableThreshold);
    }

    public FormValidation doCheckUnstableNewThreshold(@QueryParameter(fixEmpty=true) @CheckForNull String unstableNewThreshold) {
        return this.validate(unstableNewThreshold);
    }

    public FormValidation doCheckFailureThreshold(@QueryParameter(fixEmpty=true) @CheckForNull String failureThreshold) {
        return this.validate(failureThreshold);
    }

    public FormValidation doCheckFailureNewThreshold(@QueryParameter(fixEmpty=true) @CheckForNull String failureNewThreshold) {
        return this.validate(failureNewThreshold);
    }

    private FormValidation validate(String threshold) {
        if (Util.fixEmptyAndTrim((String)threshold) != null) {
            try {
                Integer.parseInt(threshold);
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)Messages.XUnitThresholdDescriptor_checkThreshold(threshold));
            }
        }
        return FormValidation.ok();
    }
}

