/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xunit.service;

import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.lib.dtkit.model.InputMetric;
import org.jenkinsci.lib.dtkit.model.InputMetricXSL;
import org.jenkinsci.lib.dtkit.util.converter.ConversionException;
import org.jenkinsci.plugins.xunit.service.TransformerException;
import org.jenkinsci.plugins.xunit.service.XUnitLog;
import org.jenkinsci.plugins.xunit.service.XUnitToolInfo;

public class XUnitConversionService
implements Serializable {
    private static final long serialVersionUID = 6019846684040298718L;
    private XUnitLog xUnitLog;

    @Inject
    public XUnitConversionService(XUnitLog xUnitLog) {
        this.xUnitLog = xUnitLog;
    }

    public File convert(XUnitToolInfo xUnitToolInfo, File inputFile, File junitOutputDirectory) throws IOException {
        InputMetric inputMetric = xUnitToolInfo.getInputMetric();
        File parent = new File(junitOutputDirectory, inputMetric.getToolName());
        FileUtils.forceMkdir((File)parent);
        File junitTargetFile = this.getTargetFile(parent);
        try {
            if (inputMetric instanceof InputMetricXSL && xUnitToolInfo.getXSLFile() != null) {
                this.convertCustomMetric(xUnitToolInfo, inputFile, inputMetric, junitTargetFile);
            } else {
                inputMetric.convert(inputFile, junitTargetFile);
            }
            return junitTargetFile;
        }
        catch (ConversionException e) {
            Throwable cause = e.getCause();
            throw new TransformerException("Conversion error: " + (cause != null ? cause.getMessage() : e.getMessage()));
        }
    }

    private void convertCustomMetric(XUnitToolInfo xUnitToolInfo, File inputFile, InputMetric inputMetric, File junitTargetFile) {
        InputMetricXSL inputMetricXSL = (InputMetricXSL)inputMetric;
        try {
            inputMetricXSL.convert(inputFile, junitTargetFile, xUnitToolInfo.getXSLFile(), null);
        }
        catch (Exception xe) {
            this.xUnitLog.error("Error occurs on the use of the user stylesheet: " + xe.getMessage());
            this.xUnitLog.info("Fallback on the native embedded stylesheet.");
            inputMetric.convert(inputFile, junitTargetFile);
        }
    }

    private File getTargetFile(File parent) {
        String uniqueTestName = UUID.randomUUID().toString();
        return new File(parent, "TEST-" + uniqueTestName + ".xml");
    }
}

