// CHECKSTYLE:OFF

package org.jenkinsci.plugins.xunit.threshold;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code PassedThreshold.failureNewThreshold}: {@code If the total
     * number of passed tests is lower then this threshold then a build is
     * considered as failed. Leave this field empty if the unstable state of
     * the build should not depend on the total number of new passed tests.}.
     * 
     * @return
     *     {@code If the total number of passed tests is lower then this
     *     threshold then a build is considered as failed. Leave this field empty
     *     if the unstable state of the build should not depend on the total
     *     number of new passed tests.}
     */
    public static String PassedThreshold_failureNewThreshold() {
        return holder.format("PassedThreshold.failureNewThreshold");
    }

    /**
     * Key {@code PassedThreshold.failureNewThreshold}: {@code If the total
     * number of passed tests is lower then this threshold then a build is
     * considered as failed. Leave this field empty if the unstable state of
     * the build should not depend on the total number of new passed tests.}.
     * 
     * @return
     *     {@code If the total number of passed tests is lower then this
     *     threshold then a build is considered as failed. Leave this field empty
     *     if the unstable state of the build should not depend on the total
     *     number of new passed tests.}
     */
    public static Localizable _PassedThreshold_failureNewThreshold() {
        return new Localizable(holder, "PassedThreshold.failureNewThreshold");
    }

    /**
     * Key {@code XUnitThresholdDescriptor.checkThreshold}: {@code Invalid
     * threshold format for value: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid threshold format for value: {0}}
     */
    public static String XUnitThresholdDescriptor_checkThreshold(Object arg0) {
        return holder.format("XUnitThresholdDescriptor.checkThreshold", arg0);
    }

    /**
     * Key {@code XUnitThresholdDescriptor.checkThreshold}: {@code Invalid
     * threshold format for value: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid threshold format for value: {0}}
     */
    public static Localizable _XUnitThresholdDescriptor_checkThreshold(Object arg0) {
        return new Localizable(holder, "XUnitThresholdDescriptor.checkThreshold", arg0);
    }

    /**
     * Key {@code failureNewThreshold.skippedTests}: {@code If the total
     * number of skipped tests exceeds this threshold then a build is
     * considered as failed. Leave this field empty if the unstable state of
     * the build should not depend on the total number of new skipped
     * tests.}.
     * 
     * @return
     *     {@code If the total number of skipped tests exceeds this threshold
     *     then a build is considered as failed. Leave this field empty if the
     *     unstable state of the build should not depend on the total number of
     *     new skipped tests.}
     */
    public static String failureNewThreshold_skippedTests() {
        return holder.format("failureNewThreshold.skippedTests");
    }

    /**
     * Key {@code failureNewThreshold.skippedTests}: {@code If the total
     * number of skipped tests exceeds this threshold then a build is
     * considered as failed. Leave this field empty if the unstable state of
     * the build should not depend on the total number of new skipped
     * tests.}.
     * 
     * @return
     *     {@code If the total number of skipped tests exceeds this threshold
     *     then a build is considered as failed. Leave this field empty if the
     *     unstable state of the build should not depend on the total number of
     *     new skipped tests.}
     */
    public static Localizable _failureNewThreshold_skippedTests() {
        return new Localizable(holder, "failureNewThreshold.skippedTests");
    }

    /**
     * Key {@code displayName.skippedTests}: {@code Skipped Tests}.
     * 
     * @return
     *     {@code Skipped Tests}
     */
    public static String displayName_skippedTests() {
        return holder.format("displayName.skippedTests");
    }

    /**
     * Key {@code displayName.skippedTests}: {@code Skipped Tests}.
     * 
     * @return
     *     {@code Skipped Tests}
     */
    public static Localizable _displayName_skippedTests() {
        return new Localizable(holder, "displayName.skippedTests");
    }

    /**
     * Key {@code PassedThreshold.unstableThreshold}: {@code According the
     * threshold mode, if the total number (or the percent) of passed tests
     * is lower than this threshold then a build is considered as unstable.
     * Leave this field empty if the unstable state of the build should not
     * depend on the total number of passed tests.}.
     * 
     * @return
     *     {@code According the threshold mode, if the total number (or the
     *     percent) of passed tests is lower than this threshold then a build is
     *     considered as unstable. Leave this field empty if the unstable state
     *     of the build should not depend on the total number of passed tests.}
     */
    public static String PassedThreshold_unstableThreshold() {
        return holder.format("PassedThreshold.unstableThreshold");
    }

    /**
     * Key {@code PassedThreshold.unstableThreshold}: {@code According the
     * threshold mode, if the total number (or the percent) of passed tests
     * is lower than this threshold then a build is considered as unstable.
     * Leave this field empty if the unstable state of the build should not
     * depend on the total number of passed tests.}.
     * 
     * @return
     *     {@code According the threshold mode, if the total number (or the
     *     percent) of passed tests is lower than this threshold then a build is
     *     considered as unstable. Leave this field empty if the unstable state
     *     of the build should not depend on the total number of passed tests.}
     */
    public static Localizable _PassedThreshold_unstableThreshold() {
        return new Localizable(holder, "PassedThreshold.unstableThreshold");
    }

    /**
     * Key {@code thresholdHelpMessage.failedTests}: {@code Configure the
     * build status. A build is considered as unstable or failure if the new
     * or total number of failed tests exceeds the specified thresholds. }.
     * 
     * @return
     *     {@code Configure the build status. A build is considered as unstable
     *     or failure if the new or total number of failed tests exceeds the
     *     specified thresholds. }
     */
    public static String thresholdHelpMessage_failedTests() {
        return holder.format("thresholdHelpMessage.failedTests");
    }

    /**
     * Key {@code thresholdHelpMessage.failedTests}: {@code Configure the
     * build status. A build is considered as unstable or failure if the new
     * or total number of failed tests exceeds the specified thresholds. }.
     * 
     * @return
     *     {@code Configure the build status. A build is considered as unstable
     *     or failure if the new or total number of failed tests exceeds the
     *     specified thresholds. }
     */
    public static Localizable _thresholdHelpMessage_failedTests() {
        return new Localizable(holder, "thresholdHelpMessage.failedTests");
    }

    /**
     * Key {@code failureNewThreshold.failedTests}: {@code If the total
     * number of failed tests exceeds this threshold then a build is
     * considered as failed. Leave this field empty if the unstable state of
     * the build should not depend on the total number of new failed tests.}.
     * 
     * @return
     *     {@code If the total number of failed tests exceeds this threshold then
     *     a build is considered as failed. Leave this field empty if the
     *     unstable state of the build should not depend on the total number of
     *     new failed tests.}
     */
    public static String failureNewThreshold_failedTests() {
        return holder.format("failureNewThreshold.failedTests");
    }

    /**
     * Key {@code failureNewThreshold.failedTests}: {@code If the total
     * number of failed tests exceeds this threshold then a build is
     * considered as failed. Leave this field empty if the unstable state of
     * the build should not depend on the total number of new failed tests.}.
     * 
     * @return
     *     {@code If the total number of failed tests exceeds this threshold then
     *     a build is considered as failed. Leave this field empty if the
     *     unstable state of the build should not depend on the total number of
     *     new failed tests.}
     */
    public static Localizable _failureNewThreshold_failedTests() {
        return new Localizable(holder, "failureNewThreshold.failedTests");
    }

    /**
     * Key {@code PassedThreshold.thresholdHelpMessage}: {@code Configure the
     * build status. A build is considered as unstable or failure if the new
     * or total number of passed tests is lower than the specified
     * thresholds. }.
     * 
     * @return
     *     {@code Configure the build status. A build is considered as unstable
     *     or failure if the new or total number of passed tests is lower than
     *     the specified thresholds. }
     */
    public static String PassedThreshold_thresholdHelpMessage() {
        return holder.format("PassedThreshold.thresholdHelpMessage");
    }

    /**
     * Key {@code PassedThreshold.thresholdHelpMessage}: {@code Configure the
     * build status. A build is considered as unstable or failure if the new
     * or total number of passed tests is lower than the specified
     * thresholds. }.
     * 
     * @return
     *     {@code Configure the build status. A build is considered as unstable
     *     or failure if the new or total number of passed tests is lower than
     *     the specified thresholds. }
     */
    public static Localizable _PassedThreshold_thresholdHelpMessage() {
        return new Localizable(holder, "PassedThreshold.thresholdHelpMessage");
    }

    /**
     * Key {@code XUnitThreshold.percentThreshold.message}: {@code The
     * percent of the total number of tests for the threshold ''{0}'' exceeds
     * the specified "{1}" percent value.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The percent of the total number of tests for the threshold
     *     ''{0}'' exceeds the specified "{1}" percent value.}
     */
    public static String XUnitThreshold_percentThreshold_message(Object arg0, Object arg1) {
        return holder.format("XUnitThreshold.percentThreshold.message", arg0, arg1);
    }

    /**
     * Key {@code XUnitThreshold.percentThreshold.message}: {@code The
     * percent of the total number of tests for the threshold ''{0}'' exceeds
     * the specified "{1}" percent value.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The percent of the total number of tests for the threshold
     *     ''{0}'' exceeds the specified "{1}" percent value.}
     */
    public static Localizable _XUnitThreshold_percentThreshold_message(Object arg0, Object arg1) {
        return new Localizable(holder, "XUnitThreshold.percentThreshold.message", arg0, arg1);
    }

    /**
     * Key {@code XUnitThreshold.percentNewThreshold.message}: {@code The
     * percent of the new number of tests for the threshold ''{0}'' exceeds
     * the specified "{1}" percent value.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The percent of the new number of tests for the threshold
     *     ''{0}'' exceeds the specified "{1}" percent value.}
     */
    public static String XUnitThreshold_percentNewThreshold_message(Object arg0, Object arg1) {
        return holder.format("XUnitThreshold.percentNewThreshold.message", arg0, arg1);
    }

    /**
     * Key {@code XUnitThreshold.percentNewThreshold.message}: {@code The
     * percent of the new number of tests for the threshold ''{0}'' exceeds
     * the specified "{1}" percent value.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The percent of the new number of tests for the threshold
     *     ''{0}'' exceeds the specified "{1}" percent value.}
     */
    public static Localizable _XUnitThreshold_percentNewThreshold_message(Object arg0, Object arg1) {
        return new Localizable(holder, "XUnitThreshold.percentNewThreshold.message", arg0, arg1);
    }

    /**
     * Key {@code thresholdHelpMessage.skippedTests}: {@code Configure the
     * build status. A build is considered as unstable or failure if the new
     * or total number of skipped tests exceeds the specified thresholds. }.
     * 
     * @return
     *     {@code Configure the build status. A build is considered as unstable
     *     or failure if the new or total number of skipped tests exceeds the
     *     specified thresholds. }
     */
    public static String thresholdHelpMessage_skippedTests() {
        return holder.format("thresholdHelpMessage.skippedTests");
    }

    /**
     * Key {@code thresholdHelpMessage.skippedTests}: {@code Configure the
     * build status. A build is considered as unstable or failure if the new
     * or total number of skipped tests exceeds the specified thresholds. }.
     * 
     * @return
     *     {@code Configure the build status. A build is considered as unstable
     *     or failure if the new or total number of skipped tests exceeds the
     *     specified thresholds. }
     */
    public static Localizable _thresholdHelpMessage_skippedTests() {
        return new Localizable(holder, "thresholdHelpMessage.skippedTests");
    }

    /**
     * Key {@code XUnitThreshold.newThreshold.message}: {@code The new number
     * of tests for the threshold ''{0}'' exceeds the specified "{1}"
     * value.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The new number of tests for the threshold ''{0}'' exceeds the
     *     specified "{1}" value.}
     */
    public static String XUnitThreshold_newThreshold_message(Object arg0, Object arg1) {
        return holder.format("XUnitThreshold.newThreshold.message", arg0, arg1);
    }

    /**
     * Key {@code XUnitThreshold.newThreshold.message}: {@code The new number
     * of tests for the threshold ''{0}'' exceeds the specified "{1}"
     * value.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The new number of tests for the threshold ''{0}'' exceeds the
     *     specified "{1}" value.}
     */
    public static Localizable _XUnitThreshold_newThreshold_message(Object arg0, Object arg1) {
        return new Localizable(holder, "XUnitThreshold.newThreshold.message", arg0, arg1);
    }

    /**
     * Key {@code unstableNewThreshold.failedTests}: {@code If the total
     * number of failed tests exceeds this threshold then a build is
     * considered as unstable. Leave this field empty if the unstable state
     * of the build should not depend on the total number of new failed
     * tests.}.
     * 
     * @return
     *     {@code If the total number of failed tests exceeds this threshold then
     *     a build is considered as unstable. Leave this field empty if the
     *     unstable state of the build should not depend on the total number of
     *     new failed tests.}
     */
    public static String unstableNewThreshold_failedTests() {
        return holder.format("unstableNewThreshold.failedTests");
    }

    /**
     * Key {@code unstableNewThreshold.failedTests}: {@code If the total
     * number of failed tests exceeds this threshold then a build is
     * considered as unstable. Leave this field empty if the unstable state
     * of the build should not depend on the total number of new failed
     * tests.}.
     * 
     * @return
     *     {@code If the total number of failed tests exceeds this threshold then
     *     a build is considered as unstable. Leave this field empty if the
     *     unstable state of the build should not depend on the total number of
     *     new failed tests.}
     */
    public static Localizable _unstableNewThreshold_failedTests() {
        return new Localizable(holder, "unstableNewThreshold.failedTests");
    }

    /**
     * Key {@code unstableNewThreshold.skippedTests}: {@code If the total
     * number of skipped tests exceeds this threshold then a build is
     * considered as unstable. Leave this field empty if the unstable state
     * of the build should not depend on the total number of new skipped
     * tests.}.
     * 
     * @return
     *     {@code If the total number of skipped tests exceeds this threshold
     *     then a build is considered as unstable. Leave this field empty if the
     *     unstable state of the build should not depend on the total number of
     *     new skipped tests.}
     */
    public static String unstableNewThreshold_skippedTests() {
        return holder.format("unstableNewThreshold.skippedTests");
    }

    /**
     * Key {@code unstableNewThreshold.skippedTests}: {@code If the total
     * number of skipped tests exceeds this threshold then a build is
     * considered as unstable. Leave this field empty if the unstable state
     * of the build should not depend on the total number of new skipped
     * tests.}.
     * 
     * @return
     *     {@code If the total number of skipped tests exceeds this threshold
     *     then a build is considered as unstable. Leave this field empty if the
     *     unstable state of the build should not depend on the total number of
     *     new skipped tests.}
     */
    public static Localizable _unstableNewThreshold_skippedTests() {
        return new Localizable(holder, "unstableNewThreshold.skippedTests");
    }

    /**
     * Key {@code XUnitThreshold.failureNewThreshold.name}: {@code new
     * failure threshold}.
     * 
     * @return
     *     {@code new failure threshold}
     */
    public static String XUnitThreshold_failureNewThreshold_name() {
        return holder.format("XUnitThreshold.failureNewThreshold.name");
    }

    /**
     * Key {@code XUnitThreshold.failureNewThreshold.name}: {@code new
     * failure threshold}.
     * 
     * @return
     *     {@code new failure threshold}
     */
    public static Localizable _XUnitThreshold_failureNewThreshold_name() {
        return new Localizable(holder, "XUnitThreshold.failureNewThreshold.name");
    }

    /**
     * Key {@code XUnitThreshold.unstableNewThreshold.name}: {@code new
     * unstable threshold}.
     * 
     * @return
     *     {@code new unstable threshold}
     */
    public static String XUnitThreshold_unstableNewThreshold_name() {
        return holder.format("XUnitThreshold.unstableNewThreshold.name");
    }

    /**
     * Key {@code XUnitThreshold.unstableNewThreshold.name}: {@code new
     * unstable threshold}.
     * 
     * @return
     *     {@code new unstable threshold}
     */
    public static Localizable _XUnitThreshold_unstableNewThreshold_name() {
        return new Localizable(holder, "XUnitThreshold.unstableNewThreshold.name");
    }

    /**
     * Key {@code unstableThreshold.skippedTests}: {@code If the total number
     * of skipped tests exceeds this threshold then a build is considered as
     * unstable. Leave this field empty if the unstable state of the build
     * should not depend on the total number of skipped tests.}.
     * 
     * @return
     *     {@code If the total number of skipped tests exceeds this threshold
     *     then a build is considered as unstable. Leave this field empty if the
     *     unstable state of the build should not depend on the total number of
     *     skipped tests.}
     */
    public static String unstableThreshold_skippedTests() {
        return holder.format("unstableThreshold.skippedTests");
    }

    /**
     * Key {@code unstableThreshold.skippedTests}: {@code If the total number
     * of skipped tests exceeds this threshold then a build is considered as
     * unstable. Leave this field empty if the unstable state of the build
     * should not depend on the total number of skipped tests.}.
     * 
     * @return
     *     {@code If the total number of skipped tests exceeds this threshold
     *     then a build is considered as unstable. Leave this field empty if the
     *     unstable state of the build should not depend on the total number of
     *     skipped tests.}
     */
    public static Localizable _unstableThreshold_skippedTests() {
        return new Localizable(holder, "unstableThreshold.skippedTests");
    }

    /**
     * Key {@code XUnitThreshold.failureThreshold.name}: {@code failure
     * threshold}.
     * 
     * @return
     *     {@code failure threshold}
     */
    public static String XUnitThreshold_failureThreshold_name() {
        return holder.format("XUnitThreshold.failureThreshold.name");
    }

    /**
     * Key {@code XUnitThreshold.failureThreshold.name}: {@code failure
     * threshold}.
     * 
     * @return
     *     {@code failure threshold}
     */
    public static Localizable _XUnitThreshold_failureThreshold_name() {
        return new Localizable(holder, "XUnitThreshold.failureThreshold.name");
    }

    /**
     * Key {@code XUnitThreshold.threshold.message}: {@code The total number
     * of tests for the threshold ''{0}'' exceeds the specified "{1}"
     * value.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The total number of tests for the threshold ''{0}'' exceeds the
     *     specified "{1}" value.}
     */
    public static String XUnitThreshold_threshold_message(Object arg0, Object arg1) {
        return holder.format("XUnitThreshold.threshold.message", arg0, arg1);
    }

    /**
     * Key {@code XUnitThreshold.threshold.message}: {@code The total number
     * of tests for the threshold ''{0}'' exceeds the specified "{1}"
     * value.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The total number of tests for the threshold ''{0}'' exceeds the
     *     specified "{1}" value.}
     */
    public static Localizable _XUnitThreshold_threshold_message(Object arg0, Object arg1) {
        return new Localizable(holder, "XUnitThreshold.threshold.message", arg0, arg1);
    }

    /**
     * Key {@code failureThreshold.failedTests}: {@code If the total number
     * of failed exceeds this threshold then a build is considered as failed.
     * Leave this field empty if the unstable state of the build should not
     * depend on the total number of failed tests.}.
     * 
     * @return
     *     {@code If the total number of failed exceeds this threshold then a
     *     build is considered as failed. Leave this field empty if the unstable
     *     state of the build should not depend on the total number of failed
     *     tests.}
     */
    public static String failureThreshold_failedTests() {
        return holder.format("failureThreshold.failedTests");
    }

    /**
     * Key {@code failureThreshold.failedTests}: {@code If the total number
     * of failed exceeds this threshold then a build is considered as failed.
     * Leave this field empty if the unstable state of the build should not
     * depend on the total number of failed tests.}.
     * 
     * @return
     *     {@code If the total number of failed exceeds this threshold then a
     *     build is considered as failed. Leave this field empty if the unstable
     *     state of the build should not depend on the total number of failed
     *     tests.}
     */
    public static Localizable _failureThreshold_failedTests() {
        return new Localizable(holder, "failureThreshold.failedTests");
    }

    /**
     * Key {@code XUnitThreshold.unstableThreshold.name}: {@code unstable
     * threshold}.
     * 
     * @return
     *     {@code unstable threshold}
     */
    public static String XUnitThreshold_unstableThreshold_name() {
        return holder.format("XUnitThreshold.unstableThreshold.name");
    }

    /**
     * Key {@code XUnitThreshold.unstableThreshold.name}: {@code unstable
     * threshold}.
     * 
     * @return
     *     {@code unstable threshold}
     */
    public static Localizable _XUnitThreshold_unstableThreshold_name() {
        return new Localizable(holder, "XUnitThreshold.unstableThreshold.name");
    }

    /**
     * Key {@code PassedThreshold.displayName}: {@code Passed Tests}.
     * 
     * @return
     *     {@code Passed Tests}
     */
    public static String PassedThreshold_displayName() {
        return holder.format("PassedThreshold.displayName");
    }

    /**
     * Key {@code PassedThreshold.displayName}: {@code Passed Tests}.
     * 
     * @return
     *     {@code Passed Tests}
     */
    public static Localizable _PassedThreshold_displayName() {
        return new Localizable(holder, "PassedThreshold.displayName");
    }

    /**
     * Key {@code PassedThreshold.failureThreshold}: {@code If the total
     * number of passed is lower then this threshold then a build is
     * considered as failed. Leave this field empty if the unstable state of
     * the build should not depend on the total number of passed tests.}.
     * 
     * @return
     *     {@code If the total number of passed is lower then this threshold then
     *     a build is considered as failed. Leave this field empty if the
     *     unstable state of the build should not depend on the total number of
     *     passed tests.}
     */
    public static String PassedThreshold_failureThreshold() {
        return holder.format("PassedThreshold.failureThreshold");
    }

    /**
     * Key {@code PassedThreshold.failureThreshold}: {@code If the total
     * number of passed is lower then this threshold then a build is
     * considered as failed. Leave this field empty if the unstable state of
     * the build should not depend on the total number of passed tests.}.
     * 
     * @return
     *     {@code If the total number of passed is lower then this threshold then
     *     a build is considered as failed. Leave this field empty if the
     *     unstable state of the build should not depend on the total number of
     *     passed tests.}
     */
    public static Localizable _PassedThreshold_failureThreshold() {
        return new Localizable(holder, "PassedThreshold.failureThreshold");
    }

    /**
     * Key {@code failureThreshold.skippedTests}: {@code If the total number
     * of skipped exceeds this threshold then a build is considered as
     * failed. Leave this field empty if the unstable state of the build
     * should not depend on the total number of skipped tests.}.
     * 
     * @return
     *     {@code If the total number of skipped exceeds this threshold then a
     *     build is considered as failed. Leave this field empty if the unstable
     *     state of the build should not depend on the total number of skipped
     *     tests.}
     */
    public static String failureThreshold_skippedTests() {
        return holder.format("failureThreshold.skippedTests");
    }

    /**
     * Key {@code failureThreshold.skippedTests}: {@code If the total number
     * of skipped exceeds this threshold then a build is considered as
     * failed. Leave this field empty if the unstable state of the build
     * should not depend on the total number of skipped tests.}.
     * 
     * @return
     *     {@code If the total number of skipped exceeds this threshold then a
     *     build is considered as failed. Leave this field empty if the unstable
     *     state of the build should not depend on the total number of skipped
     *     tests.}
     */
    public static Localizable _failureThreshold_skippedTests() {
        return new Localizable(holder, "failureThreshold.skippedTests");
    }

    /**
     * Key {@code unstableThreshold.failedTests}: {@code According the
     * threshold mode, if the total number (or the percent) of failed tests
     * exceeds this threshold then a build is considered as unstable. Leave
     * this field empty if the unstable state of the build should not depend
     * on the total number of failed tests.}.
     * 
     * @return
     *     {@code According the threshold mode, if the total number (or the
     *     percent) of failed tests exceeds this threshold then a build is
     *     considered as unstable. Leave this field empty if the unstable state
     *     of the build should not depend on the total number of failed tests.}
     */
    public static String unstableThreshold_failedTests() {
        return holder.format("unstableThreshold.failedTests");
    }

    /**
     * Key {@code unstableThreshold.failedTests}: {@code According the
     * threshold mode, if the total number (or the percent) of failed tests
     * exceeds this threshold then a build is considered as unstable. Leave
     * this field empty if the unstable state of the build should not depend
     * on the total number of failed tests.}.
     * 
     * @return
     *     {@code According the threshold mode, if the total number (or the
     *     percent) of failed tests exceeds this threshold then a build is
     *     considered as unstable. Leave this field empty if the unstable state
     *     of the build should not depend on the total number of failed tests.}
     */
    public static Localizable _unstableThreshold_failedTests() {
        return new Localizable(holder, "unstableThreshold.failedTests");
    }

    /**
     * Key {@code PassedThreshold.unstableNewThreshold}: {@code If the total
     * number of passed tests is lower than this threshold then a build is
     * considered as unstable. Leave this field empty if the unstable state
     * of the build should not depend on the total number of new passed
     * tests.}.
     * 
     * @return
     *     {@code If the total number of passed tests is lower than this
     *     threshold then a build is considered as unstable. Leave this field
     *     empty if the unstable state of the build should not depend on the
     *     total number of new passed tests.}
     */
    public static String PassedThreshold_unstableNewThreshold() {
        return holder.format("PassedThreshold.unstableNewThreshold");
    }

    /**
     * Key {@code PassedThreshold.unstableNewThreshold}: {@code If the total
     * number of passed tests is lower than this threshold then a build is
     * considered as unstable. Leave this field empty if the unstable state
     * of the build should not depend on the total number of new passed
     * tests.}.
     * 
     * @return
     *     {@code If the total number of passed tests is lower than this
     *     threshold then a build is considered as unstable. Leave this field
     *     empty if the unstable state of the build should not depend on the
     *     total number of new passed tests.}
     */
    public static Localizable _PassedThreshold_unstableNewThreshold() {
        return new Localizable(holder, "PassedThreshold.unstableNewThreshold");
    }

    /**
     * Key {@code displayName.failedTests}: {@code Failed Tests}.
     * 
     * @return
     *     {@code Failed Tests}
     */
    public static String displayName_failedTests() {
        return holder.format("displayName.failedTests");
    }

    /**
     * Key {@code displayName.failedTests}: {@code Failed Tests}.
     * 
     * @return
     *     {@code Failed Tests}
     */
    public static Localizable _displayName_failedTests() {
        return new Localizable(holder, "displayName.failedTests");
    }

}
