/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xunit.threshold;

import hudson.model.Result;
import hudson.model.Run;
import hudson.tasks.junit.TestResultSummary;
import org.jenkinsci.plugins.xunit.service.XUnitLog;
import org.jenkinsci.plugins.xunit.threshold.XUnitThreshold;
import org.kohsuke.stapler.DataBoundConstructor;

public class FailedThreshold
extends XUnitThreshold {
    @DataBoundConstructor
    public FailedThreshold() {
    }

    @Override
    public Result getResultThresholdNumber(XUnitLog log, Run<?, ?> build, TestResultSummary testResult, TestResultSummary previousTestResultAction) {
        int failedCount = testResult.getFailCount();
        int previousFailedCount = 0;
        if (previousTestResultAction != null) {
            previousFailedCount = previousTestResultAction.getFailCount();
        }
        int newFailedCount = failedCount - previousFailedCount;
        return this.getResultThresholdNumber(log, failedCount, newFailedCount);
    }

    @Override
    public Result getResultThresholdPercent(XUnitLog log, Run<?, ?> build, TestResultSummary testResult, TestResultSummary previousTestResultAction) {
        double newFailedCount;
        double count = testResult.getTotalCount();
        double failedCount = testResult.getFailCount();
        double percentFailed = failedCount == 0.0 ? 0.0 : failedCount / count * 100.0;
        double previousFailedCount = 0.0;
        if (previousTestResultAction != null) {
            previousFailedCount = previousTestResultAction.getFailCount();
        }
        double percentNewFailed = (newFailedCount = failedCount - previousFailedCount) == 0.0 ? 0.0 : newFailedCount / count * 100.0;
        return this.getResultThresholdPercent(log, percentFailed, percentNewFailed);
    }

    @Override
    public boolean isValidThreshold(double threshold, double value) {
        return value <= threshold;
    }
}

