/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xtriggerapi;

import antlr.ANTLRException;
import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildableItem;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.TaskListener;
import hudson.triggers.Trigger;
import hudson.util.NullStream;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.plugins.envinjectapi.util.EnvVarsResolver;
import org.jenkinsci.plugins.xtriggerapi.XTriggerCause;
import org.jenkinsci.plugins.xtriggerapi.XTriggerCauseAction;
import org.jenkinsci.plugins.xtriggerapi.XTriggerDescriptor;
import org.jenkinsci.plugins.xtriggerapi.XTriggerException;
import org.jenkinsci.plugins.xtriggerapi.XTriggerLog;

public abstract class AbstractTrigger
extends Trigger<BuildableItem>
implements Serializable {
    protected static final Logger LOGGER = Logger.getLogger(AbstractTrigger.class.getName());
    private String triggerLabel;
    private transient boolean unblockConcurrentBuild;
    protected transient boolean offlineSlaveOnStartup = false;

    public AbstractTrigger(String cronTabSpec) throws ANTLRException {
        super(cronTabSpec);
        this.unblockConcurrentBuild = false;
    }

    protected AbstractTrigger(String cronTabSpec, boolean unblockConcurrentBuild) throws ANTLRException {
        super(cronTabSpec);
        this.unblockConcurrentBuild = unblockConcurrentBuild;
    }

    protected AbstractTrigger(String cronTabSpec, String triggerLabel) throws ANTLRException {
        super(cronTabSpec);
        this.triggerLabel = Util.fixEmpty((String)triggerLabel);
        this.unblockConcurrentBuild = false;
    }

    protected AbstractTrigger(String cronTabSpec, String triggerLabel, boolean unblockConcurrentBuild) throws ANTLRException {
        super(cronTabSpec);
        this.triggerLabel = Util.fixEmpty((String)triggerLabel);
        this.unblockConcurrentBuild = unblockConcurrentBuild;
    }

    public String getTriggerLabel() {
        return this.triggerLabel;
    }

    protected abstract File getLogFile();

    protected abstract boolean requiresWorkspaceForPolling();

    public void start(BuildableItem project, boolean newInstance) {
        super.start((Item)project, newInstance);
        XTriggerLog log = new XTriggerLog((TaskListener)new StreamTaskListener((OutputStream)new NullStream()));
        Node pollingNode = this.getPollingNode(log);
        if (pollingNode == null) {
            log.info("Can't find any complete active node.");
            log.info("Checking again in next polling schedule.");
            log.info("Waiting for next schedule.");
            this.offlineSlaveOnStartup = true;
            return;
        }
        if (pollingNode.getRootPath() == null) {
            log.info("The running slave might be offline at the moment.");
            log.info("Waiting for next schedule.");
            this.offlineSlaveOnStartup = true;
            return;
        }
        try {
            this.start(pollingNode, project, newInstance, log);
        }
        catch (XTriggerException xe) {
            LOGGER.log(Level.SEVERE, "Can't initialize trigger", xe);
        }
    }

    protected void start(Node pollingNode, BuildableItem project, boolean newInstance, XTriggerLog log) throws XTriggerException {
    }

    @Deprecated
    protected String resolveEnvVars(String value, AbstractProject<?, ?> project, Node node) throws XTriggerException {
        Map envVars;
        try {
            envVars = EnvVarsResolver.getPollingEnvVars(project, (Node)node);
        }
        catch (EnvInjectException envInjectException) {
            throw new XTriggerException(envInjectException);
        }
        return Util.replaceMacro((String)value, (Map)envVars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Job project;
        try {
            project = (Job)this.job;
        }
        catch (Exception e) {
            return;
        }
        XTriggerDescriptor descriptor = this.getDescriptor();
        ExecutorService executorService = descriptor.getExecutor();
        XTriggerLog log = null;
        try {
            StreamTaskListener listener = new StreamTaskListener(this.getLogFile());
            log = new XTriggerLog((TaskListener)listener);
            if (Jenkins.get().isQuietingDown()) {
                log.info("Jenkins is quieting down.");
            } else if (!project.isBuildable()) {
                log.info("The job is not buildable. Activate it to poll again.");
            } else if (!this.unblockConcurrentBuild && project.isBuilding()) {
                log.info("The job is building. Waiting for next poll.");
            } else {
                Runner runner = new Runner(this.getName());
                executorService.execute(runner);
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "Severe error during the trigger execution " + t.getMessage());
            t.printStackTrace();
        }
        finally {
            if (log != null) {
                log.closeQuietly();
            }
        }
    }

    protected abstract String getName();

    public XTriggerDescriptor getDescriptor() {
        return (XTriggerDescriptor)Jenkins.get().getDescriptorOrDie(this.getClass());
    }

    private void reportError(XTriggerLog log, Throwable e) {
        Throwable cause;
        log.error("Polling error...");
        String message = e.getMessage();
        if (message != null) {
            log.error("Error message: " + message);
        }
        if ((cause = e.getCause()) != null) {
            log.error("Error cause: " + cause.getMessage());
        }
        LOGGER.log(Level.WARNING, "Polling failed", e);
    }

    protected Action[] getScheduledXTriggerActions(Node pollingNode, XTriggerLog log) throws XTriggerException {
        Action[] actions = this.getScheduledActions(pollingNode, log);
        int nbNewAction = actions.length + 1;
        Action[] newActions = new Action[nbNewAction];
        System.arraycopy(actions, 0, newActions, 0, actions.length);
        try {
            newActions[newActions.length - 1] = new XTriggerCauseAction(FileUtils.readFileToString((File)this.getLogFile()));
        }
        catch (IOException ioe) {
            throw new XTriggerException(ioe);
        }
        return newActions;
    }

    protected abstract Action[] getScheduledActions(Node var1, XTriggerLog var2);

    protected abstract boolean checkIfModified(Node var1, XTriggerLog var2) throws XTriggerException;

    protected boolean requirePollingNode() {
        return true;
    }

    protected boolean checkIfModified(XTriggerLog log) throws XTriggerException {
        return true;
    }

    protected abstract String getCause();

    protected XTriggerCause getBuildCause() {
        return new XTriggerCause(this.getName(), this.getCause(), true);
    }

    private Node getPollingNode(XTriggerLog log) {
        List<Node> nodes = this.getPollingNodesWithExecutors(log);
        if (nodes == null || nodes.size() == 0) {
            return null;
        }
        return nodes.get(0);
    }

    private void displayPollingNode(Node node, XTriggerLog log) {
        assert (node != null);
        String nodeName = node.getNodeName();
        if (nodeName == null || nodeName.trim().length() == 0) {
            log.info("\nPolling on master.");
        } else {
            log.info("\nPolling remotely on " + nodeName);
        }
    }

    private List<Node> getPollingNodesWithExecutors(XTriggerLog log) {
        ArrayList<Node> result = new ArrayList<Node>();
        List<Node> nodes = this.getPollingNodeList(log);
        for (Node node : nodes) {
            if (node != null && this.eligibleNode(node)) {
                result.add(node);
                continue;
            }
            if (node == null) continue;
            log.info(String.format("Finding %s but it is not eligible.", node.getDisplayName()));
        }
        return result;
    }

    private List<Node> getPollingNodeList(XTriggerLog log) {
        log.info("Looking nodes where the poll can be run.");
        List<Node> nodes = this.requiresWorkspaceForPolling() ? this.getPollingNodeListRequiredWS(log) : this.getPollingNodeListRequiredNoWS(log);
        if (nodes == null || nodes.size() == 0) {
            log.info("Can't find any eligible slave nodes.");
            log.info("Trying to poll on master node.");
            nodes = Collections.singletonList(this.getMasterNode());
        }
        return nodes;
    }

    private List<Node> getPollingNodeListRequiredNoWS(XTriggerLog log) {
        if (this.triggerLabel != null) {
            log.info(String.format("Looking for a node to the restricted label %s.", this.triggerLabel));
            if ("master".equalsIgnoreCase(this.triggerLabel)) {
                log.info("Restrict on master label. Polling on master.");
                return Collections.singletonList(this.getMasterNode());
            }
            Label targetLabel = Jenkins.get().getLabel(this.triggerLabel);
            if (targetLabel != null) {
                return this.getNodesLabel((BuildableItem)this.job, targetLabel);
            }
        }
        return this.candidatePollingNode(log);
    }

    private List<Node> getPollingNodeListRequiredWS(XTriggerLog log) {
        if (this.triggerLabel != null) {
            log.info(String.format("Looking for a polling node to the restricted label %s.", this.triggerLabel));
            if ("master".equalsIgnoreCase(this.triggerLabel)) {
                log.info("Polling on master.");
                return Collections.singletonList(this.getMasterNode());
            }
            Label targetLabel = Jenkins.get().getLabel(this.triggerLabel);
            if (targetLabel != null) {
                return this.getNodesLabel((BuildableItem)this.job, targetLabel);
            }
        }
        log.info("Looking for the last built on node.");
        if (this.job != null) {
            Node lastBuildOnNode = ((BuildableItem)this.job).getLastBuiltOn();
            if (lastBuildOnNode == null) {
                return this.getPollingNodeNoPreviousBuild(log);
            }
            return Collections.singletonList(lastBuildOnNode);
        }
        return this.getPollingNodeNoPreviousBuild(log);
    }

    private boolean eligibleNode(Node node) {
        if (node == null) {
            return false;
        }
        if (node.getRootPath() == null) {
            return false;
        }
        return node.getNumExecutors() != 0;
    }

    private List<Node> getPollingNodeNoPreviousBuild(XTriggerLog log) {
        Label targetLabel = this.getTargetLabel(log);
        if (targetLabel != null) {
            return this.getNodesLabel((BuildableItem)this.job, targetLabel);
        }
        return null;
    }

    private List<Node> candidatePollingNode(XTriggerLog log) {
        log.info("Looking for a candidate node to run the poll.");
        Label targetLabel = this.getTargetLabel(log);
        if (targetLabel != null) {
            return this.getNodesLabel((BuildableItem)this.job, targetLabel);
        }
        return Jenkins.get().getNodes();
    }

    private Label getTargetLabel(XTriggerLog log) {
        Label assignedLabel;
        if (this.job != null && (assignedLabel = ((BuildableItem)this.job).getAssignedLabel()) != null) {
            log.info(String.format("Trying to find an eligible node with the assigned project label %s.", assignedLabel));
            return assignedLabel;
        }
        return null;
    }

    private Node getMasterNode() {
        Computer computer = Jenkins.get().toComputer();
        if (computer != null) {
            return computer.getNode();
        }
        return null;
    }

    private List<Node> getNodesLabel(BuildableItem buildable, Label label) {
        ArrayList<Node> result = new ArrayList<Node>();
        ArrayList<Node> remainingNodes = new ArrayList<Node>();
        Set nodes = label.getNodes();
        for (Node node : nodes) {
            if (node == null) continue;
            if (!this.isAPreviousBuildNode(buildable)) {
                FilePath nodePath = node.getRootPath();
                if (nodePath == null) continue;
                result.add(node);
                continue;
            }
            FilePath nodeRootPath = node.getRootPath();
            if (nodeRootPath == null) continue;
            Node lastBuildOnNode = buildable.getLastBuiltOn();
            if (lastBuildOnNode != null && nodeRootPath.equals((Object)lastBuildOnNode.getRootPath())) {
                result.add(0, node);
                continue;
            }
            remainingNodes.add(node);
        }
        if (result.size() > 0) {
            return result;
        }
        return remainingNodes;
    }

    private boolean isAPreviousBuildNode(BuildableItem buildable) {
        Node lastBuildOnNode = buildable.getLastBuiltOn();
        return lastBuildOnNode != null;
    }

    private class Runner
    implements Runnable {
        private String triggerName;

        public Runner(String triggerName) {
            this.triggerName = triggerName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            XTriggerLog log = null;
            try {
                boolean changed;
                StreamTaskListener listener = new StreamTaskListener(AbstractTrigger.this.getLogFile());
                log = new XTriggerLog((TaskListener)listener);
                long start = System.currentTimeMillis();
                log.info("Polling started on " + DateFormat.getDateTimeInstance().format(new Date(start)));
                if (AbstractTrigger.this.job != null) {
                    log.info("Polling for the job " + ((BuildableItem)AbstractTrigger.this.job).getName());
                }
                if (AbstractTrigger.this.requirePollingNode()) {
                    Node pollingNode = AbstractTrigger.this.getPollingNode(log);
                    if (pollingNode == null) {
                        log.info("Can't find any complete active node for the polling action.");
                        log.info("Maybe slaves are not yet active at this time or the number of executor of the master is 0.");
                        log.info("Checking again in next polling schedule.");
                        return;
                    }
                    if (pollingNode.getRootPath() == null) {
                        log.info("The running slave might be offline at the moment.");
                        log.info("Waiting for next schedule.");
                        return;
                    }
                    AbstractTrigger.this.displayPollingNode(pollingNode, log);
                    changed = AbstractTrigger.this.checkIfModified(pollingNode, log);
                } else {
                    changed = AbstractTrigger.this.checkIfModified(log);
                }
                log.info("\nPolling complete. Took " + Util.getTimeSpanString((long)(System.currentTimeMillis() - start)) + ".");
                if (changed) {
                    log.info("Changes found. Scheduling a build.");
                    ArrayList<Action> actions = new ArrayList<Action>(Arrays.asList(AbstractTrigger.this.getScheduledXTriggerActions(null, log)));
                    actions.add((Action)new CauseAction((Cause)AbstractTrigger.this.getBuildCause()));
                    if (AbstractTrigger.this.job instanceof ParameterizedJobMixIn.ParameterizedJob) {
                        Action[] actionsArray = (Action[])Arrays.copyOf(actions.toArray(), actions.size(), Action[].class);
                        for (Job pjob : ((BuildableItem)AbstractTrigger.this.job).getAllJobs()) {
                            ParameterizedJobMixIn.scheduleBuild2((Job)pjob, (int)0, (Action[])actionsArray);
                        }
                    } else {
                        Queue.getInstance().schedule2((Queue.Task)AbstractTrigger.this.job, 0, actions);
                    }
                } else {
                    log.info("No changes.");
                }
            }
            catch (Throwable e) {
                AbstractTrigger.this.reportError(log, e);
            }
            finally {
                if (log != null) {
                    log.closeQuietly();
                }
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Runner runner = (Runner)o;
            return Objects.equals(this.triggerName, runner.triggerName);
        }

        public int hashCode() {
            return this.triggerName != null ? this.triggerName.hashCode() : 0;
        }
    }
}

