/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xtriggerapi;

import antlr.ANTLRException;
import hudson.model.BuildableItem;
import hudson.model.Node;
import org.jenkinsci.plugins.xtriggerapi.AbstractTrigger;
import org.jenkinsci.plugins.xtriggerapi.XTriggerContext;
import org.jenkinsci.plugins.xtriggerapi.XTriggerException;
import org.jenkinsci.plugins.xtriggerapi.XTriggerLog;

public abstract class AbstractTriggerByFullContext<C extends XTriggerContext>
extends AbstractTrigger {
    private transient C context;
    private final Object lock = new Object();

    public AbstractTriggerByFullContext(String cronTabSpec) throws ANTLRException {
        super(cronTabSpec);
    }

    protected AbstractTriggerByFullContext(String cronTabSpec, boolean unblockConcurrentBuild) throws ANTLRException {
        super(cronTabSpec, unblockConcurrentBuild);
    }

    protected AbstractTriggerByFullContext(String cronTabSpec, String triggerLabel) throws ANTLRException {
        super(cronTabSpec, triggerLabel);
    }

    protected AbstractTriggerByFullContext(String cronTabSpec, String triggerLabel, boolean unblockConcurrentBuild) throws ANTLRException {
        super(cronTabSpec, triggerLabel, unblockConcurrentBuild);
    }

    @Override
    protected void start(Node pollingNode, BuildableItem project, boolean newInstance, XTriggerLog log) throws XTriggerException {
        if (this.isContextOnStartupFetched()) {
            this.context = this.getContext(pollingNode, log);
        }
    }

    public abstract boolean isContextOnStartupFetched();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean checkIfModified(Node pollingNode, XTriggerLog log) throws XTriggerException {
        Object object = this.lock;
        synchronized (object) {
            C newContext = this.getContext(pollingNode, log);
            if (this.offlineSlaveOnStartup) {
                log.info("No nodes were available at startup or at previous poll.");
                log.info("Recording environment context and waiting for next schedule to check if there are modifications.");
                this.offlineSlaveOnStartup = false;
                this.setNewContext(newContext);
                return false;
            }
            if (this.context == null) {
                log.info("Recording context. Check changes in next poll.");
                this.setNewContext(newContext);
                return false;
            }
            boolean changed = this.checkIfModified(this.context, newContext, log);
            return changed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean checkIfModified(XTriggerLog log) throws XTriggerException {
        Object object = this.lock;
        synchronized (object) {
            C newContext = this.getContext(log);
            if (this.context == null) {
                log.info("Recording context. Check changes in next poll.");
                this.setNewContext(newContext);
                return false;
            }
            boolean changed = this.checkIfModified(this.context, newContext, log);
            return changed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setNewContext(C context) {
        Object object = this.lock;
        synchronized (object) {
            this.context = context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetOldContext(C oldContext) {
        Object object = this.lock;
        synchronized (object) {
            this.context = oldContext;
        }
    }

    protected C getContext(Node pollingNode, XTriggerLog log) throws XTriggerException {
        return null;
    }

    protected C getContext(XTriggerLog log) throws XTriggerException {
        return null;
    }

    protected abstract boolean checkIfModified(C var1, C var2, XTriggerLog var3) throws XTriggerException;
}

