/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xtriggerapi;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Util;
import hudson.console.AnnotatedLargeText;
import hudson.model.Action;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.jelly.XMLOutput;
import org.jenkinsci.plugins.xtriggerapi.XTriggerCause;

public class XTriggerCauseAction
implements Action {
    private static final String URL_NAME = "triggerCauseAction";
    private Run<?, ?> build;
    private transient String logMessage;

    public XTriggerCauseAction(String logMessage) {
        this.logMessage = logMessage;
    }

    public String getLogMessage() {
        return this.logMessage;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public Run<?, ?> getBuild() {
        return this.build;
    }

    public final String getUrlName() {
        return URL_NAME;
    }

    public void setBuild(Run<?, ?> build) {
        this.build = build;
    }

    public File getLogFile() {
        if (this.build == null) {
            return null;
        }
        return new File(this.build.getRootDir(), "triggerlog.xml");
    }

    public String getLog() throws IOException {
        File logFile = this.getLogFile();
        if (logFile == null) {
            return null;
        }
        return Util.loadFile((File)logFile);
    }

    public String getTitle() {
        if (this.build == null) {
            return "XTrigger Log";
        }
        XTriggerCause triggerCause = (XTriggerCause)this.build.getCause(XTriggerCause.class);
        if (triggerCause == null) {
            return "XTrigger Log";
        }
        return triggerCause.getTriggerName() + " Log";
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"})
    public void writeLogTo(XMLOutput out) throws IOException {
        new AnnotatedLargeText(this.getLogFile(), Charset.defaultCharset(), true, (Object)this).writeHtmlTo(0L, out.asWriter());
    }
}

