/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.xshell;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.plugins.xshell.Messages;
import hudson.plugins.xshell.XShellDescriptor;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kohsuke.stapler.DataBoundConstructor;

public final class XShellBuilder
extends Builder {
    private static final Logger LOG = Logger.getLogger(XShellBuilder.class.getName());
    private static final Pattern WIN_ENV_VAR_REGEX = Pattern.compile("%([a-zA-Z0-9_]+)%");
    private static final Pattern UNIX_ENV_VAR_REGEX = Pattern.compile("\\$([a-zA-Z0-9_]+)");
    public static final String UNIX_SEP = "/";
    public static final String WINDOWS_SEP = "\\";
    @Extension
    public static final XShellDescriptor DESCRIPTOR = new XShellDescriptor();
    private final String commandLine;
    private final String workingDir;
    private final Boolean executeFromWorkingDir;
    private final String regexToKill;
    private final String timeAllocated;

    public String getCommandLine() {
        return this.commandLine;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public Boolean getExecuteFromWorkingDir() {
        return this.executeFromWorkingDir;
    }

    public String getRegexToKill() {
        return this.regexToKill;
    }

    public String getTimeAllocated() {
        return this.timeAllocated;
    }

    @DataBoundConstructor
    public XShellBuilder(String commandLine, String workingDir, Boolean executeFromWorkingDir, String regexToKill, String timeAllocated) {
        this.commandLine = Util.fixEmptyAndTrim((String)commandLine);
        this.workingDir = workingDir;
        this.executeFromWorkingDir = executeFromWorkingDir;
        this.regexToKill = regexToKill == null ? "" : regexToKill;
        this.timeAllocated = timeAllocated;
    }

    public Descriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        Long timeAllowed;
        String nonNullWorkingDir;
        LOG.log(Level.FINE, "Unmodified command line: " + this.commandLine);
        LOG.log(Level.FINE, "Regex to kill: " + this.regexToKill);
        LOG.log(Level.FINE, "Time allocated before kill: " + this.timeAllocated);
        EnvVars env = build.getEnvironment((TaskListener)listener);
        String cmdLine = XShellBuilder.convertSeparator(this.commandLine, launcher.isUnix() ? UNIX_SEP : WINDOWS_SEP);
        LOG.log(Level.FINE, "File separators sanitized: " + cmdLine);
        cmdLine = env.expand(cmdLine);
        LOG.log(Level.FINE, "Expanded build environment vars: " + cmdLine);
        cmdLine = launcher.isUnix() ? XShellBuilder.convertEnvVarsToUnix(cmdLine) : XShellBuilder.convertEnvVarsToWindows(cmdLine);
        LOG.log(Level.FINE, "Environment variables sanitized: " + cmdLine);
        ArgumentListBuilder args = new ArgumentListBuilder();
        if (cmdLine != null) {
            args.addTokenized((String)(launcher.isUnix() && this.executeFromWorkingDir != false ? "./" + cmdLine : cmdLine));
            LOG.log(Level.FINE, "Execute from working directory: " + args.toStringWithQuote());
        }
        if (!launcher.isUnix()) {
            args = args.toWindowsCommand();
            LOG.log(Level.FINE, "Windows command: " + args.toStringWithQuote());
        }
        env.putAll(build.getBuildVariables());
        String string = nonNullWorkingDir = this.workingDir != null ? this.workingDir : ".";
        Object absWorkingDir = new File(nonNullWorkingDir).isAbsolute() ? nonNullWorkingDir : String.valueOf(build.getWorkspace()) + (launcher.isUnix() ? UNIX_SEP : WINDOWS_SEP) + nonNullWorkingDir;
        LOG.log(Level.FINEST, "Environment variables: " + env.entrySet().toString());
        LOG.log(Level.FINE, "Command line: " + args.toStringWithQuote());
        LOG.log(Level.FINE, "Working directory: " + (String)absWorkingDir);
        Pattern r = Pattern.compile(this.regexToKill == null ? "" : this.regexToKill);
        try {
            timeAllowed = Long.parseLong(this.timeAllocated);
        }
        catch (Exception e) {
            timeAllowed = 0L;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamBuildListener sbl = new StreamBuildListener((OutputStream)baos);
            Proc child = launcher.decorateFor(build.getBuiltOn()).launch().cmds(args).envs((Map)env).stdout((TaskListener)sbl).pwd((String)absWorkingDir).start();
            Long startTime = System.currentTimeMillis();
            try {
                while (child.isAlive()) {
                    baos.flush();
                    String s = baos.toString();
                    baos.reset();
                    listener.getLogger().print(s);
                    listener.getLogger().flush();
                    if (this.regexToKill != null && this.regexToKill.length() > 0 && r.matcher(s).find()) {
                        LOG.log(Level.FINEST, "Matched failure in log");
                        child.kill();
                        listener.getLogger().println("Matched <" + this.regexToKill + "> in output. Terminated");
                        continue;
                    }
                    if (timeAllowed > 0L && (System.currentTimeMillis() - startTime) / 1000L > timeAllowed) {
                        LOG.log(Level.FINEST, "Timed out");
                        child.kill();
                        listener.getLogger().println("Timed out <" + this.timeAllocated + ">. Terminated");
                        continue;
                    }
                    Thread.sleep(2L);
                }
            }
            catch (InterruptedException intEx) {
                LOG.log(Level.FINEST, "Aborted by user");
                child.kill();
                listener.getLogger().println("Aborted by User. Terminated");
                throw new InterruptedException("User Aborted");
            }
            baos.flush();
            listener.getLogger().print(baos.toString());
            listener.getLogger().flush();
            return child.join() == 0;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            String errorMessage = Messages.XShell_ExecFailed();
            e.printStackTrace(listener.fatalError(errorMessage));
            return false;
        }
    }

    public static String convertSeparator(String cmdLine, String newSeparator) {
        String match = "[/" + Pattern.quote(WINDOWS_SEP) + "]";
        String replacement = Matcher.quoteReplacement(newSeparator);
        Pattern words = Pattern.compile("\\S+");
        Pattern urls = Pattern.compile("(https*|ftp|git):");
        StringBuffer sb = new StringBuffer();
        Matcher m = words.matcher(cmdLine);
        while (m.find()) {
            String item = m.group();
            if (urls.matcher(item).find()) continue;
            m.appendReplacement(sb, Matcher.quoteReplacement(item.replaceAll(match, replacement)));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String convertEnvVarsToUnix(String cmdLine) {
        if (cmdLine == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Matcher m = WIN_ENV_VAR_REGEX.matcher(cmdLine);
        while (m.find()) {
            m.appendReplacement(sb, "\\$$1");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String convertEnvVarsToWindows(String cmdLine) {
        if (cmdLine == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Matcher m = UNIX_ENV_VAR_REGEX.matcher(cmdLine);
        while (m.find()) {
            m.appendReplacement(sb, "%$1%");
        }
        m.appendTail(sb);
        return sb.toString();
    }
}

