// CHECKSTYLE:OFF

package hudson.plugins.ws_cleanup;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code WsCleanup.Delete_workspace}: {@code Delete workspace when
     * build is done}.
     * 
     * @return
     *     {@code Delete workspace when build is done}
     */
    public static String WsCleanup_Delete_workspace() {
        return holder.format("WsCleanup.Delete_workspace");
    }

    /**
     * Key {@code WsCleanup.Delete_workspace}: {@code Delete workspace when
     * build is done}.
     * 
     * @return
     *     {@code Delete workspace when build is done}
     */
    public static Localizable _WsCleanup_Delete_workspace() {
        return new Localizable(holder, "WsCleanup.Delete_workspace");
    }

    /**
     * Key {@code PreBuildCleanup.Delete_workspace}: {@code Delete workspace
     * before build starts}.
     * 
     * @return
     *     {@code Delete workspace before build starts}
     */
    public static String PreBuildCleanup_Delete_workspace() {
        return holder.format("PreBuildCleanup.Delete_workspace");
    }

    /**
     * Key {@code PreBuildCleanup.Delete_workspace}: {@code Delete workspace
     * before build starts}.
     * 
     * @return
     *     {@code Delete workspace before build starts}
     */
    public static Localizable _PreBuildCleanup_Delete_workspace() {
        return new Localizable(holder, "PreBuildCleanup.Delete_workspace");
    }

    /**
     * Key {@code DisableDeferredWipeoutNodeProperty.Name}: {@code Disable
     * deferred wipeout on this node}.
     * 
     * @return
     *     {@code Disable deferred wipeout on this node}
     */
    public static String DisableDeferredWipeoutNodeProperty_Name() {
        return holder.format("DisableDeferredWipeoutNodeProperty.Name");
    }

    /**
     * Key {@code DisableDeferredWipeoutNodeProperty.Name}: {@code Disable
     * deferred wipeout on this node}.
     * 
     * @return
     *     {@code Disable deferred wipeout on this node}
     */
    public static Localizable _DisableDeferredWipeoutNodeProperty_Name() {
        return new Localizable(holder, "DisableDeferredWipeoutNodeProperty.Name");
    }

}
