/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ws_cleanup;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.model.BuildListener;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.ws_cleanup.Cleanup;
import hudson.plugins.ws_cleanup.Pattern;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WsCleanupMatrixAggregator
extends MatrixAggregator {
    private final List<Pattern> patterns;
    private final boolean deleteDirs;
    private final boolean notFailBuild;
    private final boolean cleanWhenSuccess;
    private final boolean cleanWhenUnstable;
    private final boolean cleanWhenFailure;
    private final boolean cleanWhenNotBuilt;
    private final boolean cleanWhenAborted;
    private final String externalDelete;

    public WsCleanupMatrixAggregator(MatrixBuild build, Launcher launcher, BuildListener listener, List<Pattern> patterns, boolean deleteDirs, boolean cleanWhenSuccess, boolean cleanWhenUnstable, boolean cleanWhenFailure, boolean cleanWhenNotBuilt, boolean cleanWhenAborted, boolean notFailBuild, String externalDelete) {
        super(build, launcher, listener);
        this.patterns = patterns;
        this.deleteDirs = deleteDirs;
        this.cleanWhenSuccess = cleanWhenSuccess;
        this.cleanWhenUnstable = cleanWhenUnstable;
        this.cleanWhenFailure = cleanWhenFailure;
        this.cleanWhenNotBuilt = cleanWhenNotBuilt;
        this.cleanWhenAborted = cleanWhenAborted;
        this.notFailBuild = notFailBuild;
        this.externalDelete = externalDelete;
    }

    public boolean endBuild() throws InterruptedException, IOException {
        return this.doWorkspaceCleanup();
    }

    private boolean shouldCleanBuildBasedOnState(@CheckForNull Result result) {
        if (result == null) {
            return true;
        }
        if (result.equals(Result.SUCCESS)) {
            return this.cleanWhenSuccess;
        }
        if (result.equals(Result.UNSTABLE)) {
            return this.cleanWhenUnstable;
        }
        if (result.equals(Result.FAILURE)) {
            return this.cleanWhenFailure;
        }
        if (result.equals(Result.NOT_BUILT)) {
            return this.cleanWhenNotBuilt;
        }
        if (result.equals(Result.ABORTED)) {
            return this.cleanWhenAborted;
        }
        return true;
    }

    private boolean doWorkspaceCleanup() throws IOException, InterruptedException {
        this.listener.getLogger().println("Deleting matrix project workspace...");
        FilePath workspace = this.build.getWorkspace();
        try {
            if (workspace == null || !workspace.exists()) {
                return true;
            }
            if (!this.shouldCleanBuildBasedOnState(this.build.getResult())) {
                this.listener.getLogger().println("Skipped based on build state " + String.valueOf(this.build.getResult()) + "\n");
                return true;
            }
            if (this.patterns == null || this.patterns.isEmpty()) {
                workspace.deleteRecursive();
            } else {
                Node node = this.build.getBuiltOn();
                if (node != null) {
                    workspace.act((FilePath.FileCallable)new Cleanup(this.patterns, this.deleteDirs, (EnvironmentVariablesNodeProperty)node.getNodeProperties().get(EnvironmentVariablesNodeProperty.class), this.externalDelete, (TaskListener)this.listener));
                }
            }
            this.listener.getLogger().append("done\n\n");
        }
        catch (Exception ex) {
            Logger.getLogger(WsCleanupMatrixAggregator.class.getName()).log(Level.SEVERE, null, ex);
            if (this.notFailBuild) {
                this.listener.getLogger().println("Cannot delete workspace: " + String.valueOf(ex.getCause()));
                this.listener.getLogger().println("Option not to fail the build is turned on, so let's continue");
                return true;
            }
            return false;
        }
        return true;
    }
}

