/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.BodyInvoker;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;

public class StepExecutions {
    public static StepExecution synchronous(StepContext context, SynchronousBody body) {
        return new SynchronousImpl(context, body);
    }

    public static StepExecution synchronousVoid(StepContext context, SynchronousBodyVoid body) {
        return new SynchronousImpl(context, body.asReturn());
    }

    public static StepExecution synchronousNonBlocking(StepContext context, SynchronousBody body) {
        return new SynchronousNonBlockingImpl(context, body);
    }

    public static StepExecution synchronousNonBlockingVoid(StepContext context, SynchronousBodyVoid body) {
        return new SynchronousNonBlockingImpl(context, body.asReturn());
    }

    public static StepExecution block(StepContext context, BlockBody body) {
        return new BlockImpl(context, body);
    }

    private StepExecutions() {
    }

    private static class SynchronousImpl
    extends SynchronousStepExecution<Object> {
        private static final long serialVersionUID = 1L;
        private final transient SynchronousBody body;

        SynchronousImpl(StepContext context, SynchronousBody body) {
            super(context);
            this.body = body;
        }

        @Override
        protected Object run() throws Exception {
            return this.body.call(this.getContext());
        }
    }

    @FunctionalInterface
    public static interface SynchronousBody {
        public Object call(StepContext var1) throws Exception;
    }

    @FunctionalInterface
    public static interface SynchronousBodyVoid {
        public void call(StepContext var1) throws Exception;

        default public SynchronousBody asReturn() {
            return c -> {
                this.call(c);
                return null;
            };
        }
    }

    private static class SynchronousNonBlockingImpl
    extends SynchronousNonBlockingStepExecution<Object> {
        private static final long serialVersionUID = 1L;
        private final transient SynchronousBody body;

        SynchronousNonBlockingImpl(StepContext context, SynchronousBody body) {
            super(context);
            this.body = body;
        }

        @Override
        protected Object run() throws Exception {
            return this.body.call(this.getContext());
        }
    }

    private static class BlockImpl
    extends StepExecution {
        private static final long serialVersionUID = 1L;
        private final transient BlockBody body;

        BlockImpl(StepContext context, BlockBody body) {
            super(context);
            this.body = body;
        }

        @Override
        public boolean start() throws Exception {
            StepContext context = this.getContext();
            BodyInvoker invoker = context.newBodyInvoker();
            this.body.call(context, invoker);
            invoker.withCallback(BodyExecutionCallback.wrap(context)).start();
            return false;
        }
    }

    @FunctionalInterface
    public static interface BlockBody {
        public void call(StepContext var1, BodyInvoker var2) throws Exception;
    }
}

