/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.util.Timer;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecutionIterator;

public abstract class StepExecution
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(StepExecution.class.getName());
    @Inject
    private StepContext context;
    private static final long serialVersionUID = 1L;

    @Deprecated
    protected StepExecution() {
    }

    protected StepExecution(@NonNull StepContext context) {
        this.context = context;
    }

    @NonNull
    public StepContext getContext() {
        if (this.context == null) {
            throw new IllegalStateException("you must either pass in a StepContext to the StepExecution constructor, or have the StepExecution be created automatically");
        }
        return this.context;
    }

    public abstract boolean start() throws Exception;

    public void stop(@NonNull Throwable cause) throws Exception {
        this.getContext().onFailure(cause);
    }

    public void onResume() {
    }

    @CheckForNull
    public String getStatus() {
        return null;
    }

    public boolean blocksRestart() {
        return false;
    }

    @CheckForNull
    public final String getStatusBounded(long timeout, TimeUnit unit) {
        Future<String> task = null;
        try {
            task = Timer.get().submit(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return StepExecution.this.getStatus();
                }
            });
            return task.get(timeout, unit);
        }
        catch (Exception x) {
            if (task != null) {
                task.cancel(true);
            }
            LOGGER.log(Level.FINE, "failed to check status of " + super.toString(), x);
            return x.toString();
        }
    }

    public static ListenableFuture<?> acceptAll(Consumer<StepExecution> c) {
        ArrayList futures = new ArrayList();
        for (StepExecutionIterator i : StepExecutionIterator.all()) {
            futures.add(i.accept(c));
        }
        return Futures.allAsList(futures);
    }

    @Deprecated
    public static ListenableFuture<?> applyAll(Function<StepExecution, Void> f) {
        return StepExecution.acceptAll(StepExecution.fromGuava(f));
    }

    public static <T extends StepExecution> ListenableFuture<?> acceptAll(Class<T> type, Consumer<T> c) {
        return StepExecution.acceptAll(e -> {
            if (type.isInstance(e)) {
                c.accept((StepExecution)type.cast(e));
            }
        });
    }

    @Deprecated
    public static <T extends StepExecution> ListenableFuture<?> applyAll(Class<T> type, Function<T, Void> f) {
        return StepExecution.acceptAll(type, StepExecution.fromGuava(f));
    }

    private static <T> Consumer<T> fromGuava(Function<T, Void> func) {
        return arg_0 -> func.apply(arg_0);
    }
}

