/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.ExtensionList;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepEnvironmentContributor;

public abstract class EnvironmentExpander
implements Serializable {
    public abstract void expand(@NonNull EnvVars var1) throws IOException, InterruptedException;

    @NonNull
    public Set<String> getSensitiveVariables() {
        return Collections.emptySet();
    }

    public static EnvironmentExpander constant(@NonNull Map<String, String> env) {
        return new ConstantEnvironmentExpander(env);
    }

    public static EnvironmentExpander merge(@CheckForNull EnvironmentExpander original, @NonNull EnvironmentExpander subsequent) {
        if (original == null) {
            return subsequent;
        }
        return new MergedEnvironmentExpander(original, subsequent);
    }

    @Deprecated
    @NonNull
    public static EnvVars getEffectiveEnvironment(@NonNull EnvVars customEnvironment, @CheckForNull EnvVars contextualEnvironment, @CheckForNull EnvironmentExpander expander) throws IOException, InterruptedException {
        return EnvironmentExpander.getEffectiveEnvironment(customEnvironment, contextualEnvironment, expander, null, TaskListener.NULL);
    }

    @NonNull
    public static EnvVars getEffectiveEnvironment(@NonNull EnvVars customEnvironment, @CheckForNull EnvVars contextualEnvironment, @CheckForNull EnvironmentExpander expander, @CheckForNull StepContext stepContext, @NonNull TaskListener listener) throws IOException, InterruptedException {
        EnvVars env;
        if (contextualEnvironment != null) {
            env = new EnvVars(contextualEnvironment);
            env.putAll((Map)customEnvironment);
        } else {
            env = new EnvVars(customEnvironment);
        }
        if (expander != null) {
            expander.expand(env);
        }
        if (stepContext != null) {
            for (StepEnvironmentContributor contributor : ExtensionList.lookup(StepEnvironmentContributor.class).reverseView()) {
                contributor.buildEnvironmentFor(stepContext, env, listener);
            }
        }
        return env;
    }

    private static class ConstantEnvironmentExpander
    extends EnvironmentExpander {
        private static final long serialVersionUID = 1L;
        private final Map<String, String> envMap = new HashMap<String, String>();

        ConstantEnvironmentExpander(@NonNull Map<String, String> envMap) {
            this.envMap.putAll(envMap);
        }

        @Override
        public void expand(EnvVars env) throws IOException, InterruptedException {
            env.overrideAll(this.envMap);
        }
    }

    private static class MergedEnvironmentExpander
    extends EnvironmentExpander {
        private static final long serialVersionUID = 1L;
        @NonNull
        private final EnvironmentExpander original;
        @NonNull
        private final EnvironmentExpander subsequent;

        MergedEnvironmentExpander(EnvironmentExpander original, EnvironmentExpander subsequent) {
            this.original = original;
            this.subsequent = subsequent;
        }

        @Override
        public void expand(EnvVars env) throws IOException, InterruptedException {
            this.original.expand(env);
            this.subsequent.expand(env);
        }

        @Override
        public Set<String> getSensitiveVariables() {
            Set<String> originalSensitive = this.original.getSensitiveVariables();
            Set<String> subsequentSensitive = this.subsequent.getSensitiveVariables();
            if (originalSensitive.isEmpty() && subsequentSensitive.isEmpty()) {
                return Collections.emptySet();
            }
            HashSet<String> mergedWatch = new HashSet<String>();
            mergedWatch.addAll(originalSensitive);
            mergedWatch.addAll(subsequentSensitive);
            return mergedWatch;
        }
    }
}

