/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsStepContext;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.GeneralNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.test.steps.SemaphoreStep;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.BuildWatcher;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.LoggerRule;
import org.jvnet.hudson.test.TestExtension;
import org.kohsuke.stapler.DataBoundConstructor;

public class GeneralNonBlockingStepExecutionTest {
    @ClassRule
    public static BuildWatcher buildWatcher = new BuildWatcher();
    @Rule
    public JenkinsRule r = new JenkinsRule();
    @Rule
    public LoggerRule logging = new LoggerRule();
    private static Semaphore startEnter;
    private static Semaphore startExit;
    private static Semaphore endEnter;
    private static Semaphore endExit;

    @Test
    public void getStatus() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("slowBlock {semaphore 'wait'}", true));
        WorkflowRun b = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
        startEnter.acquire();
        MatcherAssert.assertThat((Object)((CpsFlowExecution)b.getExecution()).getThreadDump().toString(), (Matcher)Matchers.containsString((String)"at DSL.slowBlock(running in thread: org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution [#"));
        Thread.sleep(250L);
        Assert.assertTrue((boolean)b.getExecutor().getAsynchronousExecution().blocksRestart());
        startExit.release();
        SemaphoreStep.waitForStart((String)"wait/1", (Run)b);
        MatcherAssert.assertThat((Object)((CpsFlowExecution)b.getExecution()).getThreadDump().toString(), (Matcher)Matchers.containsString((String)"at DSL.slowBlock(not currently scheduled, or running blocks)"));
        while (b.getExecutor().getAsynchronousExecution().blocksRestart()) {
            Thread.sleep(100L);
        }
        SemaphoreStep.success((String)"wait/1", null);
        endEnter.acquire();
        MatcherAssert.assertThat((Object)((CpsFlowExecution)b.getExecution()).getThreadDump().toString(), (Matcher)Matchers.containsString((String)"at DSL.slowBlock(running in thread: org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution [#"));
        Thread.sleep(250L);
        Assert.assertTrue((boolean)b.getExecutor().getAsynchronousExecution().blocksRestart());
        endExit.release();
        this.r.assertBuildStatusSuccess((Run)((WorkflowRun)this.r.waitForCompletion((Run)b)));
    }

    @Test
    public void stop() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("slowBlock {semaphore 'wait'}", true));
        this.logging.record(CpsStepContext.class, Level.WARNING).capture(100);
        WorkflowRun b = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
        startEnter.acquire();
        b.getExecutor().interrupt();
        this.r.assertBuildStatus(Result.ABORTED, (Run)((WorkflowRun)this.r.waitForCompletion((Run)b)));
        startExit.release();
        b = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
        startEnter.acquire();
        startExit.release();
        SemaphoreStep.waitForStart((String)"wait/1", (Run)b);
        b.getExecutor().interrupt();
        endEnter.acquire();
        endExit.release();
        this.r.assertBuildStatus(Result.ABORTED, (Run)((WorkflowRun)this.r.waitForCompletion((Run)b)));
        SemaphoreStep.success((String)"wait/1", null);
        b = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
        startEnter.acquire();
        startExit.release();
        SemaphoreStep.waitForStart((String)"wait/2", (Run)b);
        SemaphoreStep.success((String)"wait/2", null);
        endEnter.acquire();
        b.getExecutor().interrupt();
        this.r.assertBuildStatus(Result.ABORTED, (Run)((WorkflowRun)this.r.waitForCompletion((Run)b)));
        endExit.release();
        MatcherAssert.assertThat((Object)this.logging.getRecords(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldNotHang() throws Exception {
        int iterations = 50;
        startExit.release(iterations);
        endExit.release(iterations);
        WorkflowJob p = (WorkflowJob)this.r.createProject(WorkflowJob.class);
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("for (int i = 0; i < " + iterations + "; i++) {\n  slowBlock {\n    echo(/At $i/)\n  }\n}", true));
        this.r.buildAndAssertSuccess((Job)p);
    }

    @Before
    public void semaphores() {
        startEnter = new Semaphore(0);
        startExit = new Semaphore(0);
        endEnter = new Semaphore(0);
        endExit = new Semaphore(0);
    }

    public static final class SlowBlockStep
    extends Step {
        @DataBoundConstructor
        public SlowBlockStep() {
        }

        public StepExecution start(StepContext context) {
            return new Execution(context, this);
        }

        private static final class Execution
        extends GeneralNonBlockingStepExecution {
            private final transient SlowBlockStep step;

            Execution(StepContext context, SlowBlockStep step) {
                super(context);
                this.step = step;
            }

            private void println(String msg) throws Exception {
                ((TaskListener)this.getContext().get(TaskListener.class)).getLogger().println(msg);
            }

            public boolean start() throws Exception {
                this.println("starting step");
                this.run(this::doStart);
                return false;
            }

            private void doStart() throws Exception {
                this.println("starting background part of step");
                startEnter.release();
                startExit.acquire();
                this.println("starting body");
                this.getContext().newBodyInvoker().withCallback((BodyExecutionCallback)new Callback()).start();
            }

            private final class Callback
            extends GeneralNonBlockingStepExecution.TailCall {
                private Callback() {
                    super((GeneralNonBlockingStepExecution)Execution.this);
                }

                protected void finished(StepContext context) throws Exception {
                    Execution.this.println("body completed, starting background end part of step");
                    endEnter.release();
                    endExit.acquire();
                    Execution.this.println("ending step");
                }
            }
        }

        @TestExtension
        public static final class DescriptorImpl
        extends StepDescriptor {
            public String getFunctionName() {
                return "slowBlock";
            }

            public Set<? extends Class<?>> getRequiredContext() {
                return Collections.singleton(TaskListener.class);
            }

            public boolean takesImplicitBlockArgument() {
                return true;
            }
        }
    }
}

