/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import hudson.model.Result;
import hudson.model.Run;
import jenkins.model.CauseOfInterruption;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.workflow.job.properties.DisableConcurrentBuildsJobProperty;
import org.jenkinsci.plugins.workflow.steps.ExceptionCause;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.junit.Test;
import org.mockito.Mockito;

public class FlowInterruptedExceptionTest {
    @Test
    public void getMessageReturnsCauses() {
        Result result = Result.ABORTED;
        ExceptionCause cause1 = new ExceptionCause((Throwable)new IllegalStateException("something went wrong"));
        CauseOfInterruption.UserInterruption cause2 = new CauseOfInterruption.UserInterruption("admin");
        CauseOfInterruption[] causes = new CauseOfInterruption[]{cause1, cause2};
        FlowInterruptedException exception = new FlowInterruptedException(result, true, causes);
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.equalTo((Object)(cause1.getShortDescription() + ", " + cause2.getShortDescription())));
    }

    @Test
    public void toStringContainsCauses() {
        Result result = Result.FAILURE;
        Run run = (Run)Mockito.mock(Run.class);
        Mockito.when((Object)run.getDisplayName()).thenReturn((Object)"fracture.account");
        DisableConcurrentBuildsJobProperty.CancelledCause cause = new DisableConcurrentBuildsJobProperty.CancelledCause(run);
        FlowInterruptedException exception = new FlowInterruptedException(result, true, new CauseOfInterruption[]{cause});
        MatcherAssert.assertThat((Object)exception.toString(), (Matcher)Matchers.containsString((String)cause.getShortDescription()));
    }
}

