/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps.scm;

import hudson.AbortException;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.Set;
import jenkins.scm.api.SCMFileSystem;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public final class ReadScmFileStep
extends Step {
    private final SCMSource scm;
    private final String version;
    private final String path;

    @DataBoundConstructor
    public ReadScmFileStep(SCMSource scm, String version, String path) {
        this.scm = scm;
        this.version = version;
        this.path = path;
    }

    public SCMSource getScm() {
        return this.scm;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPath() {
        return this.path;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    private static final class Execution
    extends SynchronousNonBlockingStepExecution<String> {
        private static final long serialVersionUID = 1L;
        private final transient ReadScmFileStep step;

        Execution(ReadScmFileStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        protected String run() throws Exception {
            SCMRevision rev = this.step.scm.fetch(this.step.version, (TaskListener)this.getContext().get(TaskListener.class), (Item)((Run)this.getContext().get(Run.class)).getParent());
            if (rev == null) {
                throw new AbortException("No such revision");
            }
            SCMFileSystem fs = SCMFileSystem.of((SCMSource)this.step.scm, (SCMHead)rev.getHead(), (SCMRevision)rev);
            if (fs == null) {
                throw new AbortException("Unsupported SCM");
            }
            return fs.child(this.step.path).contentAsString();
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "readScmFile";
        }

        public String getDisplayName() {
            return "Read file from SCM";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Set.of(Run.class, TaskListener.class);
        }
    }
}

