/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.multibranch;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.AbstractItem;
import hudson.model.Action;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.listeners.ItemListener;
import hudson.plugins.git.GitSCM;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import jenkins.branch.BranchProjectFactory;
import jenkins.branch.BranchProperty;
import jenkins.branch.BranchPropertyDescriptor;
import jenkins.branch.BranchPropertyStrategy;
import jenkins.branch.BranchPropertyStrategyDescriptor;
import jenkins.branch.BranchSource;
import jenkins.branch.BuildRetentionBranchProperty;
import jenkins.branch.DefaultBranchPropertyStrategy;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.NamedExceptionsBranchPropertyStrategy;
import jenkins.branch.NoTriggerBranchProperty;
import jenkins.branch.RateLimitBranchProperty;
import jenkins.branch.UntrustedBranchProperty;
import jenkins.plugins.git.GitBranchSCMHead;
import jenkins.plugins.git.GitSCMSource;
import jenkins.plugins.git.GitSampleRepoRule;
import jenkins.plugins.git.traits.BranchDiscoveryTrait;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.impl.SingleSCMSource;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.multibranch.DurabilityHintBranchProperty;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowBranchProjectFactory;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.BuildWatcher;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.TestExtension;

public class WorkflowMultiBranchProjectTest {
    @ClassRule
    public static BuildWatcher buildWatcher = new BuildWatcher();
    @Rule
    public JenkinsRule r = new JenkinsRule();
    @Rule
    public GitSampleRepoRule sampleRepo = new GitSampleRepoRule();

    @Test
    public void basicBranches() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("Jenkinsfile", "echo \"branch=${env.BRANCH_NAME}\"; node {checkout scm; echo readFile('file')}");
        this.sampleRepo.write("file", "initial content");
        this.sampleRepo.git(new String[]{"add", "Jenkinsfile"});
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=flow"});
        WorkflowMultiBranchProject mp = (WorkflowMultiBranchProject)this.r.jenkins.createProject(WorkflowMultiBranchProject.class, "p");
        mp.getSourcesList().add((Object)new BranchSource((SCMSource)new GitSCMSource(null, this.sampleRepo.toString(), "", "*", "", false), (BranchPropertyStrategy)new DefaultBranchPropertyStrategy(new BranchProperty[0])));
        for (SCMSource source : mp.getSCMSources()) {
            Assert.assertEquals((Object)mp, (Object)source.getOwner());
        }
        WorkflowJob p = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(mp, "master");
        Assert.assertEquals((Object)new GitBranchSCMHead("master"), (Object)SCMHead.HeadByItem.findHead((Item)p));
        Assert.assertEquals((long)1L, (long)mp.getItems().size());
        this.r.waitUntilNoActivity();
        WorkflowRun b1 = p.getLastBuild();
        Assert.assertEquals((long)1L, (long)b1.getNumber());
        this.r.assertLogContains("initial content", (Run)b1);
        this.r.assertLogContains("branch=master", (Run)b1);
        this.sampleRepo.git(new String[]{"checkout", "-b", "feature"});
        this.sampleRepo.write("Jenkinsfile", "echo \"branch=${env.BRANCH_NAME}\"; node {checkout scm; echo readFile('file').toUpperCase()}");
        this.sampleRepo.write("file", "subsequent content");
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=tweaked"});
        p = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(mp, "feature");
        Assert.assertEquals((long)2L, (long)mp.getItems().size());
        this.r.waitUntilNoActivity();
        b1 = p.getLastBuild();
        Assert.assertEquals((long)1L, (long)b1.getNumber());
        this.r.assertLogContains("SUBSEQUENT CONTENT", (Run)b1);
        this.r.assertLogContains("branch=feature", (Run)b1);
    }

    @NonNull
    public static WorkflowJob scheduleAndFindBranchProject(@NonNull WorkflowMultiBranchProject mp, @NonNull String name) throws Exception {
        mp.scheduleBuild2(0, new Action[0]).getFuture().get();
        return WorkflowMultiBranchProjectTest.findBranchProject(mp, name);
    }

    @NonNull
    public static WorkflowJob findBranchProject(@NonNull WorkflowMultiBranchProject mp, @NonNull String name) throws Exception {
        WorkflowJob p = (WorkflowJob)mp.getItem(name);
        WorkflowMultiBranchProjectTest.showIndexing(mp);
        if (p == null) {
            Assert.fail((String)(name + " project not found"));
        }
        return p;
    }

    static void showIndexing(@NonNull WorkflowMultiBranchProject mp) throws Exception {
        MultiBranchProject.BranchIndexing indexing = mp.getIndexing();
        System.out.println("---%<--- " + indexing.getUrl());
        indexing.writeWholeLogTo((OutputStream)System.out);
        System.out.println("---%<--- ");
    }

    @Test
    public void visibleBranchProperties() throws Exception {
        WorkflowMultiBranchProject p = (WorkflowMultiBranchProject)this.r.jenkins.createProject(WorkflowMultiBranchProject.class, "p");
        HashSet<Class> propertyTypes = new HashSet<Class>();
        for (BranchPropertyDescriptor d : DescriptorVisibilityFilter.apply((Object)p, (Iterable)BranchPropertyDescriptor.all())) {
            propertyTypes.add(d.clazz);
        }
        Assert.assertTrue((boolean)propertyTypes.contains(NoTriggerBranchProperty.class));
        Assert.assertTrue((boolean)propertyTypes.contains(DurabilityHintBranchProperty.class));
        Assert.assertFalse((boolean)propertyTypes.contains(BuildRetentionBranchProperty.class));
        Assert.assertFalse((boolean)propertyTypes.contains(RateLimitBranchProperty.class));
        Assert.assertFalse((boolean)propertyTypes.contains(UntrustedBranchProperty.class));
        HashSet<Class> strategyTypes = new HashSet<Class>();
        for (BranchPropertyStrategyDescriptor d : ((BranchSource.DescriptorImpl)this.r.jenkins.getDescriptorByType(BranchSource.DescriptorImpl.class)).propertyStrategyDescriptors((MultiBranchProject)p, (SCMSourceDescriptor)this.r.jenkins.getDescriptorByType(SingleSCMSource.DescriptorImpl.class))) {
            strategyTypes.add(d.clazz);
        }
        Assert.assertEquals(new HashSet<Class>(Arrays.asList(DefaultBranchPropertyStrategy.class, NamedExceptionsBranchPropertyStrategy.class)), strategyTypes);
    }

    @Test
    public void applicableSCMs() throws Exception {
        WorkflowMultiBranchProject mp = (WorkflowMultiBranchProject)this.r.jenkins.createProject(WorkflowMultiBranchProject.class, "p");
        ArrayList<Class> scmTypes = new ArrayList<Class>();
        List scmDescriptors = SingleSCMSource.DescriptorImpl.getSCMDescriptors((SCMSourceOwner)mp);
        for (SCMDescriptor scmDescriptor : scmDescriptors) {
            scmTypes.add(scmDescriptor.clazz);
        }
        MatcherAssert.assertThat(scmTypes, (Matcher)Matchers.hasItem(GitSCM.class));
        MatcherAssert.assertThat(scmTypes, (Matcher)Matchers.not((Matcher)Matchers.hasItem(OldSCM.class)));
    }

    @Test
    public void conflictingBranches() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("Jenkinsfile", "");
        this.sampleRepo.git(new String[]{"add", "Jenkinsfile"});
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=flow"});
        WorkflowMultiBranchProject mp = (WorkflowMultiBranchProject)this.r.jenkins.createProject(WorkflowMultiBranchProject.class, "p");
        mp.getSourcesList().add((Object)new BranchSource((SCMSource)new GitSCMSource(null, this.sampleRepo.toString(), "", "*", "", false), (BranchPropertyStrategy)new DefaultBranchPropertyStrategy(new BranchProperty[0])));
        mp.getSourcesList().add((Object)new BranchSource((SCMSource)new GitSCMSource(null, this.sampleRepo.toString(), "", "*", "", false), (BranchPropertyStrategy)new DefaultBranchPropertyStrategy(new BranchProperty[0])));
        WorkflowJob p = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(mp, "master");
        this.r.waitUntilNoActivity();
        Assert.assertEquals((long)1L, (long)mp.getItems().size());
        this.r.waitForCompletion((Run)p.getLastBuild());
        Thread.sleep(1000L);
        Assert.assertFalse((boolean)p.isBuilding());
        WorkflowRun b1 = p.getLastBuild();
        Assert.assertEquals((long)1L, (long)b1.getNumber());
        Queue.Item it = mp.scheduleBuild2(0, new Action[0]);
        Thread.sleep(100L);
        if (it != null) {
            System.out.println("indexing");
        }
        it.getFuture().waitForStart();
        it.getFuture().get();
    }

    @Test
    public void configuredScriptNameBranches() throws Exception {
        this.sampleRepo.init();
        WorkflowMultiBranchProject mp = (WorkflowMultiBranchProject)this.r.jenkins.createProject(WorkflowMultiBranchProject.class, "p");
        mp.getSourcesList().add((Object)new BranchSource((SCMSource)new GitSCMSource(null, this.sampleRepo.toString(), "", "*", "", false), (BranchPropertyStrategy)new DefaultBranchPropertyStrategy(new BranchProperty[0])));
        for (SCMSource source : mp.getSCMSources()) {
            Assert.assertEquals((Object)mp, (Object)source.getOwner());
        }
        WorkflowBranchProjectFactory projectFactory = new WorkflowBranchProjectFactory();
        projectFactory.setScriptPath("another-Jenkinsfile");
        mp.setProjectFactory((BranchProjectFactory)projectFactory);
        this.sampleRepo.write("file", "initial commit");
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=init-master"});
        mp.scheduleBuild2(0, new Action[0]).getFuture().get();
        Assert.assertNull((Object)mp.getItem("master"));
        this.sampleRepo.git(new String[]{"checkout", "-b", "feature"});
        this.sampleRepo.write("another-Jenkinsfile", "echo(/branch=$BRANCH_NAME/); node {checkout scm; echo readFile('file')}");
        this.sampleRepo.git(new String[]{"add", "another-Jenkinsfile"});
        this.sampleRepo.write("file", "subsequent content");
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=feature-create"});
        WorkflowJob p1 = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(mp, "feature");
        Assert.assertEquals((long)1L, (long)mp.getItems().size());
        this.r.waitUntilNoActivity();
        WorkflowRun b1 = p1.getLastBuild();
        Assert.assertEquals((long)1L, (long)b1.getNumber());
        this.r.assertLogContains("subsequent content", (Run)b1);
        this.r.assertLogContains("branch=feature", (Run)b1);
        this.sampleRepo.git(new String[]{"checkout", "-b", "feature2"});
        this.sampleRepo.write("another-Jenkinsfile", "echo(/branch=$BRANCH_NAME/); node {checkout scm; echo readFile('file').toUpperCase()}");
        this.sampleRepo.write("file", "alternative content");
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=feature2-create"});
        WorkflowJob p2 = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(mp, "feature2");
        Assert.assertEquals((long)2L, (long)mp.getItems().size());
        this.r.waitUntilNoActivity();
        WorkflowRun b2 = p2.getLastBuild();
        Assert.assertEquals((long)1L, (long)b2.getNumber());
        this.r.assertLogContains("ALTERNATIVE CONTENT", (Run)b2);
        this.r.assertLogContains("branch=feature2", (Run)b2);
    }

    @Test
    public void reloadMangledName() throws Exception {
        this.r.jenkins.setQuietPeriod(Integer.valueOf(0));
        this.sampleRepo.init();
        this.sampleRepo.write("Jenkinsfile", "echo 'on master'");
        this.sampleRepo.git(new String[]{"add", "Jenkinsfile"});
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=init"});
        for (String branch : List.of("ok-1", "danger_1")) {
            this.sampleRepo.git(new String[]{"checkout", "-b", branch, "master"});
            this.sampleRepo.write("Jenkinsfile", "echo 'on " + branch + "'");
            this.sampleRepo.git(new String[]{"add", "Jenkinsfile"});
            this.sampleRepo.git(new String[]{"commit", "--all", "--message=" + branch});
        }
        WorkflowMultiBranchProject mp = (WorkflowMultiBranchProject)this.r.jenkins.createProject(WorkflowMultiBranchProject.class, "p");
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(List.of(new BranchDiscoveryTrait()));
        mp.getSourcesList().add((Object)new BranchSource((SCMSource)source));
        WorkflowJob ok = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(mp, "ok-1");
        WorkflowJob danger = WorkflowMultiBranchProjectTest.findBranchProject(mp, "danger_1");
        this.r.waitUntilNoActivity();
        MatcherAssert.assertThat((Object)ok.getRootDir().getName(), (Matcher)Matchers.is((Object)"ok-1"));
        MatcherAssert.assertThat((Object)danger.getRootDir().getName(), (Matcher)Matchers.is((Object)"danger-1.i2g9ue"));
        ok.doReload();
        MatcherAssert.assertThat((Object)((String[])mp.getItems().stream().map(AbstractItem::getName).toArray(String[]::new)), (Matcher)Matchers.arrayContainingInAnyOrder((Object[])new String[]{"master", "ok-1", "danger_1"}));
        danger.doReload();
        MatcherAssert.assertThat((Object)((String[])mp.getItems().stream().map(AbstractItem::getName).toArray(String[]::new)), (Matcher)Matchers.arrayContainingInAnyOrder((Object[])new String[]{"master", "ok-1", "danger_1"}));
    }

    public static class OldSCM
    extends SCM {
        public ChangeLogParser createChangeLogParser() {
            return null;
        }

        @TestExtension(value={"applicableSCMs"})
        public static class DescriptorImpl
        extends SCMDescriptor<OldSCM> {
            public DescriptorImpl() {
                super(null);
            }

            @NonNull
            public String getDisplayName() {
                return "OldSCM";
            }
        }
    }

    @TestExtension(value={"conflictingBranches"})
    public static class Listener
    extends ItemListener {
        List<String> names = new ArrayList<String>();

        public void onCreated(Item item) {
            this.names.add(item.getFullName());
        }
    }
}

