/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.multibranch;

import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.concurrent.Future;
import jenkins.branch.BranchProperty;
import jenkins.branch.BranchPropertyStrategy;
import jenkins.branch.BranchSource;
import jenkins.branch.DefaultBranchPropertyStrategy;
import jenkins.model.Jenkins;
import jenkins.plugins.git.GitSCMSource;
import jenkins.plugins.git.GitSampleRepoRule;
import jenkins.plugins.git.GitStep;
import jenkins.scm.api.SCMSource;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.plugins.workflow.cps.CpsScmFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.libs.GlobalLibraries;
import org.jenkinsci.plugins.workflow.libs.LibraryConfiguration;
import org.jenkinsci.plugins.workflow.libs.LibraryRetriever;
import org.jenkinsci.plugins.workflow.multibranch.SCMBinderTest;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProjectTest;
import org.jenkinsci.plugins.workflow.test.steps.SemaphoreStep;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.BuildWatcher;
import org.jvnet.hudson.test.JenkinsSessionRule;

public class SCMVarTest {
    @ClassRule
    public static BuildWatcher buildWatcher = new BuildWatcher();
    @Rule
    public JenkinsSessionRule story = new JenkinsSessionRule();
    @Rule
    public GitSampleRepoRule sampleGitRepo = new GitSampleRepoRule();

    @Test
    public void scmPickle() throws Throwable {
        this.story.then(j -> {
            this.sampleGitRepo.init();
            this.sampleGitRepo.write("Jenkinsfile", "def _scm = scm; semaphore 'wait'; node {checkout _scm; echo readFile('file')}");
            this.sampleGitRepo.write("file", "initial content");
            this.sampleGitRepo.git(new String[]{"add", "Jenkinsfile"});
            this.sampleGitRepo.git(new String[]{"commit", "--all", "--message=flow"});
            WorkflowMultiBranchProject mp = (WorkflowMultiBranchProject)j.jenkins.createProject(WorkflowMultiBranchProject.class, "p");
            mp.getSourcesList().add((Object)new BranchSource((SCMSource)new GitSCMSource(null, this.sampleGitRepo.toString(), "", "*", "", false), (BranchPropertyStrategy)new DefaultBranchPropertyStrategy(new BranchProperty[0])));
            WorkflowJob p = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(mp, "master");
            SemaphoreStep.waitForStart((String)"wait/1", null);
            WorkflowRun b1 = p.getLastBuild();
            Assert.assertNotNull((Object)b1);
        });
        this.story.then(j -> {
            SemaphoreStep.success((String)"wait/1", null);
            WorkflowJob p = (WorkflowJob)j.jenkins.getItemByFullName("p/master", WorkflowJob.class);
            Assert.assertNotNull((Object)p);
            WorkflowRun b1 = p.getLastBuild();
            Assert.assertNotNull((Object)b1);
            Assert.assertEquals((long)1L, (long)b1.getNumber());
            j.assertLogContains("initial content", j.waitForCompletion((Run)b1));
            SCMBinderTest.assertRevisionAction(b1);
        });
    }

    @Test
    public void globalVariable() throws Throwable {
        this.story.then(j -> {
            File lib = new File(Jenkins.get().getRootDir(), "somelib");
            LibraryConfiguration cfg = new LibraryConfiguration("somelib", (LibraryRetriever)new LocalRetriever(lib));
            cfg.setImplicit(true);
            cfg.setDefaultVersion("fixed");
            GlobalLibraries.get().setLibraries(Arrays.asList(cfg));
            File vars = new File(lib, "vars");
            Files.createDirectories(vars.toPath(), new FileAttribute[0]);
            FileUtils.writeStringToFile((File)new File(vars, "standardJob.groovy"), (String)"def call(body) {\n  def config = [:]\n  body.resolveStrategy = Closure.DELEGATE_FIRST\n  body.delegate = config\n  body()\n  node {\n    checkout scm\n    echo \"loaded ${readFile config.file}\"\n  }\n}\n");
            this.sampleGitRepo.init();
            this.sampleGitRepo.write("Jenkinsfile", "standardJob {file = 'resource'}");
            this.sampleGitRepo.write("resource", "resource content");
            this.sampleGitRepo.git(new String[]{"add", "Jenkinsfile"});
            this.sampleGitRepo.git(new String[]{"add", "resource"});
            this.sampleGitRepo.git(new String[]{"commit", "--all", "--message=flow"});
            WorkflowMultiBranchProject mp = (WorkflowMultiBranchProject)j.jenkins.createProject(WorkflowMultiBranchProject.class, "p");
            mp.getSourcesList().add((Object)new BranchSource((SCMSource)new GitSCMSource(null, this.sampleGitRepo.toString(), "", "*", "", false), (BranchPropertyStrategy)new DefaultBranchPropertyStrategy(new BranchProperty[0])));
            WorkflowJob p = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(mp, "master");
            WorkflowRun b = (WorkflowRun)j.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
            j.assertLogContains("loaded resource content", (Run)b);
        });
    }

    @Test
    public void standaloneProject() throws Throwable {
        this.story.then(j -> {
            this.sampleGitRepo.init();
            this.sampleGitRepo.write("Jenkinsfile", "node {checkout scm; echo readFile('file')}");
            this.sampleGitRepo.write("file", "some content");
            this.sampleGitRepo.git(new String[]{"add", "Jenkinsfile"});
            this.sampleGitRepo.git(new String[]{"commit", "--all", "--message=flow"});
            WorkflowJob p = (WorkflowJob)j.jenkins.createProject(WorkflowJob.class, "p");
            p.setDefinition((FlowDefinition)new CpsScmFlowDefinition(new GitStep(this.sampleGitRepo.toString()).createSCM(), "Jenkinsfile"));
            WorkflowRun b = (WorkflowRun)j.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
            j.assertLogContains("some content", (Run)b);
        });
    }

    private static final class LocalRetriever
    extends LibraryRetriever {
        private final File lib;

        LocalRetriever(File lib) {
            this.lib = lib;
        }

        public void retrieve(String name, String version, boolean changelog, FilePath target, Run<?, ?> run, TaskListener listener) throws Exception {
            new FilePath(this.lib).copyRecursiveTo(target);
        }

        public void retrieve(String name, String version, FilePath target, Run<?, ?> run, TaskListener listener) throws Exception {
            this.retrieve(name, version, false, target, run, listener);
        }
    }
}

