/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.multibranch;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.TopLevelItem;
import hudson.scm.SCMDescriptor;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.branch.Branch;
import jenkins.branch.BranchProjectFactory;
import jenkins.branch.BranchPropertyStrategy;
import jenkins.branch.BranchSource;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.MultiBranchProjectDescriptor;
import jenkins.model.TransientActionFactory;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevisionAction;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkins.ui.icon.IconSpec;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.workflow.cps.Snippetizer;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.multibranch.AbstractWorkflowBranchProjectFactory;
import org.jenkinsci.plugins.workflow.multibranch.BranchJobProperty;
import org.jenkinsci.plugins.workflow.multibranch.Messages;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowBranchProjectFactory;

public class WorkflowMultiBranchProject
extends MultiBranchProject<WorkflowJob, WorkflowRun> {
    private static final Logger LOGGER = Logger.getLogger(WorkflowMultiBranchProject.class.getName());

    public WorkflowMultiBranchProject(ItemGroup parent, String name) {
        super(parent, name);
    }

    @NonNull
    protected BranchProjectFactory<WorkflowJob, WorkflowRun> newProjectFactory() {
        return new WorkflowBranchProjectFactory();
    }

    public SCMSourceCriteria getSCMSourceCriteria(@NonNull SCMSource source) {
        return ((AbstractWorkflowBranchProjectFactory)this.getProjectFactory()).getSCMSourceCriteria(source);
    }

    public void onLoad(ItemGroup<? extends Item> parent, String name) throws IOException {
        super.onLoad(parent, name);
        block2: for (WorkflowJob job : this.items.values()) {
            if (job.getProperty(BranchJobProperty.class) != null) continue;
            LOGGER.log(Level.WARNING, String.format("[JENKINS-55116] Found potential broken branch job property on %s, attempting to patch, you'll need to run a full rescan asap.", job.getFullName()));
            WorkflowRun build = job.getLastBuild();
            for (int i = 0; i < 3; ++i) {
                BranchJobProperty p;
                if (build == null) continue;
                SCMRevisionAction action = (SCMRevisionAction)build.getAction(SCMRevisionAction.class);
                if (action != null && (p = this.reconstructBranchJobProperty(job, action)) != null) {
                    try {
                        job.addProperty((JobProperty)p);
                        LOGGER.log(Level.WARNING, String.format("[JENKINS-55116] Reconstructed branch job property on %s from %s, you'll need to run a full rescan asap.", job.getFullName(), build.getNumber()));
                        continue block2;
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.SEVERE, String.format("[JENKINS-55116] Failed storing reconstructed branch job property on %s from %s", job.getFullName(), build.getNumber()), e);
                    }
                }
                build = build.getPreviousBuild();
            }
        }
    }

    private BranchJobProperty reconstructBranchJobProperty(@NonNull WorkflowJob job, @NonNull SCMRevisionAction action) {
        String sourceId = action.getSourceId();
        if (sourceId == null || sourceId.isEmpty()) {
            return null;
        }
        SCMHead head = action.getRevision().getHead();
        BranchSource source = null;
        for (BranchSource s : ((WorkflowMultiBranchProject)job.getParent()).getSources()) {
            if (!sourceId.equals(s.getSource().getId())) continue;
            source = s;
            break;
        }
        if (source == null) {
            return null;
        }
        BranchPropertyStrategy strategy = source.getStrategy();
        return new BranchJobProperty(new Branch(sourceId, head, source.getSource().build(head), strategy != null ? strategy.getPropertiesFor(head) : Collections.emptyList()));
    }

    @Extension
    public static class PerFolderAdder
    extends TransientActionFactory<WorkflowMultiBranchProject> {
        public Class<WorkflowMultiBranchProject> type() {
            return WorkflowMultiBranchProject.class;
        }

        @NonNull
        public Collection<? extends Action> createFor(@NonNull WorkflowMultiBranchProject target) {
            if (target.hasPermission(Item.EXTENDED_READ)) {
                return Collections.singleton(new Snippetizer.LocalAction());
            }
            return Collections.emptySet();
        }
    }

    @Extension
    @Symbol(value={"multibranch"})
    public static class DescriptorImpl
    extends MultiBranchProjectDescriptor
    implements IconSpec {
        @NonNull
        public String getDisplayName() {
            return Messages.WorkflowMultiBranchProject_DisplayName();
        }

        @NonNull
        public String getDescription() {
            return Messages.WorkflowMultiBranchProject_Description();
        }

        public String getIconFilePathPattern() {
            return "plugin/workflow-multibranch/images/pipelinemultibranchproject.svg";
        }

        public String getIconClassName() {
            return "symbol-git-branch-outline plugin-ionicons-api";
        }

        public TopLevelItem newInstance(ItemGroup parent, String name) {
            return new WorkflowMultiBranchProject(parent, name);
        }

        public boolean isApplicable(Descriptor descriptor) {
            if (descriptor instanceof SCMDescriptor) {
                SCMDescriptor d = (SCMDescriptor)descriptor;
                try {
                    if (!d.isApplicable((Job)new WorkflowJob(null, null))) {
                        return false;
                    }
                }
                catch (RuntimeException x) {
                    LOGGER.log(Level.FINE, "SCMDescriptor.isApplicable hack failed", x);
                }
            }
            return super.isApplicable(descriptor);
        }

        static {
            IconSet.icons.addIcon(new Icon("icon-pipeline-multibranch-project icon-sm", "plugin/workflow-multibranch/images/pipelinemultibranchproject.svg", "width: 16px; height: 16px;"));
            IconSet.icons.addIcon(new Icon("icon-pipeline-multibranch-project icon-md", "plugin/workflow-multibranch/images/pipelinemultibranchproject.svg", "width: 24px; height: 24px;"));
            IconSet.icons.addIcon(new Icon("icon-pipeline-multibranch-project icon-lg", "plugin/workflow-multibranch/images/pipelinemultibranchproject.svg", "width: 32px; height: 32px;"));
            IconSet.icons.addIcon(new Icon("icon-pipeline-multibranch-project icon-xlg", "plugin/workflow-multibranch/images/pipelinemultibranchproject.svg", "width: 48px; height: 48px;"));
        }
    }
}

