/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.multibranch;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.TaskListener;
import java.io.IOException;
import jenkins.scm.api.SCMProbeStat;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.multibranch.AbstractWorkflowBranchProjectFactory;
import org.jenkinsci.plugins.workflow.multibranch.SCMBinder;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class WorkflowBranchProjectFactory
extends AbstractWorkflowBranchProjectFactory {
    static final String SCRIPT = "Jenkinsfile";
    private String scriptPath = "Jenkinsfile";

    public Object readResolve() {
        if (this.scriptPath == null) {
            this.scriptPath = SCRIPT;
        }
        return this;
    }

    @DataBoundConstructor
    public WorkflowBranchProjectFactory() {
    }

    @DataBoundSetter
    public void setScriptPath(String scriptPath) {
        this.scriptPath = scriptPath == null || scriptPath.isEmpty() ? SCRIPT : scriptPath;
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    @Override
    protected FlowDefinition createDefinition() {
        return new SCMBinder(this.scriptPath);
    }

    @Override
    protected SCMSourceCriteria getSCMSourceCriteria(SCMSource source) {
        return new SCMSourceCriteria(){

            public boolean isHead(@NonNull SCMSourceCriteria.Probe probe, @NonNull TaskListener listener) throws IOException {
                SCMProbeStat stat = probe.stat(WorkflowBranchProjectFactory.this.scriptPath);
                switch (stat.getType()) {
                    case NONEXISTENT: {
                        if (stat.getAlternativePath() != null) {
                            listener.getLogger().format("      \u2018%s\u2019 not found (but found \u2018%s\u2019, search is case sensitive)%n", WorkflowBranchProjectFactory.this.scriptPath, stat.getAlternativePath());
                        } else {
                            listener.getLogger().format("      \u2018%s\u2019 not found%n", WorkflowBranchProjectFactory.this.scriptPath);
                        }
                        return false;
                    }
                    case DIRECTORY: {
                        listener.getLogger().format("      \u2018%s\u2019 found but is a directory not a file%n", WorkflowBranchProjectFactory.this.scriptPath);
                        return false;
                    }
                }
                listener.getLogger().format("      \u2018%s\u2019 found%n", WorkflowBranchProjectFactory.this.scriptPath);
                return true;
            }

            public int hashCode() {
                return this.getClass().hashCode();
            }

            public boolean equals(Object obj) {
                return this.getClass().isInstance(obj);
            }
        };
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractWorkflowBranchProjectFactory.AbstractWorkflowBranchProjectFactoryDescriptor {
        @NonNull
        public String getDisplayName() {
            return "by Jenkinsfile";
        }
    }
}

