/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.multibranch;

import com.google.common.base.Predicate;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.BulkChange;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.model.Run;
import hudson.model.Saveable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.branch.BuildRetentionBranchProperty;
import jenkins.branch.RateLimitBranchProperty;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.graphanalysis.DepthFirstScanner;
import org.jenkinsci.plugins.workflow.graphanalysis.NodeStepTypePredicate;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.multibranch.BranchJobProperty;
import org.jenkinsci.plugins.workflow.multibranch.JobPropertyTrackerAction;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

public class JobPropertyStep
extends Step {
    private final List<JobProperty> properties;
    private static final Logger LOGGER = Logger.getLogger(JobPropertyStep.class.getName());

    @DataBoundConstructor
    public JobPropertyStep(List<JobProperty> properties) {
        this.properties = properties;
    }

    public List<JobProperty> getProperties() {
        return this.properties;
    }

    public Map<JobPropertyDescriptor, JobProperty> getPropertiesMap() {
        return Descriptor.toMap(this.properties);
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public static class Execution
    extends SynchronousStepExecution<Void> {
        private final transient JobPropertyStep step;
        private static final long serialVersionUID = 1L;

        Execution(JobPropertyStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void run() throws Exception {
            FlowExecutionOwner owner;
            Object previousRun;
            Run build = (Run)this.getContext().get(Run.class);
            Job job = build.getParent();
            JobPropertyTrackerAction previousAction = (JobPropertyTrackerAction)job.getAction(JobPropertyTrackerAction.class);
            boolean previousHadStep = false;
            if (previousAction == null && (previousRun = build.getPreviousCompletedBuild()) instanceof FlowExecutionOwner.Executable && (owner = ((FlowExecutionOwner.Executable)previousRun).asFlowExecutionOwner()) != null) {
                try {
                    FlowExecution execution = owner.get();
                    if (execution != null) {
                        previousHadStep = new DepthFirstScanner().findFirstMatch(execution, (Predicate)new NodeStepTypePredicate(this.step.getDescriptor())) != null;
                    }
                }
                catch (IOException ex) {
                    LOGGER.log(Level.FINE, "Could not search for JobPropertyStep execution: previous run either had null execution due to legitimate error and shows as not-yet-started, or threw other IOException", ex);
                }
            }
            for (JobProperty prop : this.step.properties) {
                if (prop.getDescriptor().isApplicable(job.getClass())) continue;
                throw new AbortException("cannot apply " + prop.getDescriptor().getId() + " to a " + job.getClass().getSimpleName());
            }
            BulkChange bc = new BulkChange((Saveable)job);
            try {
                for (JobProperty prop : job.getAllProperties()) {
                    if (prop instanceof BranchJobProperty) continue;
                    if (previousAction != null) {
                        if (!previousAction.getJobPropertyDescriptors().contains(prop.getDescriptor().getId())) continue;
                        job.removeProperty(prop);
                        continue;
                    }
                    if (!previousHadStep) continue;
                    job.removeProperty(prop);
                }
                for (JobProperty prop : this.step.properties) {
                    job.addProperty(prop);
                }
                bc.commit();
                job.replaceAction((Action)new JobPropertyTrackerAction(this.step.properties));
            }
            finally {
                bc.abort();
            }
            return null;
        }
    }

    @Extension
    public static class HideSuperfluousBranchProperties
    extends DescriptorVisibilityFilter {
        public boolean filter(Object context, @NonNull Descriptor descriptor) {
            return !(context instanceof WorkflowMultiBranchProject) || descriptor.clazz != RateLimitBranchProperty.class && descriptor.clazz != BuildRetentionBranchProperty.class;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "properties";
        }

        @NonNull
        public String getDisplayName() {
            return "Set job properties";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Set.of(Run.class);
        }

        public Step newInstance(@NonNull StaplerRequest2 req, @NonNull JSONObject formData) throws Descriptor.FormException {
            if (req == null) {
                return (Step)super.newInstance((StaplerRequest2)null, formData);
            }
            ArrayList<JobProperty> properties = new ArrayList<JobProperty>();
            ClassLoader cl = req.getStapler().getWebApp().getClassLoader();
            Set entrySet = formData.getJSONObject("propertiesMap").entrySet();
            for (Map.Entry e : entrySet) {
                JSONObject more;
                Class<JobProperty> itemType;
                if (!(e.getValue() instanceof JSONObject)) continue;
                String className = ((String)e.getKey()).replace('-', '.');
                try {
                    itemType = cl.loadClass(className).asSubclass(JobProperty.class);
                }
                catch (ClassNotFoundException x) {
                    throw new Descriptor.FormException((Throwable)x, "propertiesMap");
                }
                JobPropertyDescriptor d = (JobPropertyDescriptor)Jenkins.get().getDescriptorOrDie(itemType);
                JobProperty property = d.newInstance(req, more = (JSONObject)e.getValue());
                if (property == null) continue;
                properties.add(property);
            }
            return new JobPropertyStep(properties);
        }

        @Restricted(value={DoNotUse.class})
        public Collection<? extends Descriptor<?>> getPropertyDescriptors() {
            ArrayList<JobPropertyDescriptor> result = new ArrayList<JobPropertyDescriptor>();
            for (JobPropertyDescriptor p : ExtensionList.lookup(JobPropertyDescriptor.class)) {
                if (!p.isApplicable(WorkflowJob.class)) continue;
                result.add(p);
            }
            return result;
        }
    }
}

