/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.multibranch;

import hudson.model.Item;
import hudson.model.Run;
import java.io.File;
import java.util.Collections;
import jenkins.branch.BranchSource;
import jenkins.plugins.git.GitSCMSource;
import jenkins.plugins.git.GitSampleRepoRule;
import jenkins.plugins.git.traits.BranchDiscoveryTrait;
import jenkins.scm.api.SCMSource;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProjectTest;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.BuildWatcher;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.JenkinsSessionRule;

public class WorkflowBranchProjectFactoryTest {
    @ClassRule
    public static BuildWatcher buildWatcher = new BuildWatcher();
    @Rule
    public JenkinsSessionRule story = new JenkinsSessionRule();
    @Rule
    public GitSampleRepoRule sampleRepo = new GitSampleRepoRule();

    @Test
    public void slashyBranches() throws Throwable {
        this.story.then(j -> {
            this.sampleRepo.init();
            this.sampleRepo.git(new String[]{"checkout", "-b", "dev/main"});
            String script = "echo \"branch=${env.BRANCH_NAME}\"\nnode {\n  checkout scm\n  echo \"workspace=${pwd().replaceFirst('.+dev', 'dev')}\"\n}";
            this.sampleRepo.write("Jenkinsfile", script);
            this.sampleRepo.git(new String[]{"add", "Jenkinsfile"});
            this.sampleRepo.git(new String[]{"commit", "--all", "--message=flow"});
            WorkflowMultiBranchProject mp = (WorkflowMultiBranchProject)j.jenkins.createProject(WorkflowMultiBranchProject.class, "p");
            GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
            source.setTraits(Collections.singletonList(new BranchDiscoveryTrait()));
            mp.getSourcesList().add((Object)new BranchSource((SCMSource)source));
            WorkflowJob p = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(mp, "dev%2Fmain");
            Assert.assertEquals((long)1L, (long)mp.getItems().size());
            j.waitUntilNoActivity();
            WorkflowRun b1 = p.getLastBuild();
            Assert.assertEquals((long)1L, (long)b1.getNumber());
            j.assertLogContains("branch=dev/main", (Run)b1);
            j.assertLogContains("workspace=dev_main", (Run)b1);
            WorkflowBranchProjectFactoryTest.verifyProject(j, p);
            this.sampleRepo.write("Jenkinsfile", script.replace("branch=", "Branch="));
        });
        this.story.then(j -> {
            WorkflowJob p = (WorkflowJob)j.jenkins.getItemByFullName("p/dev%2Fmain", WorkflowJob.class);
            Assert.assertNotNull((Object)p);
            this.sampleRepo.git(new String[]{"commit", "--all", "--message=Flow"});
            this.sampleRepo.notifyCommit(j);
            WorkflowRun b2 = p.getLastBuild();
            Assert.assertEquals((long)2L, (long)b2.getNumber());
            j.assertLogContains("Branch=dev/main", (Run)b2);
            j.assertLogContains("workspace=dev_main", (Run)b2);
            WorkflowBranchProjectFactoryTest.verifyProject(j, p);
        });
    }

    private static void verifyProject(JenkinsRule j, WorkflowJob p) throws Exception {
        Assert.assertEquals((Object)"dev%2Fmain", (Object)p.getName());
        Assert.assertEquals((Object)"dev/main", (Object)p.getDisplayName());
        Assert.assertEquals((Object)"p/dev%2Fmain", (Object)p.getFullName());
        Assert.assertEquals((Object)"p \u00bb dev/main", (Object)p.getFullDisplayName());
        j.createWebClient().getPage((Item)p);
        Assert.assertEquals((Object)new File(new File(p.getParent().getRootDir(), "branches"), "dev-main.k31kdj"), (Object)p.getRootDir());
    }
}

