/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.multibranch;

import com.cloudbees.hudson.plugins.folder.computed.DefaultOrphanedItemStrategy;
import com.cloudbees.hudson.plugins.folder.computed.OrphanedItemStrategy;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.plugins.git.util.BuildData;
import hudson.scm.ChangeLogSet;
import hudson.security.SecurityRealm;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import jenkins.branch.BranchSource;
import jenkins.model.Jenkins;
import jenkins.plugins.git.GitBranchSCMRevision;
import jenkins.plugins.git.GitSCMSource;
import jenkins.plugins.git.GitSampleRepoRule;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMRevisionAction;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceDescriptor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.multibranch.Messages;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProjectTest;
import org.jenkinsci.plugins.workflow.test.steps.SemaphoreStep;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.BuildWatcher;
import org.jvnet.hudson.test.JenkinsRule;
import org.springframework.security.core.Authentication;

public class SCMBinderTest {
    @ClassRule
    public static BuildWatcher buildWatcher = new BuildWatcher();
    @Rule
    public JenkinsRule r = new JenkinsRule();
    @Rule
    public GitSampleRepoRule sampleGitRepo = new GitSampleRepoRule();

    @Test
    public void exactRevisionGit() throws Exception {
        this.sampleGitRepo.init();
        ScriptApproval sa = ScriptApproval.get();
        sa.approveSignature("staticField hudson.model.Items XSTREAM2");
        sa.approveSignature("method com.thoughtworks.xstream.XStream toXML java.lang.Object");
        this.sampleGitRepo.write("Jenkinsfile", "echo hudson.model.Items.XSTREAM2.toXML(scm); semaphore 'wait'; node {checkout scm; echo readFile('file')}");
        this.sampleGitRepo.write("file", "initial content");
        this.sampleGitRepo.git(new String[]{"add", "Jenkinsfile"});
        this.sampleGitRepo.git(new String[]{"commit", "--all", "--message=flow"});
        WorkflowMultiBranchProject mp = (WorkflowMultiBranchProject)this.r.jenkins.createProject(WorkflowMultiBranchProject.class, "p");
        mp.getSourcesList().add((Object)new BranchSource((SCMSource)new GitSCMSource(null, this.sampleGitRepo.toString(), "", "*", "", false)));
        WorkflowJob p = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(mp, "master");
        SemaphoreStep.waitForStart((String)"wait/1", null);
        WorkflowRun b1 = p.getLastBuild();
        Assert.assertNotNull((Object)b1);
        Assert.assertEquals((long)1L, (long)b1.getNumber());
        SCMBinderTest.assertRevisionAction(b1);
        this.r.assertLogContains("Obtained Jenkinsfile from ", (Run)b1);
        this.sampleGitRepo.write("Jenkinsfile", "node {checkout scm; echo readFile('file').toUpperCase()}");
        this.sampleGitRepo.write("file", "subsequent content");
        this.sampleGitRepo.git(new String[]{"commit", "--all", "--message=tweaked"});
        SemaphoreStep.success((String)"wait/1", null);
        this.sampleGitRepo.notifyCommit(this.r);
        WorkflowRun b2 = p.getLastBuild();
        Assert.assertEquals((long)2L, (long)b2.getNumber());
        this.r.assertLogContains("initial content", this.r.waitForCompletion((Run)b1));
        this.r.assertLogContains("SUBSEQUENT CONTENT", (Run)b2);
        SCMBinderTest.assertRevisionAction(b2);
        WorkflowMultiBranchProjectTest.showIndexing(mp);
        List changeSets = b2.getChangeSets();
        Assert.assertEquals((long)1L, (long)changeSets.size());
        ChangeLogSet changeSet = (ChangeLogSet)changeSets.get(0);
        Assert.assertEquals((Object)b2, (Object)changeSet.getRun());
        Assert.assertEquals((Object)"git", (Object)changeSet.getKind());
        Iterator iterator = changeSet.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        ChangeLogSet.Entry entry = (ChangeLogSet.Entry)iterator.next();
        Assert.assertEquals((Object)"tweaked", (Object)entry.getMsg());
        Assert.assertEquals((Object)"[Jenkinsfile, file]", (Object)new TreeSet(entry.getAffectedPaths()).toString());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public static void assertRevisionAction(WorkflowRun build) {
        SCMRevisionAction revisionAction = (SCMRevisionAction)build.getAction(SCMRevisionAction.class);
        Assert.assertNotNull((Object)revisionAction);
        SCMRevision revision = revisionAction.getRevision();
        Assert.assertEquals(GitBranchSCMRevision.class, revision.getClass());
        HashSet<String> expected = new HashSet<String>();
        List buildDataActions = build.getActions(BuildData.class);
        if (!buildDataActions.isEmpty()) {
            for (BuildData data : buildDataActions) {
                expected.add(data.lastBuild.marked.getSha1().getName());
            }
            Assert.assertThat(expected, (Matcher)Matchers.hasItem((Object)((GitBranchSCMRevision)revision).getHash()));
        }
    }

    @Test
    public void deletedJenkinsfile() throws Exception {
        this.sampleGitRepo.init();
        this.sampleGitRepo.write("Jenkinsfile", "node { echo 'Hello World' }");
        this.sampleGitRepo.git(new String[]{"add", "Jenkinsfile"});
        this.sampleGitRepo.git(new String[]{"commit", "--all", "--message=flow"});
        WorkflowMultiBranchProject mp = (WorkflowMultiBranchProject)this.r.jenkins.createProject(WorkflowMultiBranchProject.class, "p");
        mp.getSourcesList().add((Object)new BranchSource((SCMSource)new GitSCMSource(null, this.sampleGitRepo.toString(), "", "*", "", false)));
        WorkflowJob p = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(mp, "master");
        Assert.assertEquals((long)1L, (long)mp.getItems().size());
        this.r.waitUntilNoActivity();
        WorkflowRun b1 = p.getLastBuild();
        Assert.assertEquals((long)1L, (long)b1.getNumber());
        this.sampleGitRepo.git(new String[]{"rm", "Jenkinsfile"});
        this.sampleGitRepo.git(new String[]{"commit", "--all", "--message=remove"});
        WorkflowRun b2 = (WorkflowRun)this.r.assertBuildStatus(Result.FAILURE, (Run)((WorkflowRun)p.scheduleBuild2(0, new Action[0]).get()));
        this.r.assertLogContains("Jenkinsfile not found", (Run)b2);
    }

    @Test
    public void deletedBranch() throws Exception {
        this.r.jenkins.setSecurityRealm((SecurityRealm)this.r.createDummySecurityRealm());
        this.sampleGitRepo.init();
        this.sampleGitRepo.write("Jenkinsfile", "node {deleteDir(); checkout scm; echo 'Hello World'}");
        this.sampleGitRepo.git(new String[]{"add", "Jenkinsfile"});
        this.sampleGitRepo.git(new String[]{"commit", "--all", "--message=flow"});
        this.sampleGitRepo.git(new String[]{"checkout", "-b", "feature"});
        this.sampleGitRepo.write("somefile", "stuff");
        this.sampleGitRepo.git(new String[]{"add", "somefile"});
        this.sampleGitRepo.git(new String[]{"commit", "--all", "--message=tweaked"});
        WorkflowMultiBranchProject mp = (WorkflowMultiBranchProject)this.r.jenkins.createProject(WorkflowMultiBranchProject.class, "p");
        mp.getSourcesList().add((Object)new BranchSource((SCMSource)new GitSCMSource(null, this.sampleGitRepo.toString(), "", "*", "", false)));
        mp.setOrphanedItemStrategy((OrphanedItemStrategy)new DefaultOrphanedItemStrategy(false, "", ""));
        WorkflowJob p = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(mp, "feature");
        Assert.assertEquals((long)2L, (long)mp.getItems().size());
        this.r.waitUntilNoActivity();
        WorkflowRun b1 = p.getLastBuild();
        Assert.assertEquals((long)1L, (long)b1.getNumber());
        Authentication auth = User.getById((String)"dev", (boolean)true).impersonate2();
        Assert.assertFalse((boolean)p.getACL().hasPermission2(auth, Item.DELETE));
        Assert.assertTrue((boolean)p.isBuildable());
        this.sampleGitRepo.git(new String[]{"checkout", "master"});
        this.sampleGitRepo.git(new String[]{"branch", "-D", "feature"});
        Util.deleteRecursive((File)new File(this.r.jenkins.getRootDir(), "caches"));
        WorkflowRun b2 = (WorkflowRun)this.r.assertBuildStatus(Result.FAILURE, (Run)((WorkflowRun)p.scheduleBuild2(0, new Action[0]).get()));
        this.r.assertLogContains("nondeterministic checkout", (Run)b2);
        this.r.assertLogContains("Could not determine exact tip revision of feature", (Run)b2);
        mp.scheduleBuild2(0, new Action[0]).getFuture().get();
        WorkflowMultiBranchProjectTest.showIndexing(mp);
        Assert.assertEquals((long)2L, (long)mp.getItems().size());
        Assert.assertTrue((boolean)p.getACL().hasPermission2(auth, Item.DELETE));
        Assert.assertFalse((boolean)p.isBuildable());
        mp.setOrphanedItemStrategy((OrphanedItemStrategy)new DefaultOrphanedItemStrategy(true, "", "0"));
        mp.scheduleBuild2(0, new Action[0]).getFuture().get();
        WorkflowMultiBranchProjectTest.showIndexing(mp);
        Assert.assertEquals((long)1L, (long)mp.getItems().size());
    }

    @Test
    public void untrustedRevisions() throws Exception {
        this.sampleGitRepo.init();
        this.sampleGitRepo.write("Jenkinsfile", "node {checkout scm; echo readFile('file')}");
        this.sampleGitRepo.write("file", "initial content");
        this.sampleGitRepo.git(new String[]{"add", "Jenkinsfile"});
        this.sampleGitRepo.git(new String[]{"commit", "--all", "--message=flow"});
        WorkflowMultiBranchProject mp = (WorkflowMultiBranchProject)this.r.jenkins.createProject(WorkflowMultiBranchProject.class, "p");
        mp.getSourcesList().add((Object)new BranchSource((SCMSource)new WarySource(null, this.sampleGitRepo.toString(), "", "*", "", false)));
        WorkflowJob p = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(mp, "master");
        this.r.waitUntilNoActivity();
        WorkflowRun b = p.getLastBuild();
        Assert.assertNotNull((Object)b);
        Assert.assertEquals((long)1L, (long)b.getNumber());
        SCMBinderTest.assertRevisionAction(b);
        this.r.assertBuildStatusSuccess((Run)b);
        this.r.assertLogContains("initial content", (Run)b);
        String branch = "some-other-branch-from-Norway";
        this.sampleGitRepo.git(new String[]{"checkout", "-b", branch});
        this.sampleGitRepo.write("Jenkinsfile", "error 'ALL YOUR BUILD STEPS ARE BELONG TO US'");
        this.sampleGitRepo.write("file", "subsequent content");
        this.sampleGitRepo.git(new String[]{"commit", "--all", "--message=big evil laugh"});
        p = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(mp, branch);
        this.r.waitUntilNoActivity();
        b = p.getLastBuild();
        Assert.assertNotNull((Object)b);
        Assert.assertEquals((long)1L, (long)b.getNumber());
        SCMBinderTest.assertRevisionAction(b);
        this.r.assertBuildStatusSuccess((Run)b);
        this.r.assertLogContains(Messages.ReadTrustedStep__has_been_modified_in_an_untrusted_revis((Object)"Jenkinsfile"), (Run)b);
        this.r.assertLogContains("subsequent content", (Run)b);
        this.r.assertLogContains("not trusting", (Run)b);
    }

    public static class WarySource
    extends GitSCMSource {
        public WarySource(String id, String remote, String credentialsId, String includes, String excludes, boolean ignoreOnPushNotifications) {
            super(id, remote, credentialsId, includes, excludes, ignoreOnPushNotifications);
        }

        public SCMRevision getTrustedRevision(@NonNull SCMRevision revision, @NonNull TaskListener listener) throws IOException, InterruptedException {
            String branch = revision.getHead().getName();
            if (branch.equals("master")) {
                return revision;
            }
            listener.getLogger().println("not trusting " + branch);
            return this.fetch(new SCMHead("master"), listener);
        }

        public SCMSourceDescriptor getDescriptor() {
            return (SCMSourceDescriptor)Jenkins.get().getDescriptorByType(GitSCMSource.DescriptorImpl.class);
        }
    }
}

