/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.multibranch;

import hudson.model.Action;
import hudson.model.BooleanParameterDefinition;
import hudson.model.BooleanParameterValue;
import hudson.model.ChoiceParameterDefinition;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import hudson.model.queue.QueueTaskFuture;
import hudson.tasks.LogRotator;
import hudson.triggers.SCMTrigger;
import hudson.triggers.TimerTrigger;
import hudson.triggers.Trigger;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import jenkins.branch.BranchProperty;
import jenkins.branch.BranchPropertyStrategy;
import jenkins.branch.BranchSource;
import jenkins.branch.DefaultBranchPropertyStrategy;
import jenkins.branch.OverrideIndexTriggersJobProperty;
import jenkins.model.BuildDiscarder;
import jenkins.model.BuildDiscarderProperty;
import jenkins.plugins.git.GitBranchSCMHead;
import jenkins.plugins.git.GitSCMSource;
import jenkins.plugins.git.GitSampleRepoRule;
import jenkins.plugins.git.traits.BranchDiscoveryTrait;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMSource;
import jenkins.triggers.ReverseBuildTrigger;
import org.jenkinsci.plugins.structs.SymbolLookup;
import org.jenkinsci.plugins.structs.describable.ArrayType;
import org.jenkinsci.plugins.structs.describable.DescribableModel;
import org.jenkinsci.plugins.structs.describable.DescribableParameter;
import org.jenkinsci.plugins.structs.describable.ErrorType;
import org.jenkinsci.plugins.structs.describable.HeterogeneousObjectType;
import org.jenkinsci.plugins.structs.describable.HomogeneousObjectType;
import org.jenkinsci.plugins.structs.describable.ParameterType;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.cps.SnippetizerTester;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.job.properties.DisableConcurrentBuildsJobProperty;
import org.jenkinsci.plugins.workflow.job.properties.MockTrigger;
import org.jenkinsci.plugins.workflow.job.properties.PipelineTriggersJobProperty;
import org.jenkinsci.plugins.workflow.multibranch.JobPropertyStep;
import org.jenkinsci.plugins.workflow.multibranch.JobPropertyTrackerAction;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProjectTest;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepConfigTester;
import org.jenkinsci.plugins.workflow.test.steps.SemaphoreStep;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.BuildWatcher;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.recipes.LocalData;
import org.kohsuke.stapler.NoStaplerConstructorException;

public class JobPropertyStepTest {
    @ClassRule
    public static BuildWatcher buildWatcher = new BuildWatcher();
    @Rule
    public JenkinsRule r = new JenkinsRule();
    @Rule
    public GitSampleRepoRule sampleRepo = new GitSampleRepoRule();

    @After
    public void resetStartsAndStops() {
        MockTrigger.startsAndStops = new ArrayList();
    }

    @Test
    public void configRoundTripParameters() throws Exception {
        List properties = Collections.singletonList(new ParametersDefinitionProperty(new ParameterDefinition[]{new BooleanParameterDefinition("flag", true, null)}));
        new SnippetizerTester(this.r).assertRoundTrip((Step)new JobPropertyStep(properties), "properties([parameters([booleanParam(defaultValue: true, name: 'flag')])])");
        StepConfigTester tester = new StepConfigTester(this.r);
        properties = ((JobPropertyStep)tester.configRoundTrip((Step)new JobPropertyStep(properties))).getProperties();
        ParametersDefinitionProperty pdp = this.getPropertyFromList(ParametersDefinitionProperty.class, properties);
        Assert.assertNotNull((Object)pdp);
        Assert.assertEquals((long)1L, (long)pdp.getParameterDefinitions().size());
        Assert.assertEquals(BooleanParameterDefinition.class, ((ParameterDefinition)pdp.getParameterDefinitions().get(0)).getClass());
        BooleanParameterDefinition bpd = (BooleanParameterDefinition)pdp.getParameterDefinitions().get(0);
        Assert.assertEquals((Object)"flag", (Object)bpd.getName());
        Assert.assertTrue((boolean)bpd.isDefaultValue());
        List emptyInput = ((JobPropertyStep)tester.configRoundTrip((Step)new JobPropertyStep(Collections.emptyList()))).getProperties();
        pdp = this.getPropertyFromList(ParametersDefinitionProperty.class, emptyInput);
        Assert.assertNull((Object)pdp);
    }

    @Test
    public void testPreviousBuildFailedHard() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'Not doing anything'", true));
        WorkflowRun run = (WorkflowRun)this.r.buildAndAssertSuccess((Job)p);
        Field f = run.getClass().getDeclaredField("execution");
        f.setAccessible(true);
        f.set(run, null);
        Assert.assertNull((Object)run.getExecution());
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("properties([buildDiscarder(logRotator(numToKeepStr: '1'))])", true));
        this.r.buildAndAssertSuccess((Job)p);
    }

    @Test
    public void configRoundTripBuildDiscarder() throws Exception {
        List properties = Collections.singletonList(new BuildDiscarderProperty((BuildDiscarder)new LogRotator(1, 2, -1, 3)));
        new SnippetizerTester(this.r).assertRoundTrip((Step)new JobPropertyStep(properties), "properties([buildDiscarder(logRotator(artifactDaysToKeepStr: '', artifactNumToKeepStr: '3', daysToKeepStr: '1', numToKeepStr: '2'))])");
        StepConfigTester tester = new StepConfigTester(this.r);
        properties = ((JobPropertyStep)tester.configRoundTrip((Step)new JobPropertyStep(properties))).getProperties();
        BuildDiscarderProperty bdp = this.getPropertyFromList(BuildDiscarderProperty.class, properties);
        Assert.assertNotNull((Object)bdp);
        BuildDiscarder strategy = bdp.getStrategy();
        Assert.assertNotNull((Object)strategy);
        Assert.assertEquals(LogRotator.class, strategy.getClass());
        LogRotator lr = (LogRotator)strategy;
        Assert.assertEquals((long)1L, (long)lr.getDaysToKeep());
        Assert.assertEquals((long)2L, (long)lr.getNumToKeep());
        Assert.assertEquals((long)-1L, (long)lr.getArtifactDaysToKeep());
        Assert.assertEquals((long)3L, (long)lr.getArtifactNumToKeep());
    }

    @Test
    public void useParameter() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("Jenkinsfile", "properties([parameters([string(name: 'myparam', defaultValue: 'default value')])])\necho \"received ${params.myparam}\"");
        this.sampleRepo.git(new String[]{"add", "Jenkinsfile"});
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=flow"});
        WorkflowMultiBranchProject mp = (WorkflowMultiBranchProject)this.r.jenkins.createProject(WorkflowMultiBranchProject.class, "p");
        mp.getSourcesList().add((Object)new BranchSource((SCMSource)new GitSCMSource(null, this.sampleRepo.toString(), "", "*", "", false)));
        WorkflowJob p = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(mp, "master");
        Assert.assertEquals((long)1L, (long)mp.getItems().size());
        this.r.waitUntilNoActivity();
        WorkflowRun b1 = p.getLastBuild();
        Assert.assertEquals((long)1L, (long)b1.getNumber());
        this.r.assertLogContains("received default value", (Run)b1);
        WorkflowRun b2 = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[]{new ParametersAction(new ParameterValue[]{new StringParameterValue("myparam", "special value")})}));
        Assert.assertEquals((long)2L, (long)b2.getNumber());
        this.r.assertLogContains("received special value", (Run)b2);
        this.sampleRepo.write("Jenkinsfile", "properties([parameters([booleanParam(name: 'flag', defaultValue: false)])])\necho \"enabled? ${params.flag}\"");
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=flow"});
        this.sampleRepo.notifyCommit(this.r);
        WorkflowRun b3 = p.getLastBuild();
        Assert.assertEquals((long)3L, (long)b3.getNumber());
        this.r.assertLogContains("enabled? false", (Run)b3);
        WorkflowRun b4 = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[]{new ParametersAction(new ParameterValue[]{new BooleanParameterValue("flag", true)})}));
        Assert.assertEquals((long)4L, (long)b4.getNumber());
        this.r.assertLogContains("enabled? true", (Run)b4);
        this.sampleRepo.write("Jenkinsfile", "properties([parameters([booleanParam(name: 'newflag', defaultValue: false)])])\necho \"enabled again? ${params.newflag}\"");
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=flow"});
        WorkflowRun b5 = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[]{new ParametersAction(new ParameterValue[]{new BooleanParameterValue("newflag", true)})}));
        Assert.assertEquals((long)5L, (long)b5.getNumber());
        this.r.assertLogContains("enabled again? true", (Run)b5);
        this.sampleRepo.write("Jenkinsfile", "properties([parameters([choice(name: 'select', choices: 'foo\\nbar\\nbaz')])])\necho \"value ${params.select}\"");
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=flow"});
        this.sampleRepo.notifyCommit(this.r);
        WorkflowRun b6 = p.getLastBuild();
        Assert.assertEquals((long)6L, (long)b6.getNumber());
        this.r.assertLogContains("value foo", (Run)b6);
        WorkflowRun b7 = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[]{new ParametersAction(new ParameterValue[]{new StringParameterValue("select", "bar", "")})}));
        Assert.assertEquals((long)7L, (long)b7.getNumber());
        this.r.assertLogContains("value bar", (Run)b7);
        this.sampleRepo.write("Jenkinsfile", "properties([parameters([choice(name: 'select', choices: ['foo', 'bar', 'baz'] )])])\necho \"value ${params.select}\"");
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=flow"});
        this.sampleRepo.notifyCommit(this.r);
        WorkflowRun b8 = p.getLastBuild();
        Assert.assertEquals((long)8L, (long)b8.getNumber());
        this.r.assertLogContains("value foo", (Run)b8);
        WorkflowRun b9 = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[]{new ParametersAction(new ParameterValue[]{new StringParameterValue("select", "bar", "")})}));
        Assert.assertEquals((long)9L, (long)b9.getNumber());
        this.r.assertLogContains("value bar", (Run)b9);
    }

    @Ignore(value="TODO does not currently work; b2 says subsequently received #1")
    @Test
    public void changingParameterDefault() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("Jenkinsfile", "properties([parameters([string(name: 'x', defaultValue: '#1')])]); echo(/initially received $params.x/)");
        this.sampleRepo.git(new String[]{"add", "Jenkinsfile"});
        this.sampleRepo.git(new String[]{"commit", "--message=1"});
        WorkflowMultiBranchProject mp = (WorkflowMultiBranchProject)this.r.createProject(WorkflowMultiBranchProject.class, "mp");
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(List.of(new BranchDiscoveryTrait()));
        mp.getSourcesList().add((Object)new BranchSource((SCMSource)source));
        WorkflowJob p = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(mp, "master");
        Assert.assertEquals((long)1L, (long)mp.getItems().size());
        this.r.waitUntilNoActivity();
        WorkflowRun b1 = p.getLastBuild();
        Assert.assertEquals((long)1L, (long)b1.getNumber());
        this.r.assertLogContains("initially received #1", (Run)b1);
        this.sampleRepo.write("Jenkinsfile", "properties([parameters([string(name: 'x', defaultValue: '#2')])]); echo(/subsequently received $params.x/)");
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=2"});
        WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(mp, "master");
        this.r.waitUntilNoActivity();
        WorkflowRun b2 = p.getLastBuild();
        Assert.assertEquals((long)2L, (long)b2.getNumber());
        this.r.assertLogContains("subsequently received #2", (Run)b2);
    }

    @Test
    public void triggerWithParameter() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("properties([parameters([string(name: 'myparam')])]); echo(/got $params.myparam though the env var is $env.myparam/)", true));
        this.r.assertLogContains("got the value though the env var is null", this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[]{new ParametersAction(new ParameterValue[]{new StringParameterValue("myparam", "the value")})})));
    }

    @Test
    public void testChoiceParameterSnippetizer() throws Exception {
        new SnippetizerTester(this.r).assertRoundTrip((Step)new JobPropertyStep(Collections.singletonList(new ParametersDefinitionProperty(new ParameterDefinition[]{new ChoiceParameterDefinition("paramName", new String[]{"foo", "bar", "baz"}, "test")}))), "properties([parameters([choice(choices: ['foo', 'bar', 'baz'], description: 'test', name: 'paramName')])])");
    }

    @Test
    public void useBuildDiscarder() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("Jenkinsfile", "properties([buildDiscarder(logRotator(numToKeepStr: '1'))])");
        this.sampleRepo.git(new String[]{"add", "Jenkinsfile"});
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=flow"});
        WorkflowMultiBranchProject mp = (WorkflowMultiBranchProject)this.r.jenkins.createProject(WorkflowMultiBranchProject.class, "p");
        mp.getSourcesList().add((Object)new BranchSource((SCMSource)new GitSCMSource(null, this.sampleRepo.toString(), "", "*", "", false)));
        WorkflowJob p = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(mp, "master");
        Assert.assertEquals((long)1L, (long)mp.getItems().size());
        this.r.waitUntilNoActivity();
        Assert.assertEquals((long)1L, (long)p.getBuilds().size());
        this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        Thread.sleep(500L);
        Assert.assertEquals((long)1L, (long)p.getBuilds().size());
        this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        Thread.sleep(500L);
        Assert.assertEquals((long)1L, (long)p.getBuilds().size());
        WorkflowRun b3 = p.getLastBuild();
        Assert.assertEquals((long)3L, (long)b3.getNumber());
        Assert.assertNull((Object)b3.getPreviousBuild());
    }

    @Test
    public void onlyRemoveJenkinsfileProperties() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.addProperty((JobProperty)new DisableConcurrentBuildsJobProperty());
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'Not doing anything'", true));
        this.r.buildAndAssertSuccess((Job)p);
        Assert.assertNotNull((Object)p.getProperty(DisableConcurrentBuildsJobProperty.class));
        Assert.assertNull((Object)p.getAction(JobPropertyTrackerAction.class));
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("properties([buildDiscarder(logRotator(numToKeepStr: '1'))])", true));
        this.r.buildAndAssertSuccess((Job)p);
        Assert.assertNotNull((Object)p.getProperty(DisableConcurrentBuildsJobProperty.class));
        Assert.assertNotNull((Object)p.getProperty(BuildDiscarderProperty.class));
        JobPropertyTrackerAction action2 = (JobPropertyTrackerAction)p.getAction(JobPropertyTrackerAction.class);
        Assert.assertNotNull((Object)action2);
        Assert.assertEquals((long)1L, (long)action2.getJobPropertyDescriptors().size());
        Assert.assertEquals(Collections.singleton(this.r.jenkins.getDescriptor(BuildDiscarderProperty.class).getId()), (Object)action2.getJobPropertyDescriptors());
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("properties([])", true));
        this.r.buildAndAssertSuccess((Job)p);
        Assert.assertNotNull((Object)p.getProperty(DisableConcurrentBuildsJobProperty.class));
        Assert.assertNull((Object)p.getProperty(BuildDiscarderProperty.class));
        JobPropertyTrackerAction action3 = (JobPropertyTrackerAction)p.getAction(JobPropertyTrackerAction.class);
        Assert.assertNotNull((Object)action3);
        Assert.assertTrue((boolean)action3.getJobPropertyDescriptors().isEmpty());
    }

    @LocalData
    @Test
    public void trackerPropertyUpgrade() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.getItemByFullName("trackerPropertyUpgrade", WorkflowJob.class);
        Assert.assertNotNull((Object)p);
        WorkflowRun b1 = p.getLastBuild();
        Assert.assertNotNull((Object)b1);
        Assert.assertNotNull((Object)p.getProperty(BuildDiscarderProperty.class));
        Assert.assertNull((Object)p.getAction(JobPropertyTrackerAction.class));
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("properties([disableConcurrentBuilds()])", true));
        this.r.buildAndAssertSuccess((Job)p);
        Assert.assertNull((Object)p.getProperty(BuildDiscarderProperty.class));
        Assert.assertNotNull((Object)p.getProperty(DisableConcurrentBuildsJobProperty.class));
        JobPropertyTrackerAction action2 = (JobPropertyTrackerAction)p.getAction(JobPropertyTrackerAction.class);
        Assert.assertNotNull((Object)action2);
        Assert.assertEquals(Collections.singleton(this.r.jenkins.getDescriptor(DisableConcurrentBuildsJobProperty.class).getId()), (Object)action2.getJobPropertyDescriptors());
    }

    @Test
    public void concurrentBuildProperty() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("semaphore 'hang'", true));
        Assert.assertTrue((boolean)p.isConcurrentBuild());
        WorkflowRun b1 = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
        SemaphoreStep.waitForStart((String)"hang/1", (Run)b1);
        Assert.assertTrue((boolean)p.isConcurrentBuild());
        WorkflowRun b2 = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
        SemaphoreStep.waitForStart((String)"hang/2", (Run)b2);
        SemaphoreStep.success((String)"hang/1", null);
        this.r.assertBuildStatusSuccess((Run)((WorkflowRun)this.r.waitForCompletion((Run)b1)));
        SemaphoreStep.success((String)"hang/2", null);
        this.r.assertBuildStatusSuccess((Run)((WorkflowRun)this.r.waitForCompletion((Run)b2)));
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("properties([disableConcurrentBuilds()])\nsemaphore 'hang'", true));
        Assert.assertTrue((boolean)p.isConcurrentBuild());
        WorkflowRun b3 = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
        SemaphoreStep.waitForStart((String)"hang/3", (Run)b3);
        Assert.assertFalse((boolean)p.isConcurrentBuild());
        QueueTaskFuture futureB4 = p.scheduleBuild2(0, new Action[0]);
        Thread.sleep(2000L);
        Assert.assertFalse((boolean)futureB4.getStartCondition().isDone());
        SemaphoreStep.success((String)"hang/3", null);
        this.r.assertBuildStatusSuccess((Run)((WorkflowRun)this.r.waitForCompletion((Run)b3)));
        WorkflowRun b4 = (WorkflowRun)futureB4.waitForStart();
        SemaphoreStep.waitForStart((String)"hang/4", (Run)b4);
        SemaphoreStep.success((String)"hang/4", null);
        this.r.assertBuildStatusSuccess((Run)((WorkflowRun)this.r.waitForCompletion((Run)b4)));
    }

    @Test
    public void triggersProperty() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'foo'", true));
        Assert.assertTrue((boolean)p.getTriggers().isEmpty());
        this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        Assert.assertTrue((boolean)p.getTriggers().isEmpty());
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("properties([pipelineTriggers([\n  cron('@daily'), [$class: 'MockTrigger']])])\necho 'foo'", true));
        WorkflowRun b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        Assert.assertEquals((long)2L, (long)p.getTriggers().size());
        PipelineTriggersJobProperty triggerProp = p.getTriggersJobProperty();
        TimerTrigger timerTrigger = this.getTriggerFromList(TimerTrigger.class, triggerProp.getTriggers());
        Assert.assertNotNull((Object)timerTrigger);
        Assert.assertEquals((Object)"@daily", (Object)timerTrigger.getSpec());
        MockTrigger mockTrigger = this.getTriggerFromList(MockTrigger.class, triggerProp.getTriggers());
        Assert.assertNotNull((Object)mockTrigger);
        Assert.assertTrue((boolean)mockTrigger.isStarted);
        Assert.assertEquals((Object)"[null, false]", (Object)MockTrigger.startsAndStops.toString());
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("properties([disableConcurrentBuilds()])\necho 'foo'", true));
        WorkflowRun b2 = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        Assert.assertNotNull((Object)p.getTriggersJobProperty());
        Assert.assertTrue((boolean)p.getTriggers().isEmpty());
        Assert.assertEquals((Object)"[null, false, null]", (Object)MockTrigger.startsAndStops.toString());
    }

    @Test
    public void scmTriggerProperty() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'foo'", true));
        Assert.assertTrue((boolean)p.getTriggers().isEmpty());
        this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        Assert.assertTrue((boolean)p.getTriggers().isEmpty());
        if (SymbolLookup.getSymbolValue(SCMTrigger.class).contains("pollSCM")) {
            p.setDefinition((FlowDefinition)new CpsFlowDefinition("properties([pipelineTriggers([\n  pollSCM(scmpoll_spec: '@daily', ignorePostCommitHooks: true), [$class: 'MockTrigger']])])\necho 'foo'", true));
        } else {
            p.setDefinition((FlowDefinition)new CpsFlowDefinition("properties([pipelineTriggers([pollSCM(scmpoll_spec: '@daily', ignorePostCommitHooks: true),\n    [$class: 'MockTrigger']])])\necho 'foo'", true));
        }
        WorkflowRun b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        Assert.assertEquals((long)2L, (long)p.getTriggers().size());
        PipelineTriggersJobProperty triggerProp = p.getTriggersJobProperty();
        SCMTrigger scmTrigger = this.getTriggerFromList(SCMTrigger.class, triggerProp.getTriggers());
        Assert.assertNotNull((Object)scmTrigger);
        Assert.assertEquals((Object)"@daily", (Object)scmTrigger.getSpec());
        Assert.assertTrue((boolean)scmTrigger.isIgnorePostCommitHooks());
        MockTrigger mockTrigger = this.getTriggerFromList(MockTrigger.class, triggerProp.getTriggers());
        Assert.assertNotNull((Object)mockTrigger);
        Assert.assertTrue((boolean)mockTrigger.isStarted);
        Assert.assertEquals((Object)"[null, false]", (Object)MockTrigger.startsAndStops.toString());
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("properties([disableConcurrentBuilds()])\necho 'foo'", true));
        WorkflowRun b2 = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        Assert.assertNotNull((Object)p.getTriggersJobProperty());
        Assert.assertTrue((boolean)p.getTriggers().isEmpty());
        Assert.assertEquals((Object)"[null, false, null]", (Object)MockTrigger.startsAndStops.toString());
    }

    @Test
    public void scmAndEmptyTriggersProperty() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'foo'", true));
        Assert.assertTrue((boolean)p.getTriggers().isEmpty());
        this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        Assert.assertTrue((boolean)p.getTriggers().isEmpty());
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("properties([pipelineTriggers([pollSCM(scmpoll_spec: '@daily')])])\necho 'foo'", true));
        WorkflowRun b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        Assert.assertEquals((long)1L, (long)p.getTriggers().size());
        PipelineTriggersJobProperty triggerProp = p.getTriggersJobProperty();
        SCMTrigger scmTrigger = this.getTriggerFromList(SCMTrigger.class, triggerProp.getTriggers());
        Assert.assertNotNull((Object)scmTrigger);
        Assert.assertEquals((Object)"@daily", (Object)scmTrigger.getSpec());
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("properties([pipelineTriggers()])\necho 'foo'", true));
        WorkflowRun b2 = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        Assert.assertNotNull((Object)p.getTriggersJobProperty());
        Assert.assertTrue((boolean)p.getTriggers().isEmpty());
    }

    @Test
    public void generateHelpTrigger() throws Exception {
        DescribableModel model = new DescribableModel(PipelineTriggersJobProperty.class);
        Assert.assertNotNull((Object)model);
        this.recurseOnModel(model);
    }

    private void recurseOnTypes(ParameterType type) throws Exception {
        if (type instanceof ErrorType && !(((ErrorType)type).getError() instanceof NoStaplerConstructorException)) {
            throw ((ErrorType)type).getError();
        }
        if (type instanceof ArrayType) {
            this.recurseOnTypes(((ArrayType)type).getElementType());
        } else if (type instanceof HomogeneousObjectType) {
            this.recurseOnModel(((HomogeneousObjectType)type).getSchemaType());
        } else if (type instanceof HeterogeneousObjectType) {
            for (Map.Entry entry : ((HeterogeneousObjectType)type).getTypes().entrySet()) {
                this.recurseOnModel((DescribableModel)entry.getValue());
            }
        }
    }

    private void recurseOnModel(DescribableModel<?> model) throws Exception {
        for (DescribableParameter param : model.getParameters()) {
            this.recurseOnTypes(param.getType());
        }
    }

    @Test
    public void configRoundTripTrigger() throws Exception {
        List<PipelineTriggersJobProperty> properties = Collections.singletonList(new PipelineTriggersJobProperty(Collections.singletonList(new TimerTrigger("@daily"))));
        String snippetJson = "{'propertiesMap': {\n    'stapler-class-bag': 'true',\n    'org-jenkinsci-plugins-workflow-job-properties-PipelineTriggersJobProperty': {'triggers': {\n      'stapler-class-bag': 'true',\n      'hudson-triggers-TimerTrigger': {'spec': '@daily'}\n    }}},\n  'stapler-class': 'org.jenkinsci.plugins.workflow.multibranch.JobPropertyStep',\n  '$class': 'org.jenkinsci.plugins.workflow.multibranch.JobPropertyStep'}";
        new SnippetizerTester(this.r).assertGenerateSnippet(snippetJson, "properties([pipelineTriggers([cron('@daily')])])", null);
        new SnippetizerTester(this.r).assertRoundTrip((Step)new JobPropertyStep(properties), "properties([pipelineTriggers([cron('@daily')])])");
    }

    @Test
    public void configRoundTripSCMTrigger() throws Exception {
        List<PipelineTriggersJobProperty> properties = Collections.singletonList(new PipelineTriggersJobProperty(Collections.singletonList(new SCMTrigger("@daily"))));
        String snippetJson = "{'propertiesMap': {\n    'stapler-class-bag': 'true',\n    'org-jenkinsci-plugins-workflow-job-properties-PipelineTriggersJobProperty': {'triggers': {\n      'stapler-class-bag': 'true',\n      'hudson-triggers-SCMTrigger': {'scmpoll_spec': '@daily', 'ignorePostCommitHooks': false }\n    }}},\n  'stapler-class': 'org.jenkinsci.plugins.workflow.multibranch.JobPropertyStep',\n  '$class': 'org.jenkinsci.plugins.workflow.multibranch.JobPropertyStep'}";
        new SnippetizerTester(this.r).assertGenerateSnippet(snippetJson, "properties([pipelineTriggers([pollSCM('@daily')])])", null);
        new SnippetizerTester(this.r).assertRoundTrip((Step)new JobPropertyStep(properties), "properties([pipelineTriggers([pollSCM('@daily')])])");
    }

    @Test
    public void configRoundTripReverseBuildTrigger() throws Exception {
        List<PipelineTriggersJobProperty> properties = Collections.singletonList(new PipelineTriggersJobProperty(Collections.singletonList(new ReverseBuildTrigger("some-job", Result.UNSTABLE))));
        String snippetJson = "{'propertiesMap': {\n    'stapler-class-bag': 'true',\n    'org-jenkinsci-plugins-workflow-job-properties-PipelineTriggersJobProperty': {'triggers': {\n      'stapler-class-bag': 'true',\n      'jenkins-triggers-ReverseBuildTrigger': { 'threshold': 'UNSTABLE', 'upstreamProjects': 'some-job'}\n    }}},\n  'stapler-class': 'org.jenkinsci.plugins.workflow.multibranch.JobPropertyStep',\n  '$class': 'org.jenkinsci.plugins.workflow.multibranch.JobPropertyStep'}";
        new SnippetizerTester(this.r).assertGenerateSnippet(snippetJson, "properties([pipelineTriggers([upstream(threshold: 'UNSTABLE', upstreamProjects: 'some-job')])])", null);
        new SnippetizerTester(this.r).assertRoundTrip((Step)new JobPropertyStep(properties), "properties([pipelineTriggers([upstream(threshold: 'UNSTABLE', upstreamProjects: 'some-job')])])");
    }

    @Test
    public void noPropertiesWarnings() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("Jenkinsfile", "echo \"branch=${env.BRANCH_NAME}\"\nproperties([disableConcurrentBuilds()])");
        this.sampleRepo.write("file", "initial content");
        this.sampleRepo.git(new String[]{"add", "Jenkinsfile"});
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=flow"});
        WorkflowMultiBranchProject mp = (WorkflowMultiBranchProject)this.r.jenkins.createProject(WorkflowMultiBranchProject.class, "p");
        mp.getSourcesList().add((Object)new BranchSource((SCMSource)new GitSCMSource(null, this.sampleRepo.toString(), "", "*", "", false), (BranchPropertyStrategy)new DefaultBranchPropertyStrategy(new BranchProperty[0])));
        for (SCMSource source : mp.getSCMSources()) {
            Assert.assertEquals((Object)mp, (Object)source.getOwner());
        }
        WorkflowJob p = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(mp, "master");
        Assert.assertEquals((Object)new GitBranchSCMHead("master"), (Object)SCMHead.HeadByItem.findHead((Item)p));
        Assert.assertEquals((long)1L, (long)mp.getItems().size());
        this.r.waitUntilNoActivity();
        WorkflowRun b1 = p.getLastBuild();
        Assert.assertEquals((long)1L, (long)b1.getNumber());
        this.sampleRepo.write("Jenkinsfile", "echo \"branch=${env.BRANCH_NAME}\"\nproperties([buildDiscarder(logRotator(numToKeepStr: '1'))])");
        this.sampleRepo.git(new String[]{"add", "Jenkinsfile"});
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=flow"});
        this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
    }

    @Test
    public void disableTriggers() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("Jenkinsfile", "properties([overrideIndexTriggers(false)])");
        this.sampleRepo.git(new String[]{"add", "Jenkinsfile"});
        this.sampleRepo.git(new String[]{"commit", "--message=init"});
        WorkflowMultiBranchProject p = (WorkflowMultiBranchProject)this.r.jenkins.createProject(WorkflowMultiBranchProject.class, "p");
        BranchSource branchSource = new BranchSource((SCMSource)new GitSCMSource("source-id", this.sampleRepo.toString(), "", "*", "", false));
        p.getSourcesList().add((Object)branchSource);
        WorkflowJob master = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(p, "master");
        this.r.waitUntilNoActivity();
        this.r.assertBuildStatusSuccess((Run)master.getBuildByNumber(1));
        Assert.assertEquals((long)2L, (long)master.getNextBuildNumber());
        Assert.assertNotNull((Object)master.getProperty(OverrideIndexTriggersJobProperty.class));
        Assert.assertFalse((boolean)((OverrideIndexTriggersJobProperty)master.getProperty(OverrideIndexTriggersJobProperty.class)).getEnableTriggers());
        this.sampleRepo.write("Jenkinsfile", "properties([])");
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=master-2"});
        this.sampleRepo.notifyCommit(this.r);
        WorkflowMultiBranchProjectTest.showIndexing(p);
        Assert.assertEquals((long)2L, (long)master.getNextBuildNumber());
        WorkflowRun secondBuild = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)master.scheduleBuild2(0, new Action[0]));
        Assert.assertNotNull((Object)secondBuild);
        Assert.assertEquals((long)2L, (long)secondBuild.getNumber());
        Assert.assertEquals((long)3L, (long)master.getNextBuildNumber());
        Assert.assertNull((Object)master.getProperty(OverrideIndexTriggersJobProperty.class));
        this.sampleRepo.write("Jenkinsfile", "// yet more");
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=master-3"});
        this.sampleRepo.notifyCommit(this.r);
        WorkflowMultiBranchProjectTest.showIndexing(p);
        Assert.assertEquals((long)4L, (long)master.getNextBuildNumber());
    }

    @Test
    public void snippetGeneratorOverrideIndexing() throws Exception {
        String snippetJson = "{'propertiesMap':\n{'stapler-class-bag': 'true', 'jenkins-branch-OverrideIndexTriggersJobProperty': \n{'specified': true, 'enableTriggers': true}},\n'stapler-class': 'org.jenkinsci.plugins.workflow.multibranch.JobPropertyStep',\n'$class': 'org.jenkinsci.plugins.workflow.multibranch.JobPropertyStep'}";
        new SnippetizerTester(this.r).assertGenerateSnippet(snippetJson, "properties([overrideIndexTriggers(true)])", null);
    }

    private <T extends Trigger<?>> T getTriggerFromList(Class<T> clazz, List<Trigger<?>> triggers) {
        for (Trigger<?> t : triggers) {
            if (!clazz.isInstance(t)) continue;
            return (T)((Trigger)clazz.cast(t));
        }
        return null;
    }

    private <T extends JobProperty> T getPropertyFromList(Class<T> clazz, List<JobProperty> properties) {
        for (JobProperty p : properties) {
            if (!clazz.isInstance(p)) continue;
            return (T)((JobProperty)clazz.cast(p));
        }
        return null;
    }
}

