/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.multibranch;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Functions;
import hudson.MarkupText;
import hudson.console.ConsoleAnnotationDescriptor;
import hudson.console.ConsoleAnnotator;
import hudson.console.ConsoleNote;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.ItemGroup;
import hudson.model.Queue;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import java.io.IOException;
import java.util.List;
import jenkins.branch.Branch;
import jenkins.scm.api.SCMFileSystem;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMRevisionAction;
import jenkins.scm.api.SCMSource;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsScmFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinitionDescriptor;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.multibranch.BranchJobProperty;
import org.jenkinsci.plugins.workflow.multibranch.Messages;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class SCMBinder
extends FlowDefinition {
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Just for scripting.")
    public static boolean USE_HEAVYWEIGHT_CHECKOUT = Boolean.getBoolean(SCMBinder.class.getName() + ".USE_HEAVYWEIGHT_CHECKOUT");
    private String scriptPath = "Jenkinsfile";

    public Object readResolve() {
        if (this.scriptPath == null) {
            this.scriptPath = "Jenkinsfile";
        }
        return this;
    }

    public SCMBinder(String scriptPath) {
        this.scriptPath = scriptPath;
    }

    public FlowExecution create(FlowExecutionOwner handle, TaskListener listener, List<? extends Action> actions) throws Exception {
        SCM scm;
        Queue.Executable exec = handle.getExecutable();
        if (!(exec instanceof WorkflowRun)) {
            throw new IllegalStateException("inappropriate context");
        }
        WorkflowRun build = (WorkflowRun)exec;
        WorkflowJob job = (WorkflowJob)build.getParent();
        BranchJobProperty property = (BranchJobProperty)job.getProperty(BranchJobProperty.class);
        if (property == null) {
            throw new IllegalStateException("inappropriate context");
        }
        Branch branch = property.getBranch();
        ItemGroup parent = job.getParent();
        if (!(parent instanceof WorkflowMultiBranchProject)) {
            throw new IllegalStateException("inappropriate context");
        }
        SCMSource scmSource = ((WorkflowMultiBranchProject)parent).getSCMSource(branch.getSourceId());
        if (scmSource == null) {
            throw new IllegalStateException(branch.getSourceId() + " not found");
        }
        SCMHead head = branch.getHead();
        SCMRevision tip = scmSource.fetch(head, listener);
        if (tip != null) {
            SCMRevision rev;
            block18: {
                build.addAction((Action)new SCMRevisionAction(scmSource, tip));
                rev = scmSource.getTrustedRevision(tip, listener);
                try (SCMFileSystem fs = USE_HEAVYWEIGHT_CHECKOUT ? null : SCMFileSystem.of((SCMSource)scmSource, (SCMHead)head, (SCMRevision)rev);){
                    SCMFileSystem tipFS;
                    if (fs == null) break block18;
                    String script = null;
                    try {
                        script = fs.child(this.scriptPath).contentAsString();
                        listener.getLogger().println("Obtained " + this.scriptPath + " from " + String.valueOf(rev));
                    }
                    catch (IOException | InterruptedException x) {
                        listener.error("Could not do lightweight checkout, falling back to heavyweight").println(Functions.printThrowable((Throwable)x).trim());
                    }
                    if (script == null) break block18;
                    if (!rev.equals((Object)tip) && (tipFS = SCMFileSystem.of((SCMSource)scmSource, (SCMHead)head, (SCMRevision)tip)) != null) {
                        String tipScript = null;
                        try {
                            tipScript = tipFS.child(this.scriptPath).contentAsString();
                        }
                        catch (IOException | InterruptedException x) {
                            listener.error("Could not compare lightweight checkout of trusted revision").println(Functions.printThrowable((Throwable)x).trim());
                        }
                        if (tipScript != null && !script.equals(tipScript)) {
                            listener.annotate((ConsoleNote)new WarningNote());
                            listener.getLogger().println(Messages.ReadTrustedStep__has_been_modified_in_an_untrusted_revis(this.scriptPath));
                        }
                    }
                    CpsFlowExecution cpsFlowExecution = new CpsFlowDefinition(script, true).create(handle, listener, actions);
                    return cpsFlowExecution;
                }
            }
            scm = scmSource.build(head, rev);
        } else {
            listener.error("Could not determine exact tip revision of " + branch.getName() + "; falling back to nondeterministic checkout");
            scm = branch.getScm();
        }
        return new CpsScmFlowDefinition(scm, this.scriptPath).create(handle, listener, actions);
    }

    public static class WarningNote
    extends ConsoleNote {
        public ConsoleAnnotator annotate(Object context, MarkupText text, int charPos) {
            text.addMarkup(0, text.length(), "<span class='warning-inline'>", "</span>");
            return null;
        }

        @Extension
        public static final class DescriptorImpl
        extends ConsoleAnnotationDescriptor {
            @NonNull
            public String getDisplayName() {
                return "Multibranch warnings";
            }
        }
    }

    @Extension
    public static class HideMeElsewhere
    extends DescriptorVisibilityFilter {
        public boolean filter(Object context, @NonNull Descriptor descriptor) {
            if (descriptor instanceof DescriptorImpl) {
                return context instanceof WorkflowJob && ((WorkflowJob)context).getParent() instanceof WorkflowMultiBranchProject;
            }
            return true;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends FlowDefinitionDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Pipeline from multibranch configuration";
        }
    }
}

